/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.font.internal.l36I;

import com.aspose.font.internal.l23l.I07;
import com.aspose.font.internal.l23l.I111;
import com.aspose.font.internal.l23l.I11I;
import com.aspose.font.internal.l23l.I127;
import com.aspose.font.internal.l23l.I2I;
import com.aspose.font.internal.l23l.I31;
import com.aspose.font.internal.l23l.I37;
import com.aspose.font.internal.l23l.I3I;
import com.aspose.font.internal.l23l.I57;
import com.aspose.font.internal.l23l.I94;
import com.aspose.font.internal.l287.I0l;
import com.aspose.font.internal.l287.I1;
import com.aspose.font.internal.l287.II;
import com.aspose.font.internal.l304.I7;
import com.aspose.font.internal.l31I.I04;
import com.aspose.font.internal.l31I.I14;
import com.aspose.font.internal.l31I.I34;
import com.aspose.font.internal.l31I.I47;
import com.aspose.font.internal.l31I.I4I;
import com.aspose.font.internal.l31I.I6l;
import com.aspose.font.internal.l31I.Il;
import com.aspose.font.internal.l31l.I4;
import com.aspose.font.internal.l36I.I161l;
import com.aspose.font.internal.l36I.I163l;
import com.aspose.font.internal.l36I.I4l;
import com.aspose.font.internal.l381.I24;
import com.aspose.font.internal.l384.I0I;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

class I1624
extends X509Certificate {
    private final I4l lif;
    private final I14 ll;
    private final I04 lI;
    private final boolean[] l1;
    private volatile PublicKey lIF;
    private volatile boolean llf;
    private volatile int liF;

    public I1624(I4l i4l, I14 i14) throws CertificateParsingException {
        byte[] byArray;
        this.lif = i4l;
        this.ll = i14;
        try {
            byArray = this.lif("2.5.29.19");
            this.lI = byArray != null ? I04.lif(I3I.ll(byArray)) : null;
        }
        catch (Exception exception) {
            throw new CertificateParsingException("cannot construct BasicConstraints: " + exception);
        }
        try {
            byArray = this.lif("2.5.29.15");
            if (byArray != null) {
                I94 i94 = I94.lif(I3I.ll(byArray));
                int n = (byArray = i94.llf()).length * 8 - i94.liF();
                this.l1 = new boolean[n < 9 ? 9 : n];
                for (int i = 0; i != n; ++i) {
                    this.l1[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
                }
            } else {
                this.l1 = null;
            }
        }
        catch (Exception exception) {
            throw new CertificateParsingException("cannot construct KeyUsage: " + exception);
        }
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.getTime() > this.getNotAfter().getTime()) {
            throw new CertificateExpiredException("certificate expired on " + this.ll.liF().lif());
        }
        if (date.getTime() < this.getNotBefore().getTime()) {
            throw new CertificateNotYetValidException("certificate not valid till " + this.ll.llf().lif());
        }
    }

    public int getVersion() {
        return this.ll.lI();
    }

    public BigInteger getSerialNumber() {
        return this.ll.l1().ll();
    }

    public Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    public X500Principal getIssuerX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            I37 i37 = new I37(byteArrayOutputStream);
            i37.lif(this.ll.lIF());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN: " + iOException.getMessage(), iOException);
        }
    }

    public Principal getSubjectDN() {
        return this.getSubjectX500Principal();
    }

    public X500Principal getSubjectX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            I37 i37 = new I37(byteArrayOutputStream);
            i37.lif(this.ll.lIf());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN: " + iOException.getMessage(), iOException);
        }
    }

    public Date getNotBefore() {
        return this.ll.llf().ll();
    }

    public Date getNotAfter() {
        return this.ll.liF().ll();
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            return this.ll.lif().lif("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public byte[] getSignature() {
        return this.ll.l01().l1();
    }

    public String getSigAlgName() {
        Object object;
        I4l i4l = this.lif;
        if (i4l != null && (object = i4l.getProperty("Alg.Alias.Signature." + this.getSigAlgOID())) != null) {
            return object;
        }
        object = Security.getProviders();
        for (int i = 0; i != ((Provider[])object).length; ++i) {
            String string = object[i].getProperty("Alg.Alias.Signature." + this.getSigAlgOID());
            if (string == null) continue;
            return string;
        }
        return this.getSigAlgOID();
    }

    public String getSigAlgOID() {
        return this.ll.l0if().lif().ll();
    }

    public byte[] getSigAlgParams() {
        if (this.ll.l0if().ll() != null) {
            try {
                return this.ll.l0if().ll().l0l().lif("DER");
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    public boolean[] getIssuerUniqueID() {
        I94 i94 = this.ll.lif().l0if();
        if (i94 != null) {
            byte[] byArray = i94.llf();
            boolean[] blArray = new boolean[byArray.length * 8 - i94.liF()];
            for (int i = 0; i != blArray.length; ++i) {
                blArray[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    public boolean[] getSubjectUniqueID() {
        I94 i94 = this.ll.lif().l01();
        if (i94 != null) {
            byte[] byArray = i94.llf();
            boolean[] blArray = new boolean[byArray.length * 8 - i94.liF()];
            for (int i = 0; i != blArray.length; ++i) {
                blArray[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    public boolean[] getKeyUsage() {
        return this.l1;
    }

    public List getExtendedKeyUsage() throws CertificateParsingException {
        byte[] byArray = this.lif("2.5.29.37");
        if (byArray != null) {
            try {
                I31 i31 = I31.lif(byArray);
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i != i31.llf(); ++i) {
                    arrayList.add(((I2I)i31.lif(i)).ll());
                }
                return Collections.unmodifiableList(arrayList);
            }
            catch (Exception exception) {
                throw new CertificateParsingException("error processing extended key usage extension");
            }
        }
        return null;
    }

    public int getBasicConstraints() {
        if (this.lI != null) {
            if (this.lI.lif()) {
                if (this.lI.ll() == null) {
                    return Integer.MAX_VALUE;
                }
                return this.lI.ll().intValue();
            }
            return -1;
        }
        return -1;
    }

    public Collection getSubjectAlternativeNames() throws CertificateParsingException {
        return I1624.lif(this.lif(I34.lIF.ll()));
    }

    public Collection getIssuerAlternativeNames() throws CertificateParsingException {
        return I1624.lif(this.lif(I34.llf.ll()));
    }

    public Set getCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            I47 i47 = this.ll.lif().l0IF();
            if (i47 != null) {
                Enumeration enumeration = i47.lif();
                while (enumeration.hasMoreElements()) {
                    I2I i2I = (I2I)enumeration.nextElement();
                    I34 i34 = i47.lif(i2I);
                    if (!i34.ll()) continue;
                    hashSet.add(i2I.ll());
                }
                return hashSet;
            }
        }
        return null;
    }

    private byte[] lif(String string) {
        I34 i34;
        I47 i47 = this.ll.lif().l0IF();
        if (i47 != null && (i34 = i47.lif(new I2I(string))) != null) {
            return i34.lI().l1();
        }
        return null;
    }

    public byte[] getExtensionValue(String string) {
        I34 i34;
        I47 i47 = this.ll.lif().l0IF();
        if (i47 != null && (i34 = i47.lif(new I2I(string))) != null) {
            try {
                return i34.lI().l0I();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            I47 i47 = this.ll.lif().l0IF();
            if (i47 != null) {
                Enumeration enumeration = i47.lif();
                while (enumeration.hasMoreElements()) {
                    I2I i2I = (I2I)enumeration.nextElement();
                    I34 i34 = i47.lif(i2I);
                    if (i34.ll()) continue;
                    hashSet.add(i2I.ll());
                }
                return hashSet;
            }
        }
        return null;
    }

    public boolean hasUnsupportedCriticalExtension() {
        I47 i47;
        if (this.getVersion() == 3 && (i47 = this.ll.lif().l0IF()) != null) {
            Set set = this.getCriticalExtensionOIDs();
            set.removeAll(I161l.l0f);
            return !set.isEmpty();
        }
        return false;
    }

    public PublicKey getPublicKey() {
        try {
            if (this.lIF == null) {
                this.lIF = this.lif.lif(this.ll.lf());
            }
            return this.lIF;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            return this.ll.lif("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof I1624) {
            I1624 i1624 = (I1624)object;
            if (this.llf && i1624.llf && this.liF != i1624.liF) {
                return false;
            }
            return this.ll.equals(i1624.ll);
        }
        return super.equals(object);
    }

    public int hashCode() {
        if (!this.llf) {
            this.liF = super.hashCode();
            this.llf = true;
        }
        return this.liF;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = I24.ll();
        stringBuffer.append("  [0]         Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("         SerialNumber: ").append(this.getSerialNumber()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("           Start Date: ").append(this.getNotBefore()).append(string);
        stringBuffer.append("           Final Date: ").append(this.getNotAfter()).append(string);
        stringBuffer.append("            SubjectDN: ").append(this.getSubjectDN()).append(string);
        stringBuffer.append("           Public Key: ").append(this.getPublicKey()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(I24.ll(I0I.ll(byArray, 0, 20))).append(string);
        for (int i = 20; i < byArray.length; i += 20) {
            if (i < byArray.length - 20) {
                stringBuffer.append("                       ").append(I24.ll(I0I.ll(byArray, i, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(I24.ll(I0I.ll(byArray, i, byArray.length - i))).append(string);
        }
        I47 i47 = this.ll.lif().l0IF();
        if (i47 != null) {
            Enumeration enumeration = i47.lif();
            if (enumeration.hasMoreElements()) {
                stringBuffer.append("       Extensions: \n");
            }
            while (enumeration.hasMoreElements()) {
                I2I i2I = (I2I)enumeration.nextElement();
                I34 i34 = i47.lif(i2I);
                if (i34.lI() != null) {
                    byte[] byArray2 = i34.lI().l1();
                    stringBuffer.append("                       critical(").append(i34.ll()).append(") ");
                    try {
                        I3I i3I = I3I.ll(byArray2);
                        if (i2I.equals(I34.liF)) {
                            stringBuffer.append(I04.lif(i3I)).append(string);
                            continue;
                        }
                        if (i2I.equals(I34.lI)) {
                            stringBuffer.append(I6l.lif(i3I)).append(string);
                            continue;
                        }
                        if (i2I.equals(II.ll)) {
                            stringBuffer.append(new I1((I94)i3I)).append(string);
                            continue;
                        }
                        if (i2I.equals(II.l1)) {
                            stringBuffer.append(new com.aspose.font.internal.l287.I4((I11I)i3I)).append(string);
                            continue;
                        }
                        if (i2I.equals(II.l0l)) {
                            stringBuffer.append(new I0l((I11I)i3I)).append(string);
                            continue;
                        }
                        stringBuffer.append(i2I.ll());
                        stringBuffer.append(" value = ").append(I7.lif(i3I)).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(i2I.ll());
                        stringBuffer.append(" value = ").append("*****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public final void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String string = I163l.lif(this.ll.l0if());
        Signature signature = this.lif(this.lif, string);
        this.lif(publicKey, signature);
    }

    public final void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String string2 = I163l.lif(this.ll.l0if());
        Signature signature = string != null ? Signature.getInstance(string2, string) : Signature.getInstance(string2);
        this.lif(publicKey, signature);
    }

    public final void verify(PublicKey publicKey, Provider provider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        String string = I163l.lif(this.ll.l0if());
        Signature signature = this.lif(provider, string);
        this.lif(publicKey, signature);
    }

    private Signature lif(Provider provider, String string) throws NoSuchAlgorithmException {
        if (provider != null) {
            try {
                return Signature.getInstance(string, provider);
            }
            catch (Exception exception) {
                return Signature.getInstance(string);
            }
        }
        return Signature.getInstance(string);
    }

    private void lif(PublicKey publicKey, Signature signature) throws CertificateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (!this.lif(this.ll.l0if(), this.ll.lif().l1())) {
            throw new CertificateException("signature algorithm in TBS cert not same as outer cert");
        }
        I07 i07 = this.ll.l0if().ll();
        I163l.lif(signature, i07);
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertificate());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("certificate does not verify with supplied key");
        }
    }

    private boolean lif(Il il, Il il2) {
        if (!il.lif().equals(il2.lif())) {
            return false;
        }
        if (il.ll() == null) {
            return il2.ll() == null || il2.ll().equals(I111.lif);
        }
        if (il2.ll() == null) {
            return il.ll() == null || il.ll().equals(I111.lif);
        }
        return il.ll().equals(il2.ll());
    }

    private static Collection lif(byte[] byArray) throws CertificateParsingException {
        if (byArray == null) {
            return null;
        }
        try {
            ArrayList arrayList = new ArrayList();
            Enumeration enumeration = I31.lif(byArray).lI();
            block11: while (enumeration.hasMoreElements()) {
                I4I i4I = I4I.lif(enumeration.nextElement());
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                arrayList2.add(com.aspose.font.internal.l381.I0I.lif(i4I.lif()));
                switch (i4I.lif()) {
                    case 0: 
                    case 3: 
                    case 5: {
                        arrayList2.add(i4I.l0I());
                        break;
                    }
                    case 4: {
                        arrayList2.add(com.aspose.font.internal.l317.I1.lif(I4.l3If, i4I.ll()).toString());
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 6: {
                        arrayList2.add(((I57)((Object)i4I.ll())).ll());
                        break;
                    }
                    case 8: {
                        arrayList2.add(I2I.lif(i4I.ll()).ll());
                        break;
                    }
                    case 7: {
                        String string;
                        byte[] byArray2 = I127.lif(i4I.ll()).l1();
                        try {
                            string = InetAddress.getByAddress(byArray2).getHostAddress();
                        }
                        catch (UnknownHostException unknownHostException) {
                            continue block11;
                        }
                        arrayList2.add(string);
                        break;
                    }
                    default: {
                        throw new IOException("Bad tag number: " + i4I.lif());
                    }
                }
                arrayList.add(Collections.unmodifiableList(arrayList2));
            }
            if (arrayList.size() == 0) {
                return null;
            }
            return Collections.unmodifiableCollection(arrayList);
        }
        catch (Exception exception) {
            throw new CertificateParsingException(exception.getMessage());
        }
    }
}

