/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.font;

import com.aspose.font.ByteContentStreamSource;
import com.aspose.font.FontDefinition;
import com.aspose.font.FontException;
import com.aspose.font.FontFileDefinition;
import com.aspose.font.FontNotSupportedOperationException;
import com.aspose.font.FontSavingFormats;
import com.aspose.font.FontType;
import com.aspose.font.Glyph;
import com.aspose.font.GlyphId;
import com.aspose.font.GlyphIdType;
import com.aspose.font.GlyphStringId;
import com.aspose.font.GlyphUInt32Id;
import com.aspose.font.I174;
import com.aspose.font.I20l;
import com.aspose.font.I271;
import com.aspose.font.I291;
import com.aspose.font.I29I;
import com.aspose.font.I29l;
import com.aspose.font.I351;
import com.aspose.font.I371;
import com.aspose.font.I37I;
import com.aspose.font.I37l;
import com.aspose.font.I497;
import com.aspose.font.I661;
import com.aspose.font.IFont;
import com.aspose.font.IFontEncoding;
import com.aspose.font.IFontMetrics;
import com.aspose.font.IFontSaver;
import com.aspose.font.IGlyphAccessor;
import com.aspose.font.MultiLanguageString;
import com.aspose.font.StreamSource;
import com.aspose.font.TtfFont;
import com.aspose.font.internal.l21.I04;
import com.aspose.font.internal.l21.I1I;
import com.aspose.font.internal.l21.I2l;
import com.aspose.font.internal.l21.I31;
import com.aspose.font.internal.l21.I37;
import com.aspose.font.internal.l5I.I07;
import com.aspose.font.internal.l5I.I17;
import com.aspose.font.internal.l71I.I1;
import com.aspose.font.internal.l71l.II;
import com.aspose.font.internal.l71l.Il;
import com.aspose.font.internal.lI.I181;
import com.aspose.font.internal.lI.I7I;
import java.io.IOException;
import java.io.OutputStream;

public abstract class Font
implements IFont,
IFontSaver,
IGlyphAccessor {
    private static I351 lif;
    private I29I ll = new I29I();
    private static final int lI = 1;
    private static final int l1 = 2;
    private static I17 lIF;
    private static ThreadLocal<Boolean> llf;

    Font() {
    }

    public static Font open(FontDefinition fontDefinition) {
        try {
            I29l i29l = I29l.lif(fontDefinition.getFontType());
            return i29l.lif(fontDefinition);
        }
        catch (RuntimeException runtimeException) {
            lif.lif(I181.lif("Could not create font. \r\nFont definition: \r\n{0}", new Object[]{I20l.lif(fontDefinition)}), runtimeException);
            throw runtimeException;
        }
    }

    static Font lif(I37I i37I, I37l i37l) {
        try {
            FontDefinition fontDefinition = i37l.lif(i37I);
            if (fontDefinition != null) {
                return Font.open(fontDefinition);
            }
        }
        catch (RuntimeException runtimeException) {
            lif.lif(I181.lif("Could not find font. The IFontSearcher throwed exception {0}", new Object[]{runtimeException.toString()}));
        }
        return null;
    }

    public static Font open(FontType fontType, StreamSource fontStreamSource) {
        FontFileDefinition fontFileDefinition = new FontFileDefinition(fontStreamSource);
        FontDefinition fontDefinition = new FontDefinition(fontType, fontFileDefinition);
        return Font.open(fontDefinition);
    }

    public static Font open(FontType fontType, String fileName) {
        FontFileDefinition fontFileDefinition = new FontFileDefinition(new I1I(fileName));
        FontDefinition fontDefinition = new FontDefinition(fontType, fontFileDefinition);
        return Font.open(fontDefinition);
    }

    public static Font open(FontType fontType, byte[] fontData) {
        FontDefinition fontDefinition = new FontDefinition(fontType, new ByteContentStreamSource(fontData));
        return Font.open(fontDefinition);
    }

    static Font lif(FontType fontType) {
        if (fontType == FontType.TTF) {
            return TtfFont.lIf();
        }
        throw new FontNotSupportedOperationException();
    }

    static Font lif(FontType fontType, Font font, I271 i271) {
        if (fontType == FontType.TTF) {
            return TtfFont.lif(font, i271);
        }
        throw new FontNotSupportedOperationException();
    }

    void lif(I31 i31) {
        I291 i291 = I291.lif(this, i31, 0);
        i291.lif();
    }

    @Override
    public void save(OutputStream stream) {
        II.lif(new Il(stream){

            @Override
            public void lif(I31 i31) {
                Font.this.lif(i31);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(String fileName) {
        I2l i2l = I04.ll(fileName);
        try {
            I291 i291 = I291.lif(this, i2l, 0);
            i291.lif();
        }
        finally {
            if (i2l != null) {
                i2l.dispose();
            }
        }
    }

    @Override
    public void saveToFormat(OutputStream stream, FontSavingFormats outFormat) throws IOException {
        int n;
        I37 i37;
        TtfFont ttfFont = this instanceof TtfFont && ((TtfFont)((Object)I1.lif(this, TtfFont.class))).l1() == I497.lif ? (TtfFont)((Object)I1.lif(this, TtfFont.class)) : I174.lif().l1().lif(this).lif();
        I661 i661 = (I661)((Object)I1.lif(I291.lif(ttfFont, i37 = new I37(), 0), I661.class));
        if (i661 == null) {
            throw new FontException("Incorrect font saver passed when saving TTF font to format specified");
        }
        switch (outFormat) {
            case TTF: {
                i661.lif();
                break;
            }
            case WOFF: {
                i661.ll();
                break;
            }
            case WOFF2: {
                i661.lI();
            }
        }
        i37.lif(0L);
        byte[] byArray = new byte[4096];
        while ((n = i37.lif(byArray, 0, byArray.length)) > 0) {
            stream.write(byArray, 0, n);
        }
    }

    void lif(I31 i31, int n) {
        I291 i291 = I291.lif(this, i31, n);
        i291.lif();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lif(String string, int n) {
        I2l i2l = I04.ll(string);
        try {
            I291 i291 = I291.lif(this, i2l, n);
            i291.lif();
        }
        finally {
            if (i2l != null) {
                i2l.dispose();
            }
        }
    }

    @Override
    public abstract Font convert(FontType var1);

    abstract I371 lIF();

    static void lif(String string, String[] stringArray, String[] stringArray2) {
        stringArray[0] = string;
        stringArray2[0] = I181.lif;
        I07 i07 = lIF.ll(stringArray[0]);
        if (i07.lIF()) {
            stringArray[0] = i07.lIf().lif(2).lI();
            stringArray2[0] = i07.lIf().lif(1).lI();
        }
    }

    @Override
    public GlyphId[] getGlyphsForText(String text) {
        GlyphId[] glyphIdArray = new GlyphId[text.length()];
        for (int i = 0; i < text.length(); ++i) {
            GlyphId glyphId = this.getEncoding().unicodeToGid(text.charAt(i));
            if (glyphId == null) {
                glyphId = this.getGlyphIdType() == GlyphIdType.Int32Index ? GlyphUInt32Id.getNotDefId() : GlyphStringId.getNotDefId();
            }
            glyphIdArray[i] = glyphId;
        }
        return glyphIdArray;
    }

    @Override
    public abstract FontType getFontType();

    @Override
    public abstract String getStyle();

    @Override
    public abstract void setStyle(String var1);

    @Override
    public abstract int getFontStyle();

    @Override
    public abstract String getFontFamily();

    @Override
    public abstract void setFontFamily(String var1);

    @Override
    public abstract String getFontName();

    @Override
    public abstract void setFontName(String var1);

    @Override
    public abstract MultiLanguageString getFontNames();

    abstract void lif(MultiLanguageString var1);

    @Override
    public abstract MultiLanguageString getPostscriptNames();

    abstract void ll(MultiLanguageString var1);

    @Override
    public abstract int getNumGlyphs();

    @Override
    public abstract IFontMetrics getMetrics();

    @Override
    public abstract IFontEncoding getEncoding();

    @Override
    public IGlyphAccessor getGlyphAccessor() {
        return this;
    }

    @Override
    public abstract Glyph getGlyphById(GlyphId var1);

    @Override
    public abstract GlyphId[] getAllGlyphIds();

    @Override
    public abstract GlyphIdType getGlyphIdType();

    @Override
    public abstract FontDefinition getFontDefinition();

    @Override
    public IFontSaver getFontSaver() {
        return this;
    }

    I29I l0if() {
        return this.ll;
    }

    static int lIF(String string) {
        int n = 0;
        if (string != null) {
            String string2 = string.toLowerCase();
            if (string2.indexOf("italic") != -1) {
                n |= 4;
            }
            if (string2.indexOf("bold") != -1) {
                n |= 2;
            }
        }
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    static {
        lIF = new I17("([A-Z]{6})\\+(.*)?");
        llf = new ThreadLocal();
        llf.set(false);
        lif = I174.lif().ll().lif();
    }

    static final class I7
    extends I7I {
        public static final byte lif = 0;
        public static final byte ll = 1;

        private I7() {
        }

        static {
            I7I.register(new I7I.I4((Class)I7.class, Byte.class){
                {
                    this.lif("SaveAllTables", 0L);
                    this.lif("SavePdfTables", 1L);
                }
            });
        }
    }
}

