/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cells;

import com.aspose.cells.a.a.p;
import com.aspose.cells.a.c.l;
import com.aspose.cells.a.c.x;
import com.aspose.cells.b.a.f.e;
import com.aspose.cells.b.a.f.n;
import com.aspose.cells.b.a.f.w;
import com.aspose.cells.xj;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

public class Encoding {
    private int b;
    private String c;
    private String d;
    private Charset e = null;
    private ThreadLocal<CharsetDecoder> f = new xj(this);
    private CharsetEncoder g = null;

    public static Encoding getASCII() {
        return new Encoding(20127, "US-ASCII", "us-ascii");
    }

    public static Encoding getUTF7() {
        return new Encoding(65000, "UTF-7", "utf-7");
    }

    public static Encoding getUTF8() {
        return new n(true);
    }

    public static Encoding getUTF8NoBOM() {
        return new n(false);
    }

    public static Encoding getUnicode() {
        return new Encoding(1200, "UTF-16LE", "utf-16");
    }

    public static Encoding getBigEndianUnicode() {
        return new Encoding(1201, "UTF-16BE", "unicodeFFFE");
    }

    protected Encoding(int codePage, String charsetName, String headerName) {
        this.b = codePage;
        this.c = charsetName;
        this.d = headerName;
    }

    public static Encoding a(boolean bl2, boolean bl3) {
        if (bl2) {
            return Encoding.getBigEndianUnicode();
        }
        return Encoding.getUnicode();
    }

    public static Encoding getDefault() {
        return Encoding.getEncoding(Charset.defaultCharset().name());
    }

    public static Encoding b(boolean bl2, boolean bl3) {
        throw new UnsupportedOperationException("UTF32 Encoding not supported in java version.");
    }

    public static Encoding getEncoding(int codePage) {
        for (e e2 : com.aspose.cells.b.a.f.e.a()) {
            if (e2.T != codePage) continue;
            return new Encoding(codePage, e2.U, e2.V);
        }
        return Encoding.getUTF8();
    }

    public static Encoding getEncoding(String charsetName) {
        Charset charset;
        x.b(charsetName, "charsetName");
        for (e e2 : com.aspose.cells.b.a.f.e.a()) {
            if (!charsetName.equalsIgnoreCase(e2.U)) continue;
            return new Encoding(e2.T, e2.U, e2.V);
        }
        Object var1_2 = null;
        try {
            charset = Charset.forName(charsetName);
        }
        catch (Exception exception) {
            if (p.a()) {
                p.a("GetEncoding(" + charsetName + ")-" + p.a(exception));
            }
            return Encoding.getUTF8();
        }
        Encoding encoding = new Encoding(0, charsetName, charsetName.toLowerCase());
        encoding.e = charset;
        return encoding;
    }

    public static Encoding getEncoding(Charset charset) {
        String string = charset.displayName();
        for (e e2 : com.aspose.cells.b.a.f.e.a()) {
            if (!string.equalsIgnoreCase(e2.U)) continue;
            return new Encoding(e2.T, e2.U, e2.V);
        }
        Encoding encoding = new Encoding(0, string, string.toLowerCase());
        encoding.e = charset;
        return encoding;
    }

    public String a() {
        return this.d;
    }

    public String b() {
        return this.c;
    }

    public com.aspose.cells.b.a.f.l c() {
        return new com.aspose.cells.b.a.f.l(this.h());
    }

    CharsetDecoder d() {
        return this.f.get();
    }

    public w e() throws Exception {
        return new w(this.h());
    }

    CharsetEncoder f() throws Exception {
        if (this.g == null) {
            this.g = this.h().newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        return this.g;
    }

    public int a(int n2) throws Exception {
        return (int)((float)n2 * this.f().maxBytesPerChar());
    }

    public byte[] g() {
        switch (this.b) {
            case 65001: {
                return new byte[]{-17, -69, -65};
            }
            case 1200: {
                return new byte[]{-1, -2};
            }
            case 1201: {
                return new byte[]{-2, -1};
            }
        }
        return new byte[0];
    }

    public int a(String string, int n2, int n3, byte[] byArray, int n4) {
        ByteBuffer byteBuffer = this.h().encode(CharBuffer.wrap(string, n2, n2 + n3));
        int n5 = byteBuffer.remaining();
        byteBuffer.get(byArray, n4, n5);
        return n5;
    }

    public int a(char[] cArray, int n2, int n3, byte[] byArray, int n4) {
        CharBuffer charBuffer = CharBuffer.wrap(cArray, n2, n3);
        ByteBuffer byteBuffer = this.h().encode(charBuffer);
        int n5 = byteBuffer.remaining();
        byteBuffer.get(byArray, n4, n5);
        return n5;
    }

    public byte[] a(String string) {
        ByteBuffer byteBuffer = this.h().encode(string);
        return this.a(byteBuffer);
    }

    public byte[] a(char[] cArray) {
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        ByteBuffer byteBuffer = this.h().encode(charBuffer);
        return this.a(byteBuffer);
    }

    public byte[] a(char[] cArray, int n2, int n3) {
        CharBuffer charBuffer = CharBuffer.wrap(cArray, n2, n3);
        ByteBuffer byteBuffer = this.h().encode(charBuffer);
        return this.a(byteBuffer);
    }

    public int b(String string) {
        byte[] byArray = this.a(string);
        if (byArray != null) {
            return byArray.length;
        }
        return 0;
    }

    private byte[] a(ByteBuffer byteBuffer) {
        byte[] byArray = byteBuffer.array();
        int n2 = byteBuffer.remaining();
        if (n2 == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public String a(byte[] byArray, int n2, int n3) {
        l.a(byArray, n2, n3);
        if (n3 == 0) {
            return "";
        }
        try {
            CharBuffer charBuffer = this.d().decode(ByteBuffer.wrap(byArray, n2, n3));
            return charBuffer.toString();
        }
        catch (Exception exception) {
            this.a(exception);
            return "";
        }
    }

    private void a(Exception exception) {
        throw new IllegalStateException("Invalid encoding: " + exception.getMessage(), exception);
    }

    public String a(byte[] byArray) {
        try {
            CharBuffer charBuffer = this.d().decode(ByteBuffer.wrap(byArray));
            return charBuffer.toString();
        }
        catch (Exception exception) {
            this.a(exception);
            return "";
        }
    }

    public Charset h() {
        if (this.e != null) {
            return this.e;
        }
        try {
            this.e = Charset.forName(this.c);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException(illegalArgumentException);
        }
        return this.e;
    }

    public boolean equals(Object o2) {
        return o2 instanceof Encoding && this.equals((Encoding)o2);
    }

    public boolean equals(Encoding other) {
        return this.c.equalsIgnoreCase(other.c);
    }

    public int i() {
        return this.b;
    }
}

