/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.FVector3;
import com.aspose.threed.Vector4;
import com.aspose.threed.a;
import com.aspose.threed.utils.BitUtils;
import com.aspose.threed.utils.Struct;
import java.awt.Color;
import java.io.Serializable;

public final class Vector3
implements Struct<Vector3>,
Serializable,
Comparable<Vector3> {
    public double x;
    public double y;
    public double z;
    public static final Vector3 ORIGIN = new Vector3(0.0, 0.0, 0.0);
    public static final Vector3 UNIT_SCALE = new Vector3(1.0, 1.0, 1.0);
    public static final Vector3 X_AXIS = new Vector3(1.0, 0.0, 0.0);
    public static final Vector3 Y_AXIS = new Vector3(0.0, 1.0, 0.0);
    public static final Vector3 Z_AXIS = new Vector3(0.0, 0.0, 1.0);
    static final long serialVersionUID = 264599303L;

    /*
     * WARNING - void declaration
     */
    public Vector3(double x2, double y2, double z2) {
        void var3_2;
        void var1_1;
        this.x = var1_1;
        this.y = var3_2;
        this.z = z2;
    }

    /*
     * WARNING - void declaration
     */
    public Vector3(FVector3 vec) {
        void var1_1;
        this.x = vec.x;
        this.y = vec.y;
        this.z = var1_1.z;
    }

    /*
     * WARNING - void declaration
     */
    public Vector3(Color color) {
        void var1_1;
        this.x = (float)color.getRed() / 255.0f;
        this.y = (float)color.getGreen() / 255.0f;
        this.z = (float)var1_1.getBlue() / 255.0f;
    }

    /*
     * WARNING - void declaration
     */
    public Vector3(double v2) {
        void var1_1;
        this.z = v2;
        this.y = v2;
        this.x = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Vector3(Vector4 vec4) {
        void var1_1;
        this.x = vec4.x;
        this.y = vec4.y;
        this.z = var1_1.z;
    }

    public final boolean equals(Object obj) {
        Vector3 vector3;
        if (!(obj instanceof Vector3)) {
            return false;
        }
        vector3 = ((Vector3)vector3).clone();
        return this.x == vector3.x && this.y == vector3.y && this.z == vector3.z;
    }

    public static FVector3 create(Vector3 v2) {
        Vector3 vector3;
        return new FVector3((float)v2.x, (float)v2.y, (float)vector3.z);
    }

    final void a(Vector3 vector3) {
        if (vector3.x < this.x) {
            this.x = vector3.x;
        }
        if (vector3.y < this.y) {
            this.y = vector3.y;
        }
        if (vector3.z < this.z) {
            this.z = vector3.z;
        }
    }

    final void a(double d2, double d3, double d4) {
        if (d2 < this.x) {
            this.x = d2;
        }
        if (d3 < this.y) {
            this.y = d3;
        }
        if (d4 < this.z) {
            this.z = d4;
        }
    }

    final void b(Vector3 vector3) {
        if (vector3.x > this.x) {
            this.x = vector3.x;
        }
        if (vector3.y > this.y) {
            this.y = vector3.y;
        }
        if (vector3.z > this.z) {
            this.z = vector3.z;
        }
    }

    final void b(double d2, double d3, double d4) {
        if (d2 > this.x) {
            this.x = d2;
        }
        if (d3 > this.y) {
            this.y = d3;
        }
        if (d4 > this.z) {
            this.z = d4;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final double dot(Vector3 rhs) {
        void var1_1;
        return this.x * rhs.x + this.y * rhs.y + this.z * var1_1.z;
    }

    public final Vector3 normalize() {
        double d2;
        double d3 = this.getLength();
        if (d2 > 0.0) {
            double d4 = 1.0 / d3;
            return new Vector3(this.x * d4, this.y * d4, this.z * d4);
        }
        return this.clone();
    }

    public final double getLength2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    static double c(double d2, double d3, double d4) {
        double d5 = d2;
        double d6 = d3;
        double d7 = d4;
        return Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7);
    }

    final boolean a(Vector3 vector3, double d2) {
        double d3 = this.x - vector3.x;
        double d4 = this.y - vector3.y;
        double d5 = this.z - vector3.z;
        if (Math.abs(d3) > (double)1.0E-9f) {
            return false;
        }
        if (Math.abs(d4) > (double)1.0E-9f) {
            return false;
        }
        return !(Math.abs(d5) > (double)1.0E-9f);
    }

    public final double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    final boolean a() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public final Vector3 sin() {
        return new Vector3(Math.sin(this.x), Math.sin(this.y), Math.sin(this.z));
    }

    public final Vector3 cos() {
        return new Vector3(Math.cos(this.x), Math.cos(this.y), Math.cos(this.z));
    }

    /*
     * WARNING - void declaration
     */
    public final Vector3 cross(Vector3 rhs) {
        void var1_1;
        return new Vector3(this.y * rhs.z - this.z * rhs.y, this.z * rhs.x - this.x * rhs.z, this.x * rhs.y - this.y * var1_1.x);
    }

    final Vector3 d(double d2, double d3, double d4) {
        return new Vector3(this.y * d4 - this.z * d3, this.z * d2 - this.x * d4, this.x * d3 - this.y * d2);
    }

    public static Vector3 negative(Vector3 v2) {
        Vector3 vector3;
        return new Vector3(-v2.x, -v2.y, -vector3.z);
    }

    /*
     * WARNING - void declaration
     */
    public static Vector3 sub(Vector3 lhs, Vector3 rhs) {
        void var1_1;
        Vector3 vector3;
        return new Vector3(lhs.x - rhs.x, lhs.y - rhs.y, vector3.z - var1_1.z);
    }

    /*
     * WARNING - void declaration
     */
    public static Vector3 add(Vector3 lhs, Vector3 rhs) {
        void var1_1;
        Vector3 vector3;
        return new Vector3(lhs.x + rhs.x, lhs.y + rhs.y, vector3.z + var1_1.z);
    }

    /*
     * WARNING - void declaration
     */
    public static Vector3 mul(Vector3 lhs, Vector3 rhs) {
        void var1_1;
        Vector3 vector3;
        return new Vector3(lhs.x * rhs.x, lhs.y * rhs.y, vector3.z * var1_1.z);
    }

    /*
     * WARNING - void declaration
     */
    public static Vector3 mul(double lhs, Vector3 rhs) {
        void var2_1;
        double d2;
        return new Vector3(lhs * rhs.x, lhs * rhs.y, d2 * var2_1.z);
    }

    /*
     * WARNING - void declaration
     */
    public static Vector3 mul(Vector3 lhs, double rhs) {
        void var1_1;
        Vector3 vector3;
        return new Vector3(lhs.x * rhs, lhs.y * rhs, vector3.z * var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Vector3 div(Vector3 lhs, double rhs) {
        Vector3 vector3;
        void var1_1;
        double d2 = 1.0 / var1_1;
        return new Vector3(lhs.x * d2, lhs.y * d2, vector3.z * d2);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean op_eq(Vector3 lhs, Vector3 rhs) {
        void var1_1;
        Vector3 vector3;
        return lhs.x == rhs.x && lhs.y == rhs.y && vector3.z == var1_1.z;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean op_ne(Vector3 lhs, Vector3 rhs) {
        void var1_1;
        Vector3 vector3;
        return lhs.x != rhs.x || lhs.y != rhs.y || vector3.z != var1_1.z;
    }

    /*
     * WARNING - void declaration
     */
    public final void set(double newX, double newY, double newZ) {
        void var3_2;
        void var1_1;
        this.x = var1_1;
        this.y = var3_2;
        this.z = newZ;
    }

    public final String toString() {
        return String.format("(%.0f %.0f %.0f)", this.x, this.y, this.z);
    }

    final boolean c(Vector3 vector3) {
        double d2 = Math.abs(this.x - vector3.x);
        double d3 = Math.abs(this.y - vector3.y);
        double d4 = Math.abs(this.z - vector3.z);
        return d2 < 1.0E-10 && d3 < 1.0E-10 && d4 < 1.0E-10;
    }

    /*
     * WARNING - void declaration
     */
    public final double angleBetween(Vector3 dir, Vector3 up) {
        void var2_2;
        Vector3 vector3;
        Vector3 vector32;
        double d2 = this.dot(dir) / Math.sqrt(this.getLength2() * dir.getLength2());
        if (a.a(Math.abs(d2) - 1.0)) {
            if (d2 > 0.0) {
                return 0.0;
            }
            return Math.PI;
        }
        double d3 = Math.acos(d2);
        vector32 = this.cross(vector32);
        if (vector3.dot((Vector3)var2_2) > 0.0) {
            return d3;
        }
        return Math.PI * 2 - d3;
    }

    /*
     * WARNING - void declaration
     */
    public final double angleBetween(Vector3 dir) {
        void var1_1;
        double d2 = this.dot(dir) / Math.sqrt(this.getLength2() * var1_1.getLength2());
        if (a.a(Math.abs(d2) - 1.0)) {
            if (d2 > 0.0) {
                return 0.0;
            }
            return Math.PI;
        }
        return Math.acos(d2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(Vector3 other) {
        void var1_1;
        int n2 = Double.compare(this.x, other.x);
        if (n2 != 0) {
            return n2;
        }
        n2 = Double.compare(this.y, other.y);
        if (n2 != 0) {
            return n2;
        }
        n2 = Double.compare(this.z, var1_1.z);
        return n2;
    }

    public Vector3() {
    }

    /*
     * WARNING - void declaration
     */
    private Vector3(Vector3 other) {
        void var1_1;
        this.x = other.x;
        this.y = other.y;
        this.z = var1_1.z;
    }

    @Override
    public final Vector3 clone() {
        return new Vector3(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void copyFrom(Vector3 src) {
        void var1_1;
        if (src == null) {
            return;
        }
        this.x = src.x;
        this.y = src.y;
        this.z = var1_1.z;
    }

    public final int hashCode() {
        return BitUtils.hashCode(this.x) ^ BitUtils.hashCode(this.y) ^ BitUtils.hashCode(this.z);
    }
}

