/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.BoundingBox;
import com.aspose.threed.Matrix4;
import com.aspose.threed.Mesh;
import com.aspose.threed.Primitive;
import com.aspose.threed.Vector3;
import com.aspose.threed.Vector4;
import com.aspose.threed.io;

public class Torus
extends Primitive {
    private double radius;
    private double tube;
    private int radialSegments;
    private int tubularSegments;
    private double arc;

    public Torus() {
        this(1.0, 0.4);
    }

    /*
     * WARNING - void declaration
     */
    public Torus(double radius, double tube) {
        this("", (double)var1_1, (double)var3_2, 10, 8, Math.PI * 2);
        void var3_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Torus(double radius, double tube, double arc) {
        this("", (double)var1_1, (double)var3_2, 10, 8, arc);
        void var3_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Torus(String name, double radius, double tube, int radialSegments, int tubularSegments, double arc) {
        super((String)var1_1);
        void var2_2;
        void var1_1;
        this.radius = var2_2;
        this.tube = tube;
        this.setRadialSegments(radialSegments);
        this.setTubularSegments(tubularSegments);
        if (arc == 0.0) {
            throw new IllegalArgumentException("The parameter arc cannot be zero.");
        }
        this.arc = arc;
    }

    public double getRadius() {
        return this.radius;
    }

    /*
     * WARNING - void declaration
     */
    public void setRadius(double value) {
        void var1_1;
        this.radius = var1_1;
    }

    public double getTube() {
        return this.tube;
    }

    /*
     * WARNING - void declaration
     */
    public void setTube(double value) {
        void var1_1;
        this.tube = var1_1;
    }

    public int getRadialSegments() {
        return this.radialSegments;
    }

    /*
     * WARNING - void declaration
     */
    public void setRadialSegments(int value) {
        void var1_1;
        this.radialSegments = Math.max(3, (int)var1_1);
    }

    public int getTubularSegments() {
        return this.tubularSegments;
    }

    /*
     * WARNING - void declaration
     */
    public void setTubularSegments(int value) {
        void var1_1;
        this.tubularSegments = Math.max(2, (int)var1_1);
    }

    public double getArc() {
        return this.arc;
    }

    /*
     * WARNING - void declaration
     */
    public void setArc(double value) {
        void var1_1;
        this.arc = var1_1;
    }

    @Override
    final BoundingBox a(Matrix4 matrix4) {
        BoundingBox boundingBox = new BoundingBox();
        boolean bl2 = matrix4.a();
        for (int i2 = 0; i2 <= this.radialSegments; ++i2) {
            for (int i3 = 0; i3 <= this.tubularSegments; ++i3) {
                double d2 = 1.0 * (double)i3 / (double)this.tubularSegments * this.arc;
                double d3 = 1.0 * (double)i2 / (double)this.radialSegments * Math.PI * 2.0;
                double d4 = (this.radius + this.tube) * Math.cos(d2);
                double d5 = (this.radius + this.tube) * Math.sin(d2);
                double d6 = this.tube * Math.sin(d3);
                if (bl2) {
                    boundingBox.a(d4, d5, d6);
                    continue;
                }
                boundingBox.a(Matrix4.mul(matrix4, new Vector4(d4, d5, d6, 1.0)));
            }
        }
        return boundingBox;
    }

    @Override
    public Mesh toMesh() {
        int n2;
        int n3;
        Mesh mesh = this.createEmptyMesh();
        int n4 = (this.radialSegments + 1) * (this.tubularSegments + 1);
        Vector4[] vector4Array = (Vector4[])io.d.newArray(n4);
        Vector4[] vector4Array2 = (Vector4[])io.d.newArray(n4);
        Vector4[] vector4Array3 = (Vector4[])io.d.newArray(n4);
        int n5 = 0;
        Vector4 vector4 = new Vector4(0.0, 0.0, 0.0, 1.0);
        Vector4 vector42 = new Vector4(0.0, 0.0, 0.0, 1.0);
        double d2 = Math.max(this.tube, 1.0E-6);
        for (n3 = 0; n3 <= this.radialSegments; ++n3) {
            for (n2 = 0; n2 <= this.tubularSegments; ++n2) {
                double d3 = 1.0 * (double)n2 / (double)this.tubularSegments * this.arc;
                double d4 = 1.0 * (double)n3 / (double)this.radialSegments * Math.PI * 2.0;
                double d5 = Math.cos(d4);
                double d6 = Math.cos(d3);
                Math.sin(d4);
                double d7 = Math.sin(d3);
                vector42.x = (this.radius + d2 * d5) * d6;
                vector42.y = (this.radius + d2 * d5) * d7;
                vector42.z = d2 * Math.sin(d4);
                vector4Array[n5] = vector42.clone();
                vector4.x = this.radius * d6;
                vector4.y = this.radius * d7;
                vector4Array2[n5] = new Vector4(new Vector3(Vector4.sub(vector42, vector4)).normalize());
                vector4Array3[n5] = new Vector4(1.0 * (double)n2 / (double)this.tubularSegments, 1.0 * (double)n3 / (double)this.radialSegments, 0.0, 0.0);
                ++n5;
            }
        }
        for (n3 = 1; n3 <= this.radialSegments; ++n3) {
            for (n2 = 1; n2 <= this.tubularSegments; ++n2) {
                int n6 = (this.tubularSegments + 1) * n3 + n2 - 1;
                int n7 = (this.tubularSegments + 1) * (n3 - 1) + n2 - 1;
                int n8 = (this.tubularSegments + 1) * (n3 - 1) + n2;
                int n9 = (this.tubularSegments + 1) * n3 + n2;
                mesh.createPolygon(n6, n7, n8, n9);
            }
        }
        Primitive.setup(mesh, vector4Array, vector4Array2, vector4Array3);
        return mesh;
    }
}

