/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.A3DObject;
import com.aspose.threed.AnimationClip;
import com.aspose.threed.AssetInfo;
import com.aspose.threed.Camera;
import com.aspose.threed.Cancellation;
import com.aspose.threed.Entity;
import com.aspose.threed.FileFormat;
import com.aspose.threed.IOConfig;
import com.aspose.threed.IRenderTexture;
import com.aspose.threed.ITexture2D;
import com.aspose.threed.ImageRenderOptions;
import com.aspose.threed.ImportException;
import com.aspose.threed.LoadOptions;
import com.aspose.threed.Node;
import com.aspose.threed.Pose;
import com.aspose.threed.RelativeRectangle;
import com.aspose.threed.RenderParameters;
import com.aspose.threed.Renderer;
import com.aspose.threed.SaveOptions;
import com.aspose.threed.SceneObject;
import com.aspose.threed.bF;
import com.aspose.threed.cZ;
import com.aspose.threed.eV;
import com.aspose.threed.fm;
import com.aspose.threed.io;
import com.aspose.threed.jk;
import com.aspose.threed.jl;
import com.aspose.threed.lS;
import com.aspose.threed.lz;
import com.aspose.threed.nS;
import com.aspose.threed.nx;
import com.aspose.threed.pb;
import com.aspose.threed.utils.AsposeUtils;
import com.aspose.threed.utils.EventCallback;
import com.aspose.threed.utils.FileStream;
import com.aspose.threed.utils.MemoryStream;
import com.aspose.threed.utils.MulticastEvent;
import com.aspose.threed.utils.Stream;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;

public class Scene
extends SceneObject {
    public static final String VERSION = "23.3";
    private AnimationClip currentAnimationClip;
    private AssetInfo assetInfo;
    private jk<A3DObject> library;
    private jk<AnimationClip> animationClips;
    private List<Scene> subScenes;
    pb ventureLicense;
    Node rootNode;
    Collection<Pose> poses;
    Collection<bF> constraints;
    boolean hasLightChanges;
    String fileName;
    Object[] raiseTrialExceptions;
    WeakReference<Object> renderer;

    public Scene() {
        this(null, "");
    }

    /*
     * WARNING - void declaration
     */
    public Scene(Entity entity) {
        this(null, "");
        void var1_1;
        if (entity == null) {
            throw new IllegalArgumentException("Argument entity cannot be null");
        }
        this.getRootNode().createChildNode((Entity)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Scene(Scene parentScene2, String name) {
        super(name);
        void var2_3;
        Scene scene = this;
        try {
            scene.raiseTrialExceptions = new Object[1];
            scene.renderer = new WeakReference<Object>(null);
        }
        catch (Exception parentScene2) {
            throw new RuntimeException(parentScene2);
        }
        this.b();
        this.setName((String)var2_3);
        this.scene = parentScene2;
        if (parentScene2 != null) {
            void var1_1;
            var1_1.subScenes.add(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public Scene(String fileName) throws IOException {
        this(null, "");
        void var1_1;
        if (fileName == null) {
            throw new IllegalArgumentException("Argument fileName cannot be null");
        }
        this.open((String)var1_1);
    }

    final void b() {
        this.properties = null;
        this.setName("");
        this.scene = null;
        this._objectId = -1L;
        this.currentAnimationClip = null;
        this.assetInfo = new AssetInfo("");
        this.animationClips = new jk(1);
        Scene scene = this;
        this.animationClips.b = MulticastEvent.Subscribe(this.animationClips.b, new EventCallback<jl<AnimationClip>>(this, scene){
            private /* synthetic */ Scene a;
            {
                this.a = scene2;
            }

            @Override
            public final /* synthetic */ void call(Object object, Object object2) {
                jl jl2 = (jl)object2;
                object2 = object;
                object = this;
                Scene.a(object.a, object2, jl2);
            }
        });
        scene = this;
        this.animationClips.c = MulticastEvent.Subscribe(this.animationClips.c, new EventCallback<jl<AnimationClip>>(this, scene){
            private /* synthetic */ Scene a;
            {
                this.a = scene2;
            }

            @Override
            public final /* synthetic */ void call(Object object, Object object2) {
                jl jl2 = (jl)object2;
                object2 = object;
                object = this;
                Scene.b(object.a, object2, jl2);
            }
        });
        this.subScenes = new ArrayList<Scene>();
        this.library = new jk(10);
        scene = this;
        this.library.b = MulticastEvent.Subscribe(this.library.b, new EventCallback<jl<A3DObject>>(this, scene){
            private /* synthetic */ Scene a;
            {
                this.a = scene2;
            }

            @Override
            public final /* synthetic */ void call(Object object, Object object2) {
                jl jl2 = (jl)object2;
                object2 = object;
                object = this;
                Scene.c(object.a, object2, jl2);
            }
        });
        scene = this;
        this.library.c = MulticastEvent.Subscribe(this.library.c, new EventCallback<jl<A3DObject>>(this, scene){
            private /* synthetic */ Scene a;
            {
                this.a = scene2;
            }

            @Override
            public final /* synthetic */ void call(Object object, Object object2) {
                jl jl2 = (jl)object2;
                object2 = object;
                object = this;
                Scene.d(object.a, object2, jl2);
            }
        });
        this.rootNode = new Node("RootNode");
        this.rootNode.scene = this;
        this.rootNode._objectId = -1L;
        this.poses = new nx<A3DObject, Pose>(this.library);
        this.constraints = new nx<A3DObject, bF>(this.library);
        this.hasLightChanges = true;
        this.fileName = null;
    }

    public List<Scene> getSubScenes() {
        return this.subScenes;
    }

    public List<A3DObject> getLibrary() {
        return this.library;
    }

    public List<AnimationClip> getAnimationClips() {
        return this.animationClips;
    }

    public AnimationClip getCurrentAnimationClip() {
        return this.currentAnimationClip;
    }

    /*
     * WARNING - void declaration
     */
    public void setCurrentAnimationClip(AnimationClip value) {
        void var1_1;
        this.currentAnimationClip = var1_1;
    }

    public AnimationClip getAnimationClip(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        for (AnimationClip animationClip : this.animationClips) {
            if (!name.equals(animationClip.getName())) continue;
            return animationClip;
        }
        return null;
    }

    public AssetInfo getAssetInfo() {
        return this.assetInfo;
    }

    /*
     * WARNING - void declaration
     */
    public void setAssetInfo(AssetInfo value) {
        void var1_1;
        this.assetInfo = var1_1;
    }

    public Collection<Pose> getPoses() {
        return this.poses;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public void clear() {
        this.b();
    }

    public AnimationClip createAnimationClip(String name) {
        AnimationClip animationClip;
        if (name == null) {
            throw new IllegalArgumentException(cZ.j());
        }
        animationClip = new AnimationClip((String)((Object)animationClip));
        this.animationClips.add(animationClip);
        if (this.currentAnimationClip == null) {
            this.currentAnimationClip = animationClip;
        }
        return animationClip;
    }

    protected void reloadSceneAs(FileFormat fmt) throws IOException {
        try (MemoryStream memoryStream = new MemoryStream();){
            fm fm2;
            lS.a(this, memoryStream, fmt.createSaveOptions(), null);
            fm2 = new fm(this, memoryStream, ((FileFormat)((Object)fm2)).createLoadOptions());
            lS.a(fm2, (Cancellation)null);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void open(Stream stream, FileFormat format, Cancellation cancellationToken) throws IOException {
        void var3_3;
        void var1_1;
        LoadOptions loadOptions;
        if (stream == null) {
            throw new IllegalArgumentException("Argument stream cannot be null");
        }
        if (format == null) {
            throw new IllegalArgumentException("Argument format cannot be null");
        }
        loadOptions = ((FileFormat)((Object)loadOptions)).createLoadOptions();
        this.open((Stream)var1_1, loadOptions, (Cancellation)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void open(Stream stream, FileFormat format) throws IOException {
        void var2_2;
        void var1_1;
        this.open((Stream)var1_1, (FileFormat)var2_2, io.a.defaultValue());
    }

    /*
     * WARNING - void declaration
     */
    public void open(Stream stream, LoadOptions options, Cancellation cancellationToken) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        Object object;
        if (stream == null) {
            throw new IllegalArgumentException("Argument stream cannot be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("Argument options cannot be null");
        }
        if (options.b == null) {
            object = eV.a().a(options.getFileName(), stream);
            if (object == null) {
                throw new ImportException(cZ.i());
            }
            options.b = object;
        }
        object = new fm(this, new nS((Stream)var1_1), (LoadOptions)var2_2);
        lS.a((fm)object, (Cancellation)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void open(Stream stream, LoadOptions options) throws IOException {
        void var2_2;
        void var1_1;
        this.open((Stream)var1_1, (LoadOptions)var2_2, io.a.defaultValue());
    }

    /*
     * WARNING - void declaration
     */
    public void open(Stream stream) throws IOException {
        void var1_1;
        this.open((Stream)var1_1, (Cancellation)null);
    }

    /*
     * WARNING - void declaration
     */
    public void open(Stream stream, Cancellation cancellationToken) throws IOException {
        void var2_2;
        fm fm2;
        if (stream == null) {
            throw new IllegalArgumentException("Argument stream cannot be null");
        }
        fm2 = new fm(this, new nS((Stream)((Object)fm2)), null);
        FileFormat fileFormat = eV.a().a(null, fm2);
        if (fileFormat == null) {
            throw new ImportException(cZ.b());
        }
        fm2.a(fileFormat.createLoadOptions());
        lS.a(fm2, (Cancellation)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void open(String fileName, FileFormat format, Cancellation cancellationToken) throws IOException {
        if (!Files.exists(Paths.get(fileName, new String[0]), new LinkOption[0])) {
            throw new FileNotFoundException(cZ.a());
        }
        try (FileStream fileStream = new FileStream(fileName, 1, 1);){
            void var3_5;
            void var1_1;
            LoadOptions loadOptions;
            loadOptions = ((FileFormat)((Object)loadOptions)).createLoadOptions();
            loadOptions.setFileName((String)var1_1);
            this.open((Stream)fileStream, loadOptions, (Cancellation)var3_5);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void open(String fileName, FileFormat format) throws IOException {
        void var2_2;
        void var1_1;
        this.open((String)var1_1, (FileFormat)var2_2, io.a.defaultValue());
    }

    /*
     * WARNING - void declaration
     */
    public void open(String fileName, LoadOptions options) throws IOException {
        void var2_2;
        void var1_1;
        this.open((String)var1_1, (LoadOptions)var2_2, (Cancellation)null);
    }

    /*
     * WARNING - void declaration
     */
    public void open(String fileName, LoadOptions options, Cancellation cancellationToken) throws IOException {
        if (!Files.exists(Paths.get(fileName, new String[0]), new LinkOption[0])) {
            throw new FileNotFoundException(cZ.a());
        }
        try (FileStream fileStream = new FileStream(fileName, 1, 1);){
            void var3_5;
            void var2_3;
            void var1_1;
            options.setFileName((String)var1_1);
            this.open((Stream)fileStream, (LoadOptions)var2_3, (Cancellation)var3_5);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void open(String fileName) throws IOException {
        void var1_1;
        this.open((String)var1_1, (Cancellation)null);
    }

    /*
     * WARNING - void declaration
     */
    public void open(String fileName, Cancellation cancellationToken) throws IOException {
        if (!Files.exists(Paths.get(fileName, new String[0]), new LinkOption[0])) {
            throw new FileNotFoundException(cZ.a());
        }
        try (FileStream fileStream = new FileStream(fileName, 1, 1);){
            void var2_2;
            void var1_1;
            fm fm2 = new fm(this, new nS(fileStream), null);
            Object object = eV.a().a(fileName, fm2);
            if (object == null) {
                throw new ImportException(cZ.b());
            }
            object = ((FileFormat)object).createLoadOptions();
            fm2.a((LoadOptions)object);
            ((IOConfig)object).setFileName((String)var1_1);
            lS.a(fm2, (Cancellation)var2_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Scene fromStream(Stream stream, FileFormat format, Cancellation cancellationToken) throws IOException {
        void var2_2;
        void var1_1;
        Stream stream2;
        Scene scene = new Scene();
        scene.open(stream2, (FileFormat)var1_1, (Cancellation)var2_2);
        return scene;
    }

    /*
     * WARNING - void declaration
     */
    public static Scene fromStream(Stream stream, FileFormat format) throws IOException {
        void var1_1;
        return Scene.fromStream(stream, (FileFormat)var1_1, io.a.defaultValue());
    }

    /*
     * WARNING - void declaration
     */
    public static Scene fromStream(Stream stream, LoadOptions options, Cancellation cancellationToken) throws IOException {
        void var2_2;
        void var1_1;
        Stream stream2;
        Scene scene = new Scene();
        scene.open(stream2, (LoadOptions)var1_1, (Cancellation)var2_2);
        return scene;
    }

    /*
     * WARNING - void declaration
     */
    public static Scene fromStream(Stream stream, LoadOptions options) throws IOException {
        void var1_1;
        return Scene.fromStream(stream, (LoadOptions)var1_1, io.a.defaultValue());
    }

    /*
     * WARNING - void declaration
     */
    public static Scene fromStream(Stream stream, Cancellation cancellationToken) throws IOException {
        void var1_1;
        Stream stream2;
        Scene scene = new Scene();
        scene.open(stream2, (Cancellation)var1_1);
        return scene;
    }

    public static Scene fromStream(Stream stream) throws IOException {
        return Scene.fromStream(stream, io.a.defaultValue());
    }

    /*
     * WARNING - void declaration
     */
    public static Scene fromFile(String fileName, FileFormat format, Cancellation cancellationToken) throws IOException {
        void var2_2;
        void var1_1;
        String string;
        Scene scene = new Scene();
        scene.open(string, (FileFormat)var1_1, (Cancellation)var2_2);
        return scene;
    }

    /*
     * WARNING - void declaration
     */
    public static Scene fromFile(String fileName, FileFormat format) throws IOException {
        void var1_1;
        return Scene.fromFile(fileName, (FileFormat)var1_1, io.a.defaultValue());
    }

    /*
     * WARNING - void declaration
     */
    public static Scene fromFile(String fileName, LoadOptions options, Cancellation cancellationToken) throws IOException {
        void var2_2;
        void var1_1;
        String string;
        Scene scene = new Scene();
        scene.open(string, (LoadOptions)var1_1, (Cancellation)var2_2);
        return scene;
    }

    /*
     * WARNING - void declaration
     */
    public static Scene fromFile(String fileName, LoadOptions options) throws IOException {
        void var1_1;
        return Scene.fromFile(fileName, (LoadOptions)var1_1, io.a.defaultValue());
    }

    public static Scene fromFile(String fileName) throws IOException {
        return Scene.fromFile(fileName, (Cancellation)null);
    }

    /*
     * WARNING - void declaration
     */
    public static Scene fromFile(String fileName, Cancellation cancellationToken) throws IOException {
        void var1_1;
        String string;
        Scene scene = new Scene();
        scene.open(string, (Cancellation)var1_1);
        return scene;
    }

    /*
     * WARNING - void declaration
     */
    public void save(Stream stream, FileFormat format) throws IOException {
        void var2_2;
        void var1_1;
        this.save((Stream)var1_1, (FileFormat)var2_2, (Cancellation)null);
    }

    /*
     * WARNING - void declaration
     */
    public void save(Stream stream, FileFormat format, Cancellation cancellationToken) throws IOException {
        void var3_3;
        void var1_1;
        SaveOptions saveOptions;
        if (stream == null) {
            throw new IllegalArgumentException("Argument stream cannot be null");
        }
        if (format == null) {
            throw new IllegalArgumentException("Argument format cannot be null");
        }
        saveOptions = ((FileFormat)((Object)saveOptions)).createSaveOptions();
        this.save((Stream)var1_1, saveOptions, (Cancellation)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void save(Stream stream, SaveOptions options) throws IOException {
        void var2_2;
        void var1_1;
        this.save((Stream)var1_1, (SaveOptions)var2_2, (Cancellation)null);
    }

    /*
     * WARNING - void declaration
     */
    public void save(Stream stream, SaveOptions options, Cancellation cancellationToken) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (stream == null) {
            throw new IllegalArgumentException("Argument stream cannot be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("Argument options cannot be null");
        }
        if (options.b == null) {
            throw new IllegalStateException(cZ.g());
        }
        lS.a(this, (Stream)var1_1, (SaveOptions)var2_2, (Cancellation)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void save(String fileName) throws IOException {
        void var1_1;
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("File name must be specified");
        }
        Object object = AsposeUtils.getFileExtension(fileName);
        if ((object = FileFormat.getFormatByExtension((String)object)) == null || !((FileFormat)object).getCanExport()) {
            throw new IllegalStateException("Unsupported file format to save");
        }
        this.save((String)var1_1, (FileFormat)object, (Cancellation)null);
    }

    /*
     * WARNING - void declaration
     */
    public void save(String fileName, FileFormat format) throws IOException {
        void var2_2;
        void var1_1;
        this.save((String)var1_1, (FileFormat)var2_2, (Cancellation)null);
    }

    /*
     * WARNING - void declaration
     */
    public void save(String fileName, FileFormat format, Cancellation cancellationToken) throws IOException {
        if (format == null) {
            throw new IllegalArgumentException("Argument format cannot be null");
        }
        try (FileStream fileStream = new FileStream(fileName, 0);){
            void var3_5;
            void var1_1;
            SaveOptions saveOptions;
            saveOptions = ((FileFormat)((Object)saveOptions)).createSaveOptions();
            saveOptions.setFileName((String)var1_1);
            this.save((Stream)fileStream, saveOptions, (Cancellation)var3_5);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void save(String fileName, SaveOptions options) throws IOException {
        void var2_2;
        void var1_1;
        this.save((String)var1_1, (SaveOptions)var2_2, (Cancellation)null);
    }

    /*
     * WARNING - void declaration
     */
    public void save(String fileName, SaveOptions options, Cancellation cancellationToken) throws IOException {
        if (options == null) {
            throw new IllegalArgumentException("Argument config cannot be null");
        }
        try (FileStream fileStream = new FileStream(fileName, 0);){
            void var3_5;
            void var2_3;
            void var1_1;
            options.setFileName((String)var1_1);
            this.save((Stream)fileStream, (SaveOptions)var2_3, (Cancellation)var3_5);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void render(Camera camera, String fileName) throws IOException {
        void var2_2;
        void var1_1;
        Dimension dimension = new Dimension(1024, 768);
        String string = "png";
        this.render((Camera)var1_1, (String)var2_2, dimension, string, new ImageRenderOptions());
    }

    /*
     * WARNING - void declaration
     */
    public void render(Camera camera, String fileName, Dimension size, String format) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.render((Camera)var1_1, (String)var2_2, (Dimension)var3_3, format, new ImageRenderOptions());
    }

    /*
     * WARNING - void declaration
     */
    public void render(Camera camera, String fileName, Dimension size, String format, ImageRenderOptions options) throws IOException {
        void var2_3;
        void var1_1;
        BufferedImage bufferedImage;
        if (camera == null) {
            throw new IllegalArgumentException("Argument camera cannot be null");
        }
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("Argument fileName cannot be null");
        }
        if (size.width <= 0 || size.height <= 0) {
            throw new IllegalArgumentException("Invalid target size");
        }
        if (camera.getScene() == null) {
            throw new IllegalArgumentException("Cannot render scene using an unattached camera.");
        }
        if (options == null) {
            throw new IllegalArgumentException("Argument options cannot be null");
        }
        bufferedImage = new BufferedImage(size.width, ((Dimension)((Object)bufferedImage)).height, 6);
        this.render((Camera)var1_1, bufferedImage, options);
        ImageIO.write((RenderedImage)bufferedImage, format, new File((String)var2_3));
        return;
    }

    /*
     * WARNING - void declaration
     */
    public void render(Camera camera, BufferedImage bitmap) throws IOException {
        void var2_2;
        void var1_1;
        this.render((Camera)var1_1, (BufferedImage)var2_2, new ImageRenderOptions());
    }

    /*
     * WARNING - void declaration
     */
    public void render(Camera camera, BufferedImage bitmap, ImageRenderOptions options) throws IOException {
        if (camera == null) {
            throw new IllegalArgumentException("Argument camera cannot be null");
        }
        if (bitmap == null) {
            throw new IllegalArgumentException("Argument bitmap cannot be null");
        }
        if (camera.getScene() == null) {
            throw new IllegalArgumentException("Cannot render scene using an unattached camera.");
        }
        if (options == null) {
            throw new IllegalArgumentException("Argument options cannot be null");
        }
        Object object = lz.a;
        object = Renderer.a((lz)((Object)object));
        try {
            try (IRenderTexture iRenderTexture = ((Renderer)object).getRenderFactory().createRenderTexture(new RenderParameters(), 1, bitmap.getWidth(), bitmap.getHeight());){
                void var2_4;
                void var3_6;
                void var1_1;
                iRenderTexture.createViewport((Camera)var1_1, options.getBackgroundColor(), RelativeRectangle.fromScale(0.0f, 0.0f, 1.0f, 1.0f));
                if (options.getAssetDirectories() != null && !options.getAssetDirectories().isEmpty()) {
                    ((Renderer)object).getAssetDirectories().addAll(options.getAssetDirectories());
                }
                ((Renderer)object).setEnableShadows(var3_6.getEnableShadows());
                ((Renderer)object).render(iRenderTexture);
                ((ITexture2D)iRenderTexture.getTargets().get(0)).save((BufferedImage)var2_4);
            }
            return;
        }
        finally {
            ((Renderer)object).close();
        }
    }

    static /* synthetic */ void a(Scene scene, Object object, jl jl2) {
        object = jl2;
        ((AnimationClip)((jl)v0).b).scene = scene;
    }

    static /* synthetic */ void b(Scene object, Object object2, jl jl2) {
        Scene scene = object;
        object2 = jl2;
        object = scene;
        object = object2;
        scene.library.remove(((jl)object).b);
    }

    static /* synthetic */ void c(Scene scene, Object object, jl jl2) {
        object = jl2;
        object = (A3DObject)((jl)object).b;
        if (object instanceof SceneObject) {
            ((SceneObject)object).scene = scene;
        }
        if (object instanceof AnimationClip) {
            scene.animationClips.add((AnimationClip)object);
        }
    }

    static /* synthetic */ void d(Scene scene, Object object, jl jl2) {
        object = jl2;
        object = (A3DObject)((jl)object).b;
        if (object instanceof SceneObject) {
            ((SceneObject)object).scene = null;
        }
        if (object instanceof AnimationClip) {
            scene.animationClips.remove((AnimationClip)object);
        }
    }
}

