/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.BoundingBox;
import com.aspose.threed.MappingMode;
import com.aspose.threed.Matrix4;
import com.aspose.threed.Mesh;
import com.aspose.threed.Primitive;
import com.aspose.threed.ReferenceMode;
import com.aspose.threed.Vector3;
import com.aspose.threed.Vector4;
import com.aspose.threed.VertexElementNormal;
import com.aspose.threed.VertexElementType;
import com.aspose.threed.io;

public class RectangularTorus
extends Primitive {
    private double innerRadius;
    private double outerRadius;
    private double height;
    private double arc;
    private double angleStart;
    private int radialSegments;

    public double getInnerRadius() {
        return this.innerRadius;
    }

    /*
     * WARNING - void declaration
     */
    public void setInnerRadius(double value) {
        void var1_1;
        this.innerRadius = var1_1;
    }

    public double getOuterRadius() {
        return this.outerRadius;
    }

    /*
     * WARNING - void declaration
     */
    public void setOuterRadius(double value) {
        void var1_1;
        this.outerRadius = var1_1;
    }

    public double getHeight() {
        return this.height;
    }

    /*
     * WARNING - void declaration
     */
    public void setHeight(double value) {
        void var1_1;
        this.height = var1_1;
    }

    public double getArc() {
        return this.arc;
    }

    /*
     * WARNING - void declaration
     */
    public void setArc(double value) {
        void var1_1;
        this.arc = var1_1;
    }

    public double getAngleStart() {
        return this.angleStart;
    }

    /*
     * WARNING - void declaration
     */
    public void setAngleStart(double value) {
        void var1_1;
        this.angleStart = var1_1;
    }

    public int getRadialSegments() {
        return this.radialSegments;
    }

    /*
     * WARNING - void declaration
     */
    public void setRadialSegments(int value) {
        void var1_1;
        this.radialSegments = var1_1;
    }

    public RectangularTorus() {
        this("");
    }

    /*
     * WARNING - void declaration
     */
    public RectangularTorus(String name) {
        super((String)var1_1);
        void var1_1;
        this.setRadialSegments(10);
        this.setAngleStart(0.0);
        this.setArc(Math.PI);
        this.setInnerRadius(17.0);
        this.setOuterRadius(20.0);
        this.setHeight(20.0);
    }

    @Override
    final BoundingBox a(Matrix4 matrix4) {
        double d2 = this.getHeight() * 0.5;
        double d3 = Math.max(this.getInnerRadius(), this.getOuterRadius());
        int n2 = this.getRadialSegments() + 1;
        double d4 = 1.0 / (double)this.getRadialSegments();
        boolean bl2 = matrix4.a();
        BoundingBox boundingBox = new BoundingBox();
        for (int i2 = 0; i2 < n2; ++i2) {
            double d5 = (double)i2 * d4 * this.getArc() + this.getAngleStart();
            double d6 = Math.cos(d5);
            double d7 = Math.sin(d5);
            if (bl2) {
                boundingBox.a(d6 * d3, d2, d7 * d3);
                boundingBox.a(d6 * d3, -d2, d7 * d3);
                continue;
            }
            boundingBox.a(Matrix4.mul(matrix4, new Vector4(d6 * d3, d2, d7 * d3, 1.0)));
            boundingBox.a(Matrix4.mul(matrix4, new Vector4(d6 * d3, -d2, d7 * d3, 1.0)));
        }
        return boundingBox;
    }

    @Override
    public Mesh toMesh() {
        int n2;
        int n3;
        Mesh mesh = this.createEmptyMesh();
        if (this.getRadialSegments() <= 0) {
            throw new IllegalStateException("Invalid RadialSegments for RectangularTorus.");
        }
        int n4 = this.getRadialSegments() + 1;
        int n5 = n4 << 1 << 1;
        Vector4[] vector4Array = (Vector4[])io.d.newArray(n5);
        Vector4[] vector4Array2 = (Vector4[])io.d.newArray((n4 << 1) + 4);
        double d2 = 1.0 / (double)this.getRadialSegments();
        int n6 = 0;
        int n7 = 0;
        double d3 = this.getHeight() * 0.5;
        double d4 = this.getInnerRadius();
        double d5 = this.getOuterRadius();
        for (n3 = 0; n3 < n4; ++n3) {
            double d6 = (double)n3 * d2 * this.getArc() + this.getAngleStart();
            double d7 = Math.cos(d6);
            double d8 = Math.sin(d6);
            vector4Array2[n6++] = new Vector4(-d7, 0.0, -d8, 0.0);
            vector4Array2[n6++] = new Vector4(d7, 0.0, d8, 0.0);
            vector4Array[n7++] = new Vector4(d7 * d4, d3, d8 * d4);
            vector4Array[n7++] = new Vector4(d7 * d4, -d3, d8 * d4);
            vector4Array[n7++] = new Vector4(d7 * d5, d3, d8 * d5);
            vector4Array[n7++] = new Vector4(d7 * d5, -d3, d8 * d5);
        }
        vector4Array2[n6] = new Vector4(0.0, 1.0, 0.0, 0.0);
        vector4Array2[n6 + 1] = new Vector4(0.0, -1.0, 0.0, 0.0);
        vector4Array2[n6 + 2] = RectangularTorus.a(vector4Array, 0, 2, 3);
        n3 = this.getRadialSegments() << 2;
        vector4Array2[n6 + 3] = RectangularTorus.a(vector4Array, n3, n3 + 1, n3 + 3);
        mesh.controlPoints.b(vector4Array);
        VertexElementNormal vertexElementNormal = (VertexElementNormal)mesh.createElement(VertexElementType.NORMAL, MappingMode.POLYGON_VERTEX, ReferenceMode.INDEX_TO_DIRECT);
        vertexElementNormal.h.b(vector4Array2);
        for (n2 = 0; n2 < this.getRadialSegments(); ++n2) {
            int n8 = n2 << 2;
            int n9 = n2 + 1 << 2;
            int n10 = n2 << 1;
            int n11 = n8;
            mesh.createPolygon(n11, n11 + 1, n9 + 1, n9);
            int n12 = n10;
            vertexElementNormal.f.a(n12, n12, n10 + 2, n10 + 2);
            int n13 = n9 += 2;
            mesh.createPolygon(n8 += 2, n13, n13 + 1, n8 + 1);
            vertexElementNormal.f.a(n10 + 1, n10 + 3, n10 + 3, n10 + 1);
            int n14 = n8 = n2 << 2;
            mesh.createPolygon(n14, n14 + 4, n8 + 6, n8 + 2);
            int n15 = n6;
            int n16 = n6;
            vertexElementNormal.f.a(n15, n15, n16, n16);
            int n17 = ++n8;
            mesh.createPolygon(n17, n17 + 2, n8 + 6, n8 + 4);
            vertexElementNormal.f.a(n6 + 1, n6 + 1, n6 + 1, n6 + 1);
        }
        mesh.createPolygon(0, 2, 3, 1);
        vertexElementNormal.f.a(n6 + 2, n6 + 2, n6 + 2, n6 + 2);
        int n18 = n2 = this.getRadialSegments() << 2;
        mesh.createPolygon(n18, n18 + 1, n2 + 3, n2 + 2);
        vertexElementNormal.f.a(n6 + 3, n6 + 3, n6 + 3, n6 + 3);
        return mesh;
    }

    private static Vector4 a(Vector4[] object, int n2, int n3, int n4) {
        Vector3 vector3 = new Vector3(Vector4.sub(object[n2], object[n3]));
        object = new Vector3(Vector4.sub(object[n4], object[n3]));
        object = object.cross(vector3).normalize();
        return new Vector4((Vector3)object);
    }
}

