/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.EntityRendererKey;
import com.aspose.threed.Geometry;
import com.aspose.threed.MathUtils;
import com.aspose.threed.Matrix4;
import com.aspose.threed.Mesh;
import com.aspose.threed.PolygonModifier;
import com.aspose.threed.Vector4;
import com.aspose.threed.oZ;
import java.util.List;
import java.util.Random;

public class PointCloud
extends Geometry {
    private static final EntityRendererKey RENDERER_KEY = new EntityRendererKey("a3d:point_cloud");

    /*
     * WARNING - void declaration
     */
    public PointCloud(String name) {
        super((String)var1_1);
        void var1_1;
    }

    @Override
    public EntityRendererKey getEntityRendererKey() {
        return RENDERER_KEY;
    }

    public PointCloud() {
        super("");
    }

    public static PointCloud fromGeometry(Geometry g2) {
        return PointCloud.fromGeometry(g2, 10);
    }

    /*
     * WARNING - void declaration
     */
    public static PointCloud fromGeometry(Geometry g2, int density) {
        PointCloud pointCloud = new PointCloud(g2.getName());
        if (g2 instanceof Mesh) {
            void var1_1;
            Mesh mesh = (Mesh)g2;
            Matrix4.getIdentity();
            void var3_4 = var1_1;
            Iterable<int[]> iterable = mesh;
            g2 = pointCloud;
            if (var3_4 < 2) {
                throw new IllegalArgumentException("density is too small.");
            }
            int[][] nArray = PolygonModifier.triangulate((List<Vector4>)((Mesh)iterable).controlPoints, ((Mesh)iterable).polygons);
            double[] dArray = new double[nArray.length];
            iterable = ((Mesh)iterable).controlPoints;
            double d2 = 0.0;
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                double d3;
                int[] nArray2 = nArray[i2];
                double d4 = MathUtils.a(((oZ)iterable).e(nArray2[0]), ((oZ)iterable).e(nArray2[1]), ((oZ)iterable).e(nArray2[2]));
                if (d3 > d2) {
                    d2 = d4;
                }
                dArray[i2] = d4;
            }
            if (!(d2 <= 0.0)) {
                Random random = new Random();
                for (int i3 = 0; i3 < dArray.length; ++i3) {
                    int n2 = Math.max(1, (int)(dArray[i3] / d2 * (double)var3_4));
                    if (n2 < 0) continue;
                    int[] nArray3 = nArray[i3];
                    for (int i4 = 0; i4 < n2; ++i4) {
                        double d5 = random.nextDouble() * 0.5;
                        double d6 = random.nextDouble() * (1.0 - d5);
                        double d7 = 1.0 - d5 - d6;
                        Vector4 vector4 = ((oZ)iterable).c(nArray3[0]);
                        Vector4 vector42 = ((oZ)iterable).c(nArray3[1]);
                        Vector4 vector43 = ((oZ)iterable).c(nArray3[2]);
                        ((PointCloud)g2).controlPoints.a(vector4.x * d5 + vector42.x * d6 + vector43.x * d7, vector4.y * d5 + vector42.y * d6 + vector43.y * d7, vector4.z * d5 + vector42.z * d6 + vector43.z * d7);
                    }
                }
            }
        } else {
            Geometry geometry;
            pointCloud.controlPoints.c(geometry.controlPoints);
        }
        return pointCloud;
    }
}

