/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.FMatrix4;
import com.aspose.threed.MathUtils;
import com.aspose.threed.Quaternion;
import com.aspose.threed.Vector3;
import com.aspose.threed.Vector4;
import com.aspose.threed.nn;
import com.aspose.threed.utils.HashBuilder;
import com.aspose.threed.utils.Struct;
import java.io.Serializable;

public final class Matrix4
implements Struct<Matrix4>,
Serializable {
    public double m00;
    public double m01;
    public double m02;
    public double m03;
    public double m10;
    public double m11;
    public double m12;
    public double m13;
    public double m20;
    public double m21;
    public double m22;
    public double m23;
    public double m30;
    public double m31;
    public double m32;
    public double m33;
    static final long serialVersionUID = -1267594858L;

    /*
     * WARNING - void declaration
     */
    public Matrix4(Vector4 r0, Vector4 r1, Vector4 r2, Vector4 r3) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.m00 = r0.x;
        this.m01 = r0.y;
        this.m02 = r0.z;
        this.m03 = var1_1.w;
        this.m10 = r1.x;
        this.m11 = r1.y;
        this.m12 = r1.z;
        this.m13 = var2_2.w;
        this.m20 = r2.x;
        this.m21 = r2.y;
        this.m22 = r2.z;
        this.m23 = var3_3.w;
        this.m30 = r3.x;
        this.m31 = r3.y;
        this.m32 = r3.z;
        this.m33 = r3.w;
    }

    /*
     * WARNING - void declaration
     */
    public Matrix4(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23, double m30, double m31, double m32, double m33) {
        void var3_2;
        void var1_1;
        this.m00 = var1_1;
        this.m01 = var3_2;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.m30 = m30;
        this.m31 = m31;
        this.m32 = m32;
        this.m33 = m33;
    }

    /*
     * WARNING - void declaration
     */
    public Matrix4(FMatrix4 m2) {
        void var1_1;
        this.m00 = m2.m00;
        this.m01 = m2.m01;
        this.m02 = m2.m02;
        this.m03 = m2.m03;
        this.m10 = m2.m10;
        this.m11 = m2.m11;
        this.m12 = m2.m12;
        this.m13 = m2.m13;
        this.m20 = m2.m20;
        this.m21 = m2.m21;
        this.m22 = m2.m22;
        this.m23 = m2.m23;
        this.m30 = m2.m30;
        this.m31 = m2.m31;
        this.m32 = m2.m32;
        this.m33 = var1_1.m33;
    }

    /*
     * WARNING - void declaration
     */
    public Matrix4(double[] m2) {
        void var1_1;
        if (m2 == null || m2.length != 16) {
            throw new IllegalArgumentException("Input matrix must have length of 16 elements.");
        }
        this.m00 = m2[0];
        this.m01 = m2[1];
        this.m02 = m2[2];
        this.m03 = m2[3];
        this.m10 = m2[4];
        this.m11 = m2[5];
        this.m12 = m2[6];
        this.m13 = m2[7];
        this.m20 = m2[8];
        this.m21 = m2[9];
        this.m22 = m2[10];
        this.m23 = m2[11];
        this.m30 = m2[12];
        this.m31 = m2[13];
        this.m32 = m2[14];
        this.m33 = var1_1[15];
    }

    public static Matrix4 getIdentity() {
        return new Matrix4(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    /*
     * WARNING - void declaration
     */
    public final Matrix4 concatenate(Matrix4 m2) {
        void var1_1;
        Matrix4 matrix4 = new Matrix4();
        new Matrix4().m00 = m2.m00 * this.m00 + m2.m01 * this.m10 + m2.m02 * this.m20 + m2.m03 * this.m30;
        matrix4.m01 = m2.m00 * this.m01 + m2.m01 * this.m11 + m2.m02 * this.m21 + m2.m03 * this.m31;
        matrix4.m02 = m2.m00 * this.m02 + m2.m01 * this.m12 + m2.m02 * this.m22 + m2.m03 * this.m32;
        matrix4.m03 = m2.m00 * this.m03 + m2.m01 * this.m13 + m2.m02 * this.m23 + m2.m03 * this.m33;
        matrix4.m10 = m2.m10 * this.m00 + m2.m11 * this.m10 + m2.m12 * this.m20 + m2.m13 * this.m30;
        matrix4.m11 = m2.m10 * this.m01 + m2.m11 * this.m11 + m2.m12 * this.m21 + m2.m13 * this.m31;
        matrix4.m12 = m2.m10 * this.m02 + m2.m11 * this.m12 + m2.m12 * this.m22 + m2.m13 * this.m32;
        matrix4.m13 = m2.m10 * this.m03 + m2.m11 * this.m13 + m2.m12 * this.m23 + m2.m13 * this.m33;
        matrix4.m20 = m2.m20 * this.m00 + m2.m21 * this.m10 + m2.m22 * this.m20 + m2.m23 * this.m30;
        matrix4.m21 = m2.m20 * this.m01 + m2.m21 * this.m11 + m2.m22 * this.m21 + m2.m23 * this.m31;
        matrix4.m22 = m2.m20 * this.m02 + m2.m21 * this.m12 + m2.m22 * this.m22 + m2.m23 * this.m32;
        matrix4.m23 = m2.m20 * this.m03 + m2.m21 * this.m13 + m2.m22 * this.m23 + m2.m23 * this.m33;
        matrix4.m30 = m2.m30 * this.m00 + m2.m31 * this.m10 + m2.m32 * this.m20 + m2.m33 * this.m30;
        matrix4.m31 = m2.m30 * this.m01 + m2.m31 * this.m11 + m2.m32 * this.m21 + m2.m33 * this.m31;
        matrix4.m32 = m2.m30 * this.m02 + m2.m31 * this.m12 + m2.m32 * this.m22 + m2.m33 * this.m32;
        matrix4.m33 = m2.m30 * this.m03 + m2.m31 * this.m13 + m2.m32 * this.m23 + var1_1.m33 * this.m33;
        return matrix4;
    }

    final void a(int n2, Vector3 vector3, double d2) {
        this.a(n2, vector3.x, vector3.y, vector3.z, d2);
    }

    final void a(int n2, Vector4 vector4) {
        this.a(n2, vector4.x, vector4.y, vector4.z, vector4.w);
    }

    private void a(int n2, double d2, double d3, double d4, double d5) {
        switch (n2) {
            case 0: {
                this.m00 = d2;
                this.m01 = d3;
                this.m02 = d4;
                this.m03 = d5;
                return;
            }
            case 1: {
                this.m10 = d2;
                this.m11 = d3;
                this.m12 = d4;
                this.m13 = d5;
                return;
            }
            case 2: {
                this.m20 = d2;
                this.m21 = d3;
                this.m22 = d4;
                this.m23 = d5;
                return;
            }
            case 3: {
                this.m30 = d2;
                this.m31 = d3;
                this.m32 = d4;
                this.m33 = d5;
                return;
            }
        }
        throw new IllegalArgumentException("Invalid row");
    }

    public final Matrix4 transpose() {
        return new Matrix4(this.m00, this.m10, this.m20, this.m30, this.m01, this.m11, this.m21, this.m31, this.m02, this.m12, this.m22, this.m32, this.m03, this.m13, this.m23, this.m33);
    }

    public final Matrix4 normalize() {
        double d2 = 1.0 / this.m33;
        return new Matrix4(this.m00 * d2, this.m01 * d2, this.m02 * d2, this.m03 * d2, this.m10 * d2, this.m11 * d2, this.m12 * d2, this.m13 * d2, this.m20 * d2, this.m21 * d2, this.m22 * d2, this.m23 * d2, this.m30 * d2, this.m31 * d2, this.m32 * d2, this.m33 * d2);
    }

    public final Matrix4 inverse() {
        double d2 = this.m22 * this.m33 - this.m32 * this.m23;
        double d3 = this.m12 * this.m33 - this.m32 * this.m13;
        double d4 = this.m12 * this.m23 - this.m22 * this.m13;
        double d5 = this.m21 * this.m33 - this.m31 * this.m23;
        double d6 = this.m11 * this.m33 - this.m31 * this.m13;
        double d7 = this.m11 * this.m23 - this.m21 * this.m13;
        double d8 = this.m21 * this.m32 - this.m31 * this.m22;
        double d9 = this.m11 * this.m32 - this.m31 * this.m12;
        double d10 = this.m11 * this.m22 - this.m21 * this.m12;
        double d11 = this.m20 * this.m33 - this.m30 * this.m23;
        double d12 = this.m10 * this.m33 - this.m30 * this.m13;
        double d13 = this.m10 * this.m23 - this.m20 * this.m13;
        double d14 = this.m20 * this.m32 - this.m30 * this.m22;
        double d15 = this.m10 * this.m32 - this.m30 * this.m12;
        double d16 = this.m10 * this.m22 - this.m20 * this.m12;
        double d17 = this.m20 * this.m31 - this.m30 * this.m21;
        double d18 = this.m10 * this.m31 - this.m30 * this.m11;
        double d19 = this.m10 * this.m21 - this.m20 * this.m11;
        double d20 = d2;
        Struct<Vector4> struct = new Vector4(d20, d20, d3, d4);
        double d21 = d5;
        Vector4 vector4 = new Vector4(d21, d21, d6, d7);
        double d22 = d8;
        Vector4 vector42 = new Vector4(d22, d22, d9, d10);
        double d23 = d11;
        Vector4 vector43 = new Vector4(d23, d23, d12, d13);
        double d24 = d14;
        Vector4 vector44 = new Vector4(d24, d24, d15, d16);
        double d25 = d17;
        Vector4 vector45 = new Vector4(d25, d25, d18, d19);
        Vector4 vector46 = new Vector4(this.m10, this.m00, this.m00, this.m00);
        Vector4 vector47 = new Vector4(this.m11, this.m01, this.m01, this.m01);
        Vector4 vector48 = new Vector4(this.m12, this.m02, this.m02, this.m02);
        Vector4 vector49 = new Vector4(this.m13, this.m03, this.m03, this.m03);
        Vector4 vector410 = Vector4.add(Vector4.sub(Vector4.mul(vector47, struct), Vector4.mul(vector48, vector4)), Vector4.mul(vector49, vector42));
        struct = Vector4.add(Vector4.sub(Vector4.mul(vector46, struct), Vector4.mul(vector48, vector43)), Vector4.mul(vector49, vector44));
        vector4 = Vector4.add(Vector4.sub(Vector4.mul(vector46, vector4), Vector4.mul(vector47, vector43)), Vector4.mul(vector49, vector45));
        vector42 = Vector4.add(Vector4.sub(Vector4.mul(vector46, vector42), Vector4.mul(vector47, vector44)), Vector4.mul(vector48, vector45));
        vector43 = new Vector4(1.0, -1.0, 1.0, -1.0);
        vector44 = new Vector4(-1.0, 1.0, -1.0, 1.0);
        struct = new Matrix4(Vector4.mul(vector410, vector43), Vector4.mul(struct, vector44), Vector4.mul(vector4, vector43), Vector4.mul(vector42, vector44));
        vector4 = new Vector4(((Matrix4)struct).m00, ((Matrix4)struct).m10, ((Matrix4)struct).m20, ((Matrix4)struct).m30);
        vector4.x *= this.m00;
        vector4.y *= this.m01;
        vector4.z *= this.m02;
        vector4.w *= this.m03;
        double d26 = vector4.x + vector4.y + (vector4.z + vector4.w);
        double d27 = 1.0 / d26;
        return Matrix4.mul((Matrix4)struct, d27);
    }

    public final double getDeterminant() {
        double d2 = this.m22 * this.m33 - this.m32 * this.m23;
        double d3 = this.m21 * this.m33 - this.m31 * this.m23;
        double d4 = this.m21 * this.m32 - this.m31 * this.m22;
        double d5 = this.m20 * this.m33 - this.m30 * this.m23;
        double d6 = this.m20 * this.m32 - this.m30 * this.m22;
        double d7 = this.m20 * this.m31 - this.m30 * this.m21;
        Vector4 vector4 = new Vector4(this.m11 * d2 - this.m12 * d3 + this.m13 * d4, -(this.m10 * d2 - this.m12 * d5 + this.m13 * d6), this.m10 * d3 - this.m11 * d5 + this.m13 * d7, -(this.m10 * d4 - this.m11 * d6 + this.m12 * d7));
        return this.m00 * vector4.x + this.m01 * vector4.y + this.m02 * vector4.z + this.m03 * vector4.w;
    }

    /*
     * WARNING - void declaration
     */
    public static Matrix4 mul(Matrix4 lhs, Matrix4 rhs) {
        void var1_1;
        return lhs.concatenate((Matrix4)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Vector3 mul(Matrix4 lhs, Vector3 v2) {
        Matrix4 matrix4;
        void var1_1;
        Vector3 vector3 = new Vector3();
        double d2 = 1.0 / (lhs.m03 * v2.x + lhs.m13 * v2.y + lhs.m23 * v2.z + lhs.m33);
        vector3.x = (lhs.m00 * v2.x + lhs.m10 * v2.y + lhs.m20 * v2.z + lhs.m30) * d2;
        vector3.y = (lhs.m01 * v2.x + lhs.m11 * v2.y + lhs.m21 * v2.z + lhs.m31) * d2;
        vector3.z = (lhs.m02 * v2.x + lhs.m12 * v2.y + lhs.m22 * var1_1.z + matrix4.m32) * d2;
        return vector3;
    }

    public final void setTRS(Vector3 translation, Vector3 rotation, Vector3 scale) {
        Matrix4 matrix4;
        Matrix4 matrix42;
        Matrix4 matrix43 = nn.c(MathUtils.toRadian(rotation));
        matrix42 = nn.b(scale.x, scale.y, ((Vector3)((Object)matrix42)).z);
        matrix4 = nn.a(translation.x, translation.y, ((Vector3)((Object)matrix4)).z);
        this.copyFrom(Matrix4.mul(matrix4, Matrix4.mul(matrix43, matrix42)));
    }

    /*
     * WARNING - void declaration
     */
    public static Vector4 mul(Matrix4 lhs, Vector4 v2) {
        void var1_1;
        Matrix4 matrix4;
        return new Vector4(lhs.m00 * v2.x + lhs.m10 * v2.y + lhs.m20 * v2.z + lhs.m30 * v2.w, lhs.m01 * v2.x + lhs.m11 * v2.y + lhs.m21 * v2.z + lhs.m31 * v2.w, lhs.m02 * v2.x + lhs.m12 * v2.y + lhs.m22 * v2.z + lhs.m32 * v2.w, lhs.m03 * v2.x + lhs.m13 * v2.y + lhs.m23 * v2.z + matrix4.m33 * var1_1.w);
    }

    /*
     * WARNING - void declaration
     */
    public static Matrix4 mul(Matrix4 lhs, double v2) {
        void var1_1;
        Matrix4 matrix4;
        return new Matrix4(lhs.m00 * v2, lhs.m01 * v2, lhs.m02 * v2, lhs.m03 * v2, lhs.m10 * v2, lhs.m11 * v2, lhs.m12 * v2, lhs.m13 * v2, lhs.m20 * v2, lhs.m21 * v2, lhs.m22 * v2, lhs.m23 * v2, lhs.m30 * v2, lhs.m31 * v2, lhs.m32 * v2, matrix4.m33 * var1_1);
    }

    public final double[] toArray() {
        return new double[]{this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23, this.m30, this.m31, this.m32, this.m33};
    }

    /*
     * WARNING - void declaration
     */
    public final boolean decompose(Vector3 translation, Vector3 scaling, Quaternion rotation) {
        void var3_3;
        void var2_2;
        void var1_1;
        return nn.a(this, (Vector3)var1_1, (Vector3)var2_2, (Quaternion)var3_3);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        double[] dArray = this.toArray();
        for (int i2 = 0; i2 < 16; ++i2) {
            if (i2 == 4 || i2 == 8 || i2 == 12) {
                stringBuilder.append(";");
            } else {
                stringBuilder.append(" ");
            }
            stringBuilder.append(String.format("%.7f", dArray[i2]));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static Matrix4 translate(Vector3 t2) {
        Vector3 vector3;
        return nn.a(t2.x, t2.y, vector3.z);
    }

    /*
     * WARNING - void declaration
     */
    public static Matrix4 translate(double tx, double ty, double tz) {
        void var2_2;
        return nn.a(tx, (double)var2_2, tz);
    }

    public static Matrix4 scale(Vector3 s2) {
        Vector3 vector3;
        return Matrix4.scale(s2.x, s2.y, vector3.z);
    }

    public static Matrix4 scale(double s2) {
        double d2;
        double d3 = s2;
        return Matrix4.scale(d3, d3, d2);
    }

    /*
     * WARNING - void declaration
     */
    public static Matrix4 scale(double sx, double sy, double sz) {
        void var2_2;
        return nn.b(sx, (double)var2_2, sz);
    }

    public static Matrix4 rotateFromEuler(Vector3 eul) {
        return nn.c(eul);
    }

    /*
     * WARNING - void declaration
     */
    public static Matrix4 rotateFromEuler(double rx, double ry, double rz) {
        void var2_2;
        return nn.c(rx, (double)var2_2, rz);
    }

    /*
     * WARNING - void declaration
     */
    public static Matrix4 rotate(double angle, Vector3 axis) {
        void var2_1;
        return nn.a(angle, (Vector3)var2_1);
    }

    public static Matrix4 rotate(Quaternion q2) {
        return q2.toMatrix();
    }

    final boolean a() {
        boolean bl2 = this.m00 == 1.0 && this.m01 == 0.0 && this.m02 == 0.0 && this.m03 == 0.0 && this.m10 == 0.0 && this.m11 == 1.0 && this.m12 == 0.0 && this.m13 == 0.0 && this.m20 == 0.0 && this.m21 == 0.0 && this.m22 == 1.0 && this.m23 == 0.0 && this.m30 == 0.0 && this.m31 == 0.0 && this.m32 == 0.0 && this.m33 == 1.0;
        return bl2;
    }

    public Matrix4() {
    }

    /*
     * WARNING - void declaration
     */
    private Matrix4(Matrix4 other) {
        void var1_1;
        this.m00 = other.m00;
        this.m01 = other.m01;
        this.m02 = other.m02;
        this.m03 = other.m03;
        this.m10 = other.m10;
        this.m11 = other.m11;
        this.m12 = other.m12;
        this.m13 = other.m13;
        this.m20 = other.m20;
        this.m21 = other.m21;
        this.m22 = other.m22;
        this.m23 = other.m23;
        this.m30 = other.m30;
        this.m31 = other.m31;
        this.m32 = other.m32;
        this.m33 = var1_1.m33;
    }

    @Override
    public final Matrix4 clone() {
        return new Matrix4(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void copyFrom(Matrix4 src) {
        void var1_1;
        if (src == null) {
            return;
        }
        this.m00 = src.m00;
        this.m01 = src.m01;
        this.m02 = src.m02;
        this.m03 = src.m03;
        this.m10 = src.m10;
        this.m11 = src.m11;
        this.m12 = src.m12;
        this.m13 = src.m13;
        this.m20 = src.m20;
        this.m21 = src.m21;
        this.m22 = src.m22;
        this.m23 = src.m23;
        this.m30 = src.m30;
        this.m31 = src.m31;
        this.m32 = src.m32;
        this.m33 = var1_1.m33;
    }

    public final int hashCode() {
        HashBuilder hashBuilder = new HashBuilder();
        hashBuilder.hash(this.m00);
        hashBuilder.hash(this.m01);
        hashBuilder.hash(this.m02);
        hashBuilder.hash(this.m03);
        hashBuilder.hash(this.m10);
        hashBuilder.hash(this.m11);
        hashBuilder.hash(this.m12);
        hashBuilder.hash(this.m13);
        hashBuilder.hash(this.m20);
        hashBuilder.hash(this.m21);
        hashBuilder.hash(this.m22);
        hashBuilder.hash(this.m23);
        hashBuilder.hash(this.m30);
        hashBuilder.hash(this.m31);
        hashBuilder.hash(this.m32);
        hashBuilder.hash(this.m33);
        return hashBuilder.hashCode();
    }

    public final boolean equals(Object obj) {
        Matrix4 matrix4;
        if (!(obj instanceof Matrix4)) {
            return false;
        }
        matrix4 = matrix4;
        if (this.m00 != matrix4.m00) {
            return false;
        }
        if (this.m01 != matrix4.m01) {
            return false;
        }
        if (this.m02 != matrix4.m02) {
            return false;
        }
        if (this.m03 != matrix4.m03) {
            return false;
        }
        if (this.m10 != matrix4.m10) {
            return false;
        }
        if (this.m11 != matrix4.m11) {
            return false;
        }
        if (this.m12 != matrix4.m12) {
            return false;
        }
        if (this.m13 != matrix4.m13) {
            return false;
        }
        if (this.m20 != matrix4.m20) {
            return false;
        }
        if (this.m21 != matrix4.m21) {
            return false;
        }
        if (this.m22 != matrix4.m22) {
            return false;
        }
        if (this.m23 != matrix4.m23) {
            return false;
        }
        if (this.m30 != matrix4.m30) {
            return false;
        }
        if (this.m31 != matrix4.m31) {
            return false;
        }
        if (this.m32 != matrix4.m32) {
            return false;
        }
        return this.m33 == matrix4.m33;
    }
}

