/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.BoundingBox;
import com.aspose.threed.Entity;
import com.aspose.threed.IMeshConvertible;
import com.aspose.threed.MathUtils;
import com.aspose.threed.Matrix4;
import com.aspose.threed.Mesh;
import com.aspose.threed.Profile;
import com.aspose.threed.Vector3;
import com.aspose.threed.dd;
import com.aspose.threed.nn;
import com.aspose.threed.utils.Struct;

public class LinearExtrusion
extends Entity
implements IMeshConvertible {
    private Vector3 direction = new Vector3();
    private double height = 1.0;
    private int slices = 1;
    private Profile shape;
    private boolean center;
    private Vector3 twistOffset = new Vector3();
    private double twist;

    public Profile getShape() {
        return this.shape;
    }

    /*
     * WARNING - void declaration
     */
    public void setShape(Profile value) {
        void var1_1;
        this.shape = var1_1;
    }

    public Vector3 getDirection() {
        return this.direction.clone();
    }

    /*
     * WARNING - void declaration
     */
    public void setDirection(Vector3 value) {
        void var1_1;
        if (value.getLength() < 1.0E-4) {
            throw new IllegalArgumentException("Invalid zero length direction.");
        }
        this.direction.copyFrom(var1_1.normalize());
    }

    public double getHeight() {
        return this.height;
    }

    /*
     * WARNING - void declaration
     */
    public void setHeight(double value) {
        void var1_1;
        if (value < 0.0) {
            throw new IllegalArgumentException("Invalid extrusion height");
        }
        this.height = var1_1;
    }

    public int getSlices() {
        return this.slices;
    }

    /*
     * WARNING - void declaration
     */
    public void setSlices(int value) {
        void var1_1;
        if (this.slices <= 0) {
            throw new IllegalArgumentException("Invalid slices.");
        }
        this.slices = var1_1;
    }

    public boolean getCenter() {
        return this.center;
    }

    /*
     * WARNING - void declaration
     */
    public void setCenter(boolean value) {
        void var1_1;
        this.center = var1_1;
    }

    public Vector3 getTwistOffset() {
        return this.twistOffset.clone();
    }

    /*
     * WARNING - void declaration
     */
    public void setTwistOffset(Vector3 value) {
        void var1_1;
        this.twistOffset.copyFrom((Vector3)var1_1);
    }

    public double getTwist() {
        return this.twist;
    }

    /*
     * WARNING - void declaration
     */
    public void setTwist(double value) {
        void var1_1;
        this.twist = var1_1;
    }

    public LinearExtrusion() {
        this.direction.copyFrom(Vector3.Z_AXIS);
    }

    /*
     * WARNING - void declaration
     */
    public LinearExtrusion(Profile shape, double height) {
        this();
        void var2_2;
        void var1_1;
        this.setShape((Profile)var1_1);
        this.setHeight((double)var2_2);
    }

    @Override
    final BoundingBox a(Matrix4 matrix4) {
        if (this.getShape() == null) {
            return BoundingBox.NULL.clone();
        }
        a a2 = new a(this);
        return a2.a(matrix4);
    }

    @Override
    public Mesh toMesh() {
        a a2 = new a(this);
        return a2.d();
    }

    static final class a
    extends dd {
        private LinearExtrusion c;
        private Vector3 d = new Vector3();
        private Matrix4 e = new Matrix4();
        private boolean f;
        private double g;

        public a(LinearExtrusion linearExtrusion) {
            super(linearExtrusion.shape);
            this.c = linearExtrusion;
        }

        @Override
        protected final void a() {
            a a2;
            this.g = MathUtils.toRadian(this.c.getTwist());
            this.f = Math.abs(a2.c.getTwist()) > 0.001;
            this.e.copyFrom(Matrix4.translate(this.c.getTwistOffset()));
            this.d.copyFrom(this.c.getCenter() ? Vector3.mul(-0.5 * this.c.height, this.c.direction) : Vector3.ORIGIN);
        }

        @Override
        protected final int c() {
            return Math.max(this.c.getSlices(), 1) + 1;
        }

        @Override
        protected final void a(int n2, int n3, Matrix4 matrix4) {
            double d2 = (double)n2 / (double)n3;
            Struct<Vector3> struct = Vector3.add(Vector3.mul(d2 * this.c.height, this.c.direction), this.d);
            matrix4.copyFrom(Matrix4.translate(struct));
            if (this.f) {
                struct = nn.a(d2 * this.g, this.c.direction);
                Matrix4 matrix42 = matrix4;
                matrix42.copyFrom(Matrix4.mul(Matrix4.mul(matrix42, (Matrix4)struct), this.e));
            }
        }
    }
}

