/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.threed;

import com.aspose.threed.BoundingBoxExtent;
import com.aspose.threed.Geometry;
import com.aspose.threed.Matrix4;
import com.aspose.threed.Vector3;
import com.aspose.threed.Vector4;
import com.aspose.threed.nn;
import com.aspose.threed.oZ;
import com.aspose.threed.utils.Struct;
import java.io.Serializable;

public final class BoundingBox
implements Struct<BoundingBox>,
Serializable {
    public static final BoundingBox NULL = new BoundingBox(BoundingBoxExtent.NULL);
    public static final BoundingBox INFINITE = new BoundingBox(BoundingBoxExtent.INFINITE);
    private Vector3 a = new Vector3();
    private Vector3 b = new Vector3();
    private BoundingBoxExtent c;
    static final long serialVersionUID = -172527941L;

    public final BoundingBoxExtent getExtent() {
        return this.c;
    }

    public final Vector3 getMinimum() {
        return this.a.clone();
    }

    public final Vector3 getMaximum() {
        return this.b.clone();
    }

    public final Vector3 getSize() {
        double d2 = this.b.x - this.a.x;
        double d3 = this.b.y - this.a.y;
        double d4 = this.b.z - this.a.z;
        return new Vector3(Math.abs(d2), Math.abs(d3), Math.abs(d4));
    }

    public final Vector3 getCenter() {
        return Vector3.add(this.a, Vector3.mul(Vector3.sub(this.b, this.a), 0.5));
    }

    /*
     * WARNING - void declaration
     */
    private BoundingBox(BoundingBoxExtent extent) {
        void var1_1;
        nn.e(this.a);
        nn.f(this.b);
        this.c = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public BoundingBox(Vector3 minimum, Vector3 maximum) {
        void var2_2;
        void var1_1;
        this.a.copyFrom(new Vector3(Math.min(minimum.x, maximum.x), Math.min(minimum.y, maximum.y), Math.min(minimum.z, maximum.z)));
        this.b.copyFrom(new Vector3(Math.max(minimum.x, maximum.x), Math.max(minimum.y, maximum.y), Math.max(var1_1.z, var2_2.z)));
        this.c = BoundingBoxExtent.FINITE;
    }

    /*
     * WARNING - void declaration
     */
    public BoundingBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this(new Vector3((double)var1_1, (double)var3_2, minZ), new Vector3(maxX, maxY, maxZ));
        void var3_2;
        void var1_1;
    }

    public static BoundingBox fromGeometry(Geometry geometry) {
        BoundingBox boundingBox = BoundingBox.a(geometry.controlPoints);
        return boundingBox;
    }

    static BoundingBox a(Geometry object, Matrix4 matrix4) {
        object = BoundingBox.a(((Geometry)object).controlPoints, matrix4);
        return object;
    }

    static BoundingBox a(oZ oZ2, Matrix4 matrix4) {
        if (oZ2 == null || oZ2.b == 0) {
            return NULL.clone();
        }
        if (matrix4.a()) {
            return BoundingBox.a(oZ2);
        }
        Vector3 vector3 = new Vector3();
        Vector3 vector32 = new Vector3();
        Vector3 vector33 = new Vector3(Matrix4.mul(matrix4, oZ2.c(0)));
        vector32.copyFrom(vector33);
        vector3.copyFrom(vector33);
        for (int i2 = 1; i2 < oZ2.b; ++i2) {
            Vector4 vector4 = Matrix4.mul(matrix4, oZ2.c(i2));
            vector3.x = Math.max(vector4.x, vector3.x);
            vector3.y = Math.max(vector4.y, vector3.y);
            vector3.z = Math.max(vector4.z, vector3.z);
            vector32.x = Math.min(vector4.x, vector32.x);
            vector32.y = Math.min(vector4.y, vector32.y);
            vector32.z = Math.min(vector4.z, vector32.z);
        }
        return new BoundingBox(vector32, vector3);
    }

    static BoundingBox a(oZ oZ2) {
        if (oZ2 == null || oZ2.b == 0) {
            return NULL.clone();
        }
        Vector3 vector3 = new Vector3();
        Vector3 vector32 = new Vector3();
        Vector3 vector33 = new Vector3(oZ2.c(0));
        vector32.copyFrom(vector33);
        vector3.copyFrom(vector33);
        for (int i2 = 0; i2 < oZ2.b; ++i2) {
            Vector4 vector4 = oZ2.c(i2);
            vector3.x = Math.max(vector4.x, vector3.x);
            vector3.y = Math.max(vector4.y, vector3.y);
            vector3.z = Math.max(vector4.z, vector3.z);
            vector32.x = Math.min(vector4.x, vector32.x);
            vector32.y = Math.min(vector4.y, vector32.y);
            vector32.z = Math.min(vector4.z, vector32.z);
        }
        return new BoundingBox(vector32, vector3);
    }

    final void a(Vector4 vector4) {
        this.a(vector4.x, vector4.y, vector4.z);
    }

    final void a(Vector3 vector3) {
        this.a(vector3.x, vector3.y, vector3.z);
    }

    final void a(double d2, double d3, double d4) {
        if (this.c == BoundingBoxExtent.INFINITE) {
            return;
        }
        if (this.c == BoundingBoxExtent.NULL) {
            Vector3 vector3 = new Vector3(d2, d3, d4);
            this.a.copyFrom(vector3);
            this.b.copyFrom(vector3);
        } else {
            this.b.b(d2, d3, d4);
            this.a.a(d2, d3, d4);
        }
        this.c = BoundingBoxExtent.FINITE;
    }

    final void a(BoundingBox boundingBox) {
        if (boundingBox.c == BoundingBoxExtent.NULL || this.c == BoundingBoxExtent.INFINITE) {
            return;
        }
        if (boundingBox.c == BoundingBoxExtent.INFINITE) {
            this.c = BoundingBoxExtent.INFINITE;
            return;
        }
        if (this.c == BoundingBoxExtent.NULL) {
            this.a(boundingBox.a, boundingBox.b);
            return;
        }
        Vector3 vector3 = this.a.clone();
        Vector3 vector32 = this.b.clone();
        vector32.b(boundingBox.b);
        vector32.b(boundingBox.a);
        vector3.a(boundingBox.a);
        vector3.a(boundingBox.b);
        this.a(vector3, vector32);
    }

    private void a(Vector3 vector3, Vector3 vector32) {
        this.c = BoundingBoxExtent.FINITE;
        this.a.copyFrom(vector3);
        this.b.copyFrom(vector32);
    }

    /*
     * WARNING - void declaration
     */
    public static BoundingBox mul(BoundingBox bbox, Matrix4 mat) {
        Struct<BoundingBox> struct;
        void var1_1;
        if (bbox.c != BoundingBoxExtent.FINITE) {
            return bbox.clone();
        }
        Vector3 vector3 = Matrix4.mul(mat, bbox.a);
        struct = Matrix4.mul((Matrix4)var1_1, struct.b);
        return new BoundingBox(vector3, (Vector3)struct);
    }

    public final String toString() {
        if (this.c == BoundingBoxExtent.NULL) {
            return "null";
        }
        if (this.c == BoundingBoxExtent.INFINITE) {
            return "infinite";
        }
        return String.format("%s~%s", this.a, this.b);
    }

    public final boolean equals(Object obj) {
        BoundingBox boundingBox;
        if (!(obj instanceof BoundingBox)) {
            return false;
        }
        boundingBox = ((BoundingBox)boundingBox).clone();
        if (this.c != boundingBox.c) {
            return false;
        }
        return this.a.c(boundingBox.a) && this.b.c(boundingBox.b);
    }

    public BoundingBox() {
    }

    /*
     * WARNING - void declaration
     */
    private BoundingBox(BoundingBox other) {
        void var1_1;
        this.a = other.a.clone();
        this.b = other.b.clone();
        this.c = var1_1.c;
    }

    @Override
    public final BoundingBox clone() {
        return new BoundingBox(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void copyFrom(BoundingBox src) {
        void var1_1;
        if (src == null) {
            return;
        }
        this.a = src.a.clone();
        this.b = src.b.clone();
        this.c = var1_1.c;
    }

    public final int hashCode() {
        return this.a.hashCode() ^ this.b.hashCode() ^ this.c.hashCode();
    }
}

