/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.bouncycastle.crypto.generators;

import com.github.dockerjava.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.KeyGenerationParameters;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.params.DHParameters;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.params.ElGamalParameters;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import java.math.BigInteger;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ElGamalKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (ElGamalKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper dHKeyGeneratorHelper = DHKeyGeneratorHelper.INSTANCE;
        ElGamalParameters elGamalParameters = this.param.getParameters();
        DHParameters dHParameters = new DHParameters(elGamalParameters.getP(), elGamalParameters.getG(), null, elGamalParameters.getL());
        BigInteger bigInteger = dHKeyGeneratorHelper.calculatePrivate(dHParameters, this.param.getRandom());
        BigInteger bigInteger2 = dHKeyGeneratorHelper.calculatePublic(dHParameters, bigInteger);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(bigInteger2, elGamalParameters), new ElGamalPrivateKeyParameters(bigInteger, elGamalParameters));
    }
}

