/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.bouncycastle.cms;

import com.github.dockerjava.shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.DEROctetString;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.DERSequence;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.cms.PasswordRecipientInfo;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.cms.RecipientInfo;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.pkcs.PBKDF2Params;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.github.dockerjava.shaded.org.bouncycastle.cms.CMSException;
import com.github.dockerjava.shaded.org.bouncycastle.cms.PasswordRecipientInformation;
import com.github.dockerjava.shaded.org.bouncycastle.cms.RecipientInfoGenerator;
import com.github.dockerjava.shaded.org.bouncycastle.operator.GenericKey;
import java.security.SecureRandom;

public abstract class PasswordRecipientInfoGenerator
implements RecipientInfoGenerator {
    protected char[] password;
    private AlgorithmIdentifier keyDerivationAlgorithm;
    private ASN1ObjectIdentifier kekAlgorithm;
    private SecureRandom random;
    private int schemeID;
    private int keySize;
    private int blockSize;

    protected PasswordRecipientInfoGenerator(ASN1ObjectIdentifier aSN1ObjectIdentifier, char[] cArray) {
        this(aSN1ObjectIdentifier, cArray, PasswordRecipientInfoGenerator.getKeySize(aSN1ObjectIdentifier), (Integer)PasswordRecipientInformation.BLOCKSIZES.get(aSN1ObjectIdentifier));
    }

    protected PasswordRecipientInfoGenerator(ASN1ObjectIdentifier aSN1ObjectIdentifier, char[] cArray, int n, int n2) {
        this.password = cArray;
        this.schemeID = 1;
        this.kekAlgorithm = aSN1ObjectIdentifier;
        this.keySize = n;
        this.blockSize = n2;
    }

    private static int getKeySize(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        Integer n = (Integer)PasswordRecipientInformation.KEYSIZES.get(aSN1ObjectIdentifier);
        if (n == null) {
            throw new IllegalArgumentException("cannot find key size for algorithm: " + aSN1ObjectIdentifier);
        }
        return n;
    }

    public PasswordRecipientInfoGenerator setPasswordConversionScheme(int n) {
        this.schemeID = n;
        return this;
    }

    public PasswordRecipientInfoGenerator setSaltAndIterationCount(byte[] byArray, int n) {
        this.keyDerivationAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBKDF2, new PBKDF2Params(byArray, n));
        return this;
    }

    public PasswordRecipientInfoGenerator setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public RecipientInfo generate(GenericKey genericKey) throws CMSException {
        byte[] byArray;
        byte[] byArray2 = new byte[this.blockSize];
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.random.nextBytes(byArray2);
        if (this.keyDerivationAlgorithm == null) {
            byArray = new byte[20];
            this.random.nextBytes(byArray);
            this.keyDerivationAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBKDF2, new PBKDF2Params(byArray, 1024));
        }
        byArray = this.calculateDerivedKey(this.schemeID, this.keyDerivationAlgorithm, this.keySize);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(this.kekAlgorithm, new DEROctetString(byArray2));
        byte[] byArray3 = this.generateEncryptedBytes(algorithmIdentifier, byArray, genericKey);
        DEROctetString dEROctetString = new DEROctetString(byArray3);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.kekAlgorithm);
        aSN1EncodableVector.add(new DEROctetString(byArray2));
        AlgorithmIdentifier algorithmIdentifier2 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_PWRI_KEK, new DERSequence(aSN1EncodableVector));
        return new RecipientInfo(new PasswordRecipientInfo(this.keyDerivationAlgorithm, algorithmIdentifier2, dEROctetString));
    }

    protected abstract byte[] calculateDerivedKey(int var1, AlgorithmIdentifier var2, int var3) throws CMSException;

    protected abstract byte[] generateEncryptedBytes(AlgorithmIdentifier var1, byte[] var2, GenericKey var3) throws CMSException;
}

