/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.bouncycastle.cert.bc;

import com.github.dockerjava.shaded.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import com.github.dockerjava.shaded.org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import com.github.dockerjava.shaded.org.bouncycastle.cert.X509ExtensionUtils;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.digests.SHA1Digest;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.github.dockerjava.shaded.org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import com.github.dockerjava.shaded.org.bouncycastle.operator.DigestCalculator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BcX509ExtensionUtils
extends X509ExtensionUtils {
    public BcX509ExtensionUtils() {
        super(new SHA1DigestCalculator());
    }

    public BcX509ExtensionUtils(DigestCalculator digestCalculator) {
        super(digestCalculator);
    }

    public AuthorityKeyIdentifier createAuthorityKeyIdentifier(AsymmetricKeyParameter asymmetricKeyParameter) throws IOException {
        return super.createAuthorityKeyIdentifier(SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(asymmetricKeyParameter));
    }

    public SubjectKeyIdentifier createSubjectKeyIdentifier(AsymmetricKeyParameter asymmetricKeyParameter) throws IOException {
        return super.createSubjectKeyIdentifier(SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(asymmetricKeyParameter));
    }

    private static class SHA1DigestCalculator
    implements DigestCalculator {
        private ByteArrayOutputStream bOut = new ByteArrayOutputStream();

        private SHA1DigestCalculator() {
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1);
        }

        public OutputStream getOutputStream() {
            return this.bOut;
        }

        public byte[] getDigest() {
            byte[] byArray = this.bOut.toByteArray();
            this.bOut.reset();
            SHA1Digest sHA1Digest = new SHA1Digest();
            sHA1Digest.update(byArray, 0, byArray.length);
            byte[] byArray2 = new byte[sHA1Digest.getDigestSize()];
            sHA1Digest.doFinal(byArray2, 0);
            return byArray2;
        }
    }
}

