/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.apache.tools.ant.types.selectors;

import com.github.dockerjava.shaded.org.apache.tools.ant.BuildException;
import com.github.dockerjava.shaded.org.apache.tools.ant.Project;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.Parameter;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.Resource;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.resources.FileResource;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.resources.selectors.ResourceSelector;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.selectors.BaseExtendSelector;
import com.github.dockerjava.shaded.org.apache.tools.ant.types.selectors.SelectorUtils;
import com.github.dockerjava.shaded.org.apache.tools.ant.util.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class ContainsSelector
extends BaseExtendSelector
implements ResourceSelector {
    private String contains = null;
    private boolean casesensitive = true;
    private boolean ignorewhitespace = false;
    private String encoding = null;
    public static final String EXPRESSION_KEY = "expression";
    public static final String CONTAINS_KEY = "text";
    public static final String CASE_KEY = "casesensitive";
    public static final String WHITESPACE_KEY = "ignorewhitespace";

    public String toString() {
        StringBuilder buf = new StringBuilder("{containsselector text: ");
        buf.append('\"').append(this.contains).append('\"');
        buf.append(" casesensitive: ");
        buf.append(this.casesensitive ? "true" : "false");
        buf.append(" ignorewhitespace: ");
        buf.append(this.ignorewhitespace ? "true" : "false");
        buf.append("}");
        return buf.toString();
    }

    public void setText(String contains) {
        this.contains = contains;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setCasesensitive(boolean casesensitive) {
        this.casesensitive = casesensitive;
    }

    public void setIgnorewhitespace(boolean ignorewhitespace) {
        this.ignorewhitespace = ignorewhitespace;
    }

    public void setParameters(Parameter[] parameters) {
        super.setParameters(parameters);
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                String paramname = parameters[i].getName();
                if (CONTAINS_KEY.equalsIgnoreCase(paramname)) {
                    this.setText(parameters[i].getValue());
                    continue;
                }
                if (CASE_KEY.equalsIgnoreCase(paramname)) {
                    this.setCasesensitive(Project.toBoolean(parameters[i].getValue()));
                    continue;
                }
                if (WHITESPACE_KEY.equalsIgnoreCase(paramname)) {
                    this.setIgnorewhitespace(Project.toBoolean(parameters[i].getValue()));
                    continue;
                }
                this.setError("Invalid parameter " + paramname);
            }
        }
    }

    public void verifySettings() {
        if (this.contains == null) {
            this.setError("The text attribute is required");
        }
    }

    public boolean isSelected(File basedir, String filename, File file) {
        return this.isSelected(new FileResource(file));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSelected(Resource r) {
        boolean bl;
        BufferedReader in;
        block15: {
            boolean bl2;
            block14: {
                this.validate();
                if (r.isDirectory()) return true;
                if (this.contains.length() == 0) {
                    return true;
                }
                String userstr = this.contains;
                if (!this.casesensitive) {
                    userstr = this.contains.toLowerCase();
                }
                if (this.ignorewhitespace) {
                    userstr = SelectorUtils.removeWhitespace(userstr);
                }
                in = null;
                try {
                    in = this.encoding != null ? new BufferedReader(new InputStreamReader(r.getInputStream(), this.encoding)) : new BufferedReader(new InputStreamReader(r.getInputStream()));
                }
                catch (Exception e) {
                    throw new BuildException("Could not get InputStream from " + r.toLongString(), e);
                }
                try {
                    try {
                        String teststr = in.readLine();
                        while (teststr != null) {
                            if (!this.casesensitive) {
                                teststr = teststr.toLowerCase();
                            }
                            if (this.ignorewhitespace) {
                                teststr = SelectorUtils.removeWhitespace(teststr);
                            }
                            if (teststr.indexOf(userstr) > -1) {
                                bl2 = true;
                                Object var7_9 = null;
                                break block14;
                            }
                            teststr = in.readLine();
                        }
                        bl = false;
                        break block15;
                    }
                    catch (IOException ioe) {
                        throw new BuildException("Could not read " + r.toLongString());
                    }
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    FileUtils.close(in);
                    throw throwable;
                }
            }
            FileUtils.close(in);
            return bl2;
        }
        Object var7_10 = null;
        FileUtils.close(in);
        return bl;
    }
}

