/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.org.apache.tools.ant.property;

import com.github.dockerjava.shaded.org.apache.tools.ant.PropertyHelper;
import com.github.dockerjava.shaded.org.apache.tools.ant.property.NullReturn;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalPropertyStack {
    private final LinkedList<Map<String, Object>> stack = new LinkedList();

    public void addLocal(String property) {
        if (!this.stack.isEmpty()) {
            this.stack.getFirst().put(property, NullReturn.NULL);
        }
    }

    public void enterScope() {
        this.stack.addFirst(new HashMap());
    }

    public void exitScope() {
        this.stack.removeFirst().clear();
    }

    public LocalPropertyStack copy() {
        LocalPropertyStack ret = new LocalPropertyStack();
        ret.stack.addAll(this.stack);
        return ret;
    }

    public Object evaluate(String property, PropertyHelper helper) {
        for (Map map : this.stack) {
            Object ret = map.get(property);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public boolean setNew(String property, Object value, PropertyHelper propertyHelper) {
        Map<String, Object> map = this.getMapForProperty(property);
        if (map == null) {
            return false;
        }
        Object currValue = map.get(property);
        if (currValue == NullReturn.NULL) {
            map.put(property, value);
        }
        return true;
    }

    public boolean set(String property, Object value, PropertyHelper propertyHelper) {
        Map<String, Object> map = this.getMapForProperty(property);
        if (map == null) {
            return false;
        }
        map.put(property, value);
        return true;
    }

    private Map<String, Object> getMapForProperty(String property) {
        for (Map map : this.stack) {
            if (map.get(property) == null) continue;
            return map;
        }
        return null;
    }
}

