/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.net.sf.cglib.proxy;

import com.github.dockerjava.shaded.net.sf.cglib.proxy.Callback;
import com.github.dockerjava.shaded.net.sf.cglib.proxy.CallbackGenerator;
import com.github.dockerjava.shaded.net.sf.cglib.proxy.Dispatcher;
import com.github.dockerjava.shaded.net.sf.cglib.proxy.DispatcherGenerator;
import com.github.dockerjava.shaded.net.sf.cglib.proxy.FixedValue;
import com.github.dockerjava.shaded.net.sf.cglib.proxy.FixedValueGenerator;
import com.github.dockerjava.shaded.net.sf.cglib.proxy.InvocationHandler;
import com.github.dockerjava.shaded.net.sf.cglib.proxy.InvocationHandlerGenerator;
import com.github.dockerjava.shaded.net.sf.cglib.proxy.LazyLoader;
import com.github.dockerjava.shaded.net.sf.cglib.proxy.LazyLoaderGenerator;
import com.github.dockerjava.shaded.net.sf.cglib.proxy.MethodInterceptor;
import com.github.dockerjava.shaded.net.sf.cglib.proxy.MethodInterceptorGenerator;
import com.github.dockerjava.shaded.net.sf.cglib.proxy.NoOp;
import com.github.dockerjava.shaded.net.sf.cglib.proxy.NoOpGenerator;
import com.github.dockerjava.shaded.net.sf.cglib.proxy.ProxyRefDispatcher;
import com.github.dockerjava.shaded.org.objectweb.asm.Type;

class CallbackInfo {
    private Class cls;
    private CallbackGenerator generator;
    private Type type;
    private static final CallbackInfo[] CALLBACKS = new CallbackInfo[]{new CallbackInfo(NoOp.class, NoOpGenerator.INSTANCE), new CallbackInfo(MethodInterceptor.class, MethodInterceptorGenerator.INSTANCE), new CallbackInfo(InvocationHandler.class, InvocationHandlerGenerator.INSTANCE), new CallbackInfo(LazyLoader.class, LazyLoaderGenerator.INSTANCE), new CallbackInfo(Dispatcher.class, DispatcherGenerator.INSTANCE), new CallbackInfo(FixedValue.class, FixedValueGenerator.INSTANCE), new CallbackInfo(ProxyRefDispatcher.class, DispatcherGenerator.PROXY_REF_INSTANCE)};

    public static Type[] determineTypes(Class[] callbackTypes) {
        Type[] types = new Type[callbackTypes.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = CallbackInfo.determineType(callbackTypes[i]);
        }
        return types;
    }

    public static Type[] determineTypes(Callback[] callbacks) {
        Type[] types = new Type[callbacks.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = CallbackInfo.determineType(callbacks[i]);
        }
        return types;
    }

    public static CallbackGenerator[] getGenerators(Type[] callbackTypes) {
        CallbackGenerator[] generators = new CallbackGenerator[callbackTypes.length];
        for (int i = 0; i < generators.length; ++i) {
            generators[i] = CallbackInfo.getGenerator(callbackTypes[i]);
        }
        return generators;
    }

    private CallbackInfo(Class cls, CallbackGenerator generator) {
        this.cls = cls;
        this.generator = generator;
        this.type = Type.getType(cls);
    }

    private static Type determineType(Callback callback) {
        if (callback == null) {
            throw new IllegalStateException("Callback is null");
        }
        return CallbackInfo.determineType(callback.getClass());
    }

    private static Type determineType(Class callbackType) {
        Class cur = null;
        for (int i = 0; i < CALLBACKS.length; ++i) {
            CallbackInfo info = CALLBACKS[i];
            if (!info.cls.isAssignableFrom(callbackType)) continue;
            if (cur != null) {
                String string = String.valueOf(cur);
                String string2 = String.valueOf(info.cls);
                throw new IllegalStateException(new StringBuilder(30 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Callback implements both ").append(string).append(" and ").append(string2).toString());
            }
            cur = info.cls;
        }
        if (cur == null) {
            String string = String.valueOf(callbackType);
            throw new IllegalStateException(new StringBuilder(22 + String.valueOf(string).length()).append("Unknown callback type ").append(string).toString());
        }
        return Type.getType(cur);
    }

    private static CallbackGenerator getGenerator(Type callbackType) {
        for (int i = 0; i < CALLBACKS.length; ++i) {
            CallbackInfo info = CALLBACKS[i];
            if (!info.type.equals(callbackType)) continue;
            return info.generator;
        }
        String string = String.valueOf(callbackType);
        throw new IllegalStateException(new StringBuilder(22 + String.valueOf(string).length()).append("Unknown callback type ").append(string).toString());
    }
}

