/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.shaded.io.netty.channel.unix;

import com.github.dockerjava.shaded.io.netty.buffer.ByteBuf;
import com.github.dockerjava.shaded.io.netty.channel.unix.Limits;

public final class UnixChannelUtil {
    private UnixChannelUtil() {
    }

    public static boolean isBufferCopyNeededForWrite(ByteBuf byteBuf) {
        return UnixChannelUtil.isBufferCopyNeededForWrite(byteBuf, Limits.IOV_MAX);
    }

    static boolean isBufferCopyNeededForWrite(ByteBuf byteBuf, int iovMax) {
        return !byteBuf.hasMemoryAddress() && (!byteBuf.isDirect() || byteBuf.nioBufferCount() > iovMax);
    }
}

