/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.core.MediaType;
import com.github.dockerjava.core.async.ResultCallbackTemplate;
import com.github.dockerjava.shaded.com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;

public interface InvocationBuilder {
    public InvocationBuilder accept(MediaType var1);

    public InvocationBuilder header(String var1, String var2);

    public void delete();

    public void get(ResultCallback<Frame> var1);

    public <T> T get(TypeReference<T> var1);

    public <T> void get(TypeReference<T> var1, ResultCallback<T> var2);

    public InputStream post(Object var1);

    public void post(Object var1, InputStream var2, ResultCallback<Frame> var3);

    public <T> T post(Object var1, TypeReference<T> var2);

    public <T> void post(Object var1, TypeReference<T> var2, ResultCallback<T> var3);

    public <T> T post(TypeReference<T> var1, InputStream var2);

    public <T> void post(TypeReference<T> var1, ResultCallback<T> var2, InputStream var3);

    public void postStream(InputStream var1);

    public InputStream get();

    public void put(InputStream var1, MediaType var2);

    public static class AsyncResultCallback<A_RES_T>
    extends ResultCallbackTemplate<AsyncResultCallback<A_RES_T>, A_RES_T> {
        private A_RES_T result = null;
        private final CountDownLatch resultReady = new CountDownLatch(1);

        @Override
        public void onNext(A_RES_T object) {
            this.onResult(object);
        }

        private void onResult(A_RES_T object) {
            if (this.resultReady.getCount() == 0L) {
                throw new IllegalStateException("Result has already been set");
            }
            try {
                this.result = object;
            }
            finally {
                this.resultReady.countDown();
            }
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.resultReady.countDown();
            }
        }

        public A_RES_T awaitResult() {
            try {
                this.resultReady.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.throwFirstError();
            return this.result;
        }
    }
}

