/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils.cxx.io;

import java.io.Reader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016JW\u0010\r\u001a\u00020\f2O\u0010\u000e\u001aK\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0003\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\f0\u000fj\u0002`\u0012J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0016R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/utils/cxx/io/ProgressReader;", "Ljava/io/Reader;", "reader", "filename", "", "totalBytes", "", "progressIntervalMillis", "(Ljava/io/Reader;Ljava/lang/String;JJ)V", "bytesRead", "lastProgressPostedMillis", "close", "", "postProgress", "progress", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "Lcom/android/utils/cxx/io/ProgressCallback;", "read", "", "cbuf", "", "off", "len", "common"})
public final class ProgressReader
extends Reader {
    @NotNull
    private final Reader reader;
    @NotNull
    private final String filename;
    private final long totalBytes;
    private final long progressIntervalMillis;
    private long lastProgressPostedMillis;
    private long bytesRead;

    public ProgressReader(@NotNull Reader reader, @NotNull String filename, long totalBytes, long progressIntervalMillis) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.reader = reader;
        this.filename = filename;
        this.totalBytes = totalBytes;
        this.progressIntervalMillis = progressIntervalMillis;
        this.lastProgressPostedMillis = System.currentTimeMillis();
    }

    @Override
    public int read(@NotNull char[] cbuf, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
        int bytes = this.reader.read(cbuf, off, len);
        this.bytesRead += (long)bytes;
        return bytes;
    }

    @Override
    public void close() {
        this.reader.close();
    }

    public final void postProgress(@NotNull Function3<? super String, ? super Long, ? super Long, Unit> progress) {
        Intrinsics.checkNotNullParameter(progress, (String)"progress");
        if (this.progressIntervalMillis == Long.MAX_VALUE) {
            return;
        }
        if (this.progressIntervalMillis > 0L) {
            long current = System.currentTimeMillis();
            long elapsed = current - this.lastProgressPostedMillis;
            if (elapsed < this.progressIntervalMillis) {
                return;
            }
            this.lastProgressPostedMillis = current;
        }
        progress.invoke((Object)this.filename, (Object)this.totalBytes, (Object)this.bytesRead);
    }
}

