/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class StringHelperWindows {
    public static List<String> splitCommandLine(String commandLine) {
        ArrayList commands = Lists.newArrayList();
        boolean quoting = false;
        boolean escapingQuotes = false;
        boolean escapingOthers = false;
        int commandStart = 0;
        int length = commandLine.length();
        for (int i = 0; i < length; ++i) {
            char c = commandLine.charAt(i);
            if (c == '\"' && !escapingQuotes) {
                quoting = !quoting;
                continue;
            }
            if (escapingQuotes) {
                escapingQuotes = false;
            } else if (c == '\\') {
                escapingQuotes = true;
                continue;
            }
            if (escapingOthers) {
                escapingOthers = false;
                continue;
            }
            if (c == '^') {
                escapingOthers = true;
                continue;
            }
            if (quoting || commandLine.charAt(i) != '&') continue;
            commands.add(commandLine.substring(commandStart, i));
            if (commandLine.length() <= ++i || commandLine.charAt(i) == '&') {
                // empty if block
            }
            commandStart = ++i;
        }
        if (commandStart < length) {
            commands.add(commandLine.substring(commandStart));
        }
        return commands;
    }

    public static List<String> tokenizeCommandLineToEscaped(String commandLine) {
        return StringHelperWindows.tokenizeCommandLine(commandLine, true);
    }

    public static List<String> tokenizeCommandLineToRaw(String commandLine) {
        return StringHelperWindows.tokenizeCommandLine(commandLine, false);
    }

    private static List<String> tokenizeCommandLine(String commandLine, boolean returnEscaped) {
        ArrayList tokens = Lists.newArrayList();
        StringBuilder token = new StringBuilder();
        boolean quoting = false;
        boolean escapingQuotes = false;
        boolean escapingOthers = false;
        boolean skipping = true;
        for (int i = 0; i < commandLine.length(); ++i) {
            char c = commandLine.charAt(i);
            if (skipping) {
                if (Character.isWhitespace(c)) continue;
                skipping = false;
            }
            if (!(!quoting && Character.isWhitespace(c) || returnEscaped)) {
                token.append(c);
            }
            if (c == '\"') {
                if (returnEscaped) {
                    for (int j = token.length() - 2; j >= 0 && token.charAt(j) == '\\' && token.charAt(j + 1) == '\\'; j -= 2) {
                        token.deleteCharAt(j);
                    }
                }
                if (escapingQuotes) {
                    if (returnEscaped) {
                        token.deleteCharAt(token.length() - 1);
                    }
                } else {
                    quoting = !quoting;
                    continue;
                }
            }
            if (escapingQuotes) {
                escapingQuotes = false;
            } else if (c == '\\') {
                escapingQuotes = true;
            }
            if (escapingOthers) {
                escapingOthers = false;
                if (c == '\n') {
                    continue;
                }
            } else if (!quoting && c == '^') {
                escapingOthers = true;
                continue;
            }
            if (!quoting && Character.isWhitespace(c)) {
                skipping = true;
                if (token.length() > 0) {
                    tokens.add(token.toString());
                }
                token.setLength(0);
                continue;
            }
            if (!returnEscaped) continue;
            token.append(c);
        }
        if (token.length() > 0) {
            tokens.add(token.toString());
        }
        return tokens;
    }
}

