/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.shrinker;

import com.android.build.shrinker.FileReporter;
import com.android.build.shrinker.LinkedResourcesFormat;
import com.android.build.shrinker.NoDebugReporter;
import com.android.build.shrinker.ResourceShrinkerImpl;
import com.android.build.shrinker.gatherer.ProtoResourceTableGatherer;
import com.android.build.shrinker.graph.ProtoResourcesGraphBuilder;
import com.android.build.shrinker.obfuscation.ProguardMappingsRecorder;
import com.android.build.shrinker.usages.DexUsageRecorder;
import com.android.build.shrinker.usages.ProtoAndroidManifestUsageRecorder;
import com.android.build.shrinker.usages.ResourceUsageRecorder;
import com.android.build.shrinker.usages.ToolsAttributeUsageRecorder;
import com.android.utils.FileUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ResourceShrinkerCli {
    private static final String INPUT_ARG = "--input";
    private static final String DEX_INPUT_ARG = "--dex_input";
    private static final String OUTPUT_ARG = "--output";
    private static final String RES_ARG = "--raw_resources";
    private static final String PROGUARD_MAP = "--proguard_map";
    private static final String HELP_ARG = "--help";
    private static final String PRINT_USAGE_LOG = "--print_usage_log";
    private static final String ANDROID_MANIFEST_XML = "AndroidManifest.xml";
    private static final String RESOURCES_PB = "resources.pb";
    private static final String RES_FOLDER = "res";

    public static void main(String[] args) {
        ResourceShrinkerCli.run(args);
    }

    protected static ResourceShrinkerImpl run(String[] args) {
        try {
            Options options = Options.parseOptions(args);
            if (options.isHelp()) {
                ResourceShrinkerCli.printUsage();
                return null;
            }
            ResourceShrinkerCli.validateOptions(options);
            ResourceShrinkerImpl resourceShrinker = ResourceShrinkerCli.runResourceShrinking(options);
            return resourceShrinker;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ResourceShrinkingFailedException("Failed running resource shrinking: " + e.getMessage(), e);
        }
    }

    private static ResourceShrinkerImpl runResourceShrinking(Options options) throws IOException, ParserConfigurationException, SAXException {
        ResourceShrinkerCli.validateInput(options.getInput());
        ArrayList<ResourceUsageRecorder> resourceUsageRecorders = new ArrayList<ResourceUsageRecorder>();
        for (String dexInput : options.dex_inputs) {
            ResourceShrinkerCli.validateFileExists(dexInput);
            resourceUsageRecorders.add(new DexUsageRecorder(FileUtils.createZipFilesystem((Path)Paths.get(dexInput, new String[0])).getPath("", new String[0])));
        }
        Path protoApk = Paths.get(options.getInput(), new String[0]);
        Path protoApkOut = Paths.get(options.getOutput(), new String[0]);
        FileSystem fileSystemProto = FileUtils.createZipFilesystem((Path)protoApk);
        resourceUsageRecorders.add(new DexUsageRecorder(fileSystemProto.getPath("", new String[0])));
        resourceUsageRecorders.add(new ProtoAndroidManifestUsageRecorder(fileSystemProto.getPath(ANDROID_MANIFEST_XML, new String[0])));
        for (String rawResource : options.getRawResources()) {
            resourceUsageRecorders.add(new ToolsAttributeUsageRecorder(Paths.get(rawResource, new String[0])));
        }
        if (new ZipFile(options.getInput()).stream().anyMatch(zipEntry -> zipEntry.getName().startsWith("res/raw"))) {
            Path rawPath = fileSystemProto.getPath(RES_FOLDER, "raw");
            resourceUsageRecorders.add(new ToolsAttributeUsageRecorder(rawPath));
        }
        ProtoResourceTableGatherer gatherer = new ProtoResourceTableGatherer(fileSystemProto.getPath(RESOURCES_PB, new String[0]));
        ProtoResourcesGraphBuilder res = new ProtoResourcesGraphBuilder(fileSystemProto.getPath(RES_FOLDER, new String[0]), fileSystemProto.getPath(RESOURCES_PB, new String[0]));
        ProguardMappingsRecorder proguardMappingsRecorder = options.proguardMap != null ? new ProguardMappingsRecorder(Paths.get(options.proguardMap, new String[0])) : null;
        ResourceShrinkerImpl resourceShrinker = new ResourceShrinkerImpl(List.of(gatherer), proguardMappingsRecorder, resourceUsageRecorders, List.of(res), options.usageLog != null ? new FileReporter(Paths.get(options.usageLog, new String[0]).toFile()) : NoDebugReporter.INSTANCE, false, true);
        resourceShrinker.analyze();
        resourceShrinker.rewriteResourcesInApkFormat(protoApk.toFile(), protoApkOut.toFile(), LinkedResourcesFormat.PROTO);
        return resourceShrinker;
    }

    private static void validateInput(String input) throws IOException {
        ZipFile zipfile = new ZipFile(input);
        if (zipfile.getEntry(ANDROID_MANIFEST_XML) == null) {
            throw new ResourceShrinkingFailedException("Input must include AndroidManifest.xml");
        }
        if (zipfile.getEntry(RESOURCES_PB) == null) {
            throw new ResourceShrinkingFailedException("Input must include resources.pb. Did you not convert the input apk to proto?");
        }
        if (zipfile.stream().noneMatch(zipEntry -> zipEntry.getName().startsWith(RES_FOLDER))) {
            throw new ResourceShrinkingFailedException("Input must include a res folder");
        }
    }

    private static void validateFileExists(String file) {
        if (!Paths.get(file, new String[0]).toFile().exists()) {
            throw new RuntimeException("Can't find file: " + file);
        }
    }

    private static void validateOptions(Options options) {
        if (options.getInput() == null) {
            throw new ResourceShrinkingFailedException("No input given.");
        }
        if (options.getOutput() == null) {
            throw new ResourceShrinkingFailedException("No output destination given.");
        }
        ResourceShrinkerCli.validateFileExists(options.getInput());
        for (String rawResource : options.getRawResources()) {
            ResourceShrinkerCli.validateFileExists(rawResource);
        }
        if (options.proguardMap != null) {
            ResourceShrinkerCli.validateFileExists(options.proguardMap);
        }
    }

    private static void printUsage() {
        PrintStream out = System.err;
        out.println("Usage:");
        out.println("  resourceshrinker ");
        out.println("    --input <input-file>, container with manifest, resources table and res");
        out.println("      folder. May contain dex.");
        out.println("    --dex_input <input-file> Container with dex files (only dex will be ");
        out.println("       handled if this contains other files. Several --dex_input arguments");
        out.println("       are supported");
        out.println("    --output <output-file>");
        out.println("    --proguard_map <mapping file>");
        out.println("    --raw_resources <xml-file or res directory>");
        out.println("      optional, more than one raw_resoures argument might be given");
        out.println("    --help prints this help message");
    }

    private static class Options {
        private String input;
        private final List<String> dex_inputs = new ArrayList<String>();
        private String output;
        private String proguardMap;
        private String usageLog;
        private final List<String> rawResources = new ArrayList<String>();
        private boolean help;

        private Options() {
        }

        public static Options parseOptions(String[] args) {
            Options options = new Options();
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.startsWith(ResourceShrinkerCli.INPUT_ARG)) {
                    if (++i == args.length) {
                        throw new ResourceShrinkingFailedException("No argument given for input");
                    }
                    if (options.input != null) {
                        throw new ResourceShrinkingFailedException("More than one input not supported");
                    }
                    options.input = args[i];
                    continue;
                }
                if (arg.startsWith(ResourceShrinkerCli.OUTPUT_ARG)) {
                    if (++i == args.length) {
                        throw new ResourceShrinkingFailedException("No argument given for output");
                    }
                    if (options.output != null) {
                        throw new ResourceShrinkingFailedException("More than one output not supported");
                    }
                    options.output = args[i];
                    continue;
                }
                if (arg.startsWith(ResourceShrinkerCli.DEX_INPUT_ARG)) {
                    if (++i == args.length) {
                        throw new ResourceShrinkingFailedException("No argument given for dex_input");
                    }
                    options.dex_inputs.add(args[i]);
                    continue;
                }
                if (arg.startsWith(ResourceShrinkerCli.PRINT_USAGE_LOG)) {
                    if (++i == args.length) {
                        throw new ResourceShrinkingFailedException("No argument given for usage log");
                    }
                    if (options.usageLog != null) {
                        throw new ResourceShrinkingFailedException("More than usage log not supported");
                    }
                    options.usageLog = args[i];
                    continue;
                }
                if (arg.startsWith(ResourceShrinkerCli.RES_ARG)) {
                    if (++i == args.length) {
                        throw new ResourceShrinkingFailedException("No argument given for raw_resources");
                    }
                    options.rawResources.add(args[i]);
                    continue;
                }
                if (arg.startsWith(ResourceShrinkerCli.PROGUARD_MAP)) {
                    if (++i == args.length) {
                        throw new ResourceShrinkingFailedException("No argument given for proguard_map");
                    }
                    options.proguardMap = args[i];
                    continue;
                }
                if (arg.equals(ResourceShrinkerCli.HELP_ARG)) {
                    options.help = true;
                    continue;
                }
                throw new ResourceShrinkingFailedException("Unknown argument " + arg);
            }
            return options;
        }

        public String getInput() {
            return this.input;
        }

        public String getOutput() {
            return this.output;
        }

        public String getUsageLog() {
            return this.usageLog;
        }

        public List<String> getRawResources() {
            return this.rawResources;
        }

        public boolean isHelp() {
            return this.help;
        }
    }

    private static class ResourceShrinkingFailedException
    extends RuntimeException {
        public ResourceShrinkingFailedException(String message2) {
            super(message2);
        }

        public ResourceShrinkingFailedException(String message2, Exception e) {
            super(message2, e);
        }
    }
}

