/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.dependency.ShrinkerVersion;
import com.android.build.gradle.internal.tasks.R8VersionCheckException;
import com.android.builder.errors.IssueReporter;
import com.android.tools.r8.Version;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"checkIfR8VersionMatches", "", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "gradle-core"})
public final class R8VersionCheckKt {
    public static final void checkIfR8VersionMatches(@NotNull IssueReporter issueReporter2) {
        Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
        try {
            String string = Version.getVersionString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersionString(...)");
            ShrinkerVersion shrinkerVersion = ShrinkerVersion.Companion.parse(string);
            if (shrinkerVersion == null) {
                return;
            }
            ShrinkerVersion versionInClasspath = shrinkerVersion;
            ShrinkerVersion shrinkerVersion2 = ShrinkerVersion.Companion.parse("8.6.27");
            if (shrinkerVersion2 == null) {
                return;
            }
            ShrinkerVersion versionAgpWasShippedWith = shrinkerVersion2;
            if (versionInClasspath.compareTo(versionAgpWasShippedWith) < 0) {
                throw new R8VersionCheckException(versionAgpWasShippedWith, versionInClasspath);
            }
        }
        catch (NoSuchMethodError e) {
            throw new R8VersionCheckException(null, null, 3, null);
        }
        catch (R8VersionCheckException e) {
            issueReporter2.reportWarning(IssueReporter.Type.GENERIC, (Exception)e);
        }
    }
}

