/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.services;

import com.android.Version;
import com.android.build.gradle.internal.services.CrossClassloaderInvocationHandler;
import com.android.build.gradle.internal.services.CrossClassloaderObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.services.BuildServiceSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001a)\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\rH\u0002\u00a2\u0006\u0002\u0010\u000e\u001a)\u0010\u000f\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\t0\rH\u0002\u00a2\u0006\u0002\u0010\u000e\u001a3\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\u0010\b\u0000\u0010\u0013\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u00150\u0014\"\b\b\u0001\u0010\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0086\b\u001a<\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\u000e\b\u0000\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00150\u0014\"\b\b\u0001\u0010\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00130\r\u001a\u0012\u0010\u001a\u001a\u00020\u00012\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"UNKNOWN_VERSION", "", "perClassLoaderConstant", "checkSameAgpVersion", "", "classLoader1", "Ljava/lang/ClassLoader;", "classLoader2", "copyObject", "T", "objectFromAnotherClassloader", "", "targetType", "Ljava/lang/Class;", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;", "createProxy", "targetInterface", "getBuildService", "Lorg/gradle/api/provider/Provider;", "ServiceT", "Lorg/gradle/api/services/BuildService;", "ParamsT", "Lorg/gradle/api/services/BuildServiceParameters;", "buildServiceRegistry", "Lorg/gradle/api/services/BuildServiceRegistry;", "buildServiceClass", "getBuildServiceName", "type", "gradle-core"})
public final class BuildServicesKt {
    @NotNull
    private static final String perClassLoaderConstant;
    @NotNull
    private static final String UNKNOWN_VERSION = "UNKNOWN_VERSION";

    @NotNull
    public static final <ServiceT extends BuildService<ParamsT>, ParamsT extends BuildServiceParameters> Provider<ServiceT> getBuildService(@NotNull BuildServiceRegistry buildServiceRegistry, @NotNull Class<ServiceT> buildServiceClass) {
        Intrinsics.checkNotNullParameter((Object)buildServiceRegistry, (String)"buildServiceRegistry");
        Intrinsics.checkNotNullParameter(buildServiceClass, (String)"buildServiceClass");
        String serviceName = BuildServicesKt.getBuildServiceName(buildServiceClass);
        Provider provider2 = buildServiceRegistry.registerIfAbsent(serviceName, buildServiceClass, new Action(serviceName){
            final /* synthetic */ String $serviceName;
            {
                this.$serviceName = $serviceName;
            }

            public final void execute(BuildServiceSpec<ParamsT> it) {
                throw new IllegalStateException("Service " + this.$serviceName + " is not registered.");
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"registerIfAbsent(...)");
        return provider2;
    }

    public static final /* synthetic */ <ServiceT extends BuildService<ParamsT>, ParamsT extends BuildServiceParameters> Provider<ServiceT> getBuildService(BuildServiceRegistry buildServiceRegistry) {
        Intrinsics.checkNotNullParameter((Object)buildServiceRegistry, (String)"buildServiceRegistry");
        boolean $i$f$getBuildService = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"ServiceT");
        return BuildServicesKt.getBuildService(buildServiceRegistry, BuildService.class);
    }

    @NotNull
    public static final String getBuildServiceName(@NotNull Class<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return type.getName() + "_" + perClassLoaderConstant;
    }

    private static final void checkSameAgpVersion(ClassLoader classLoader1, ClassLoader classLoader2) {
        String version1 = BuildServicesKt.checkSameAgpVersion$getVersion(classLoader1);
        String version2 = BuildServicesKt.checkSameAgpVersion$getVersion(classLoader2);
        if (!(!Intrinsics.areEqual((Object)version1, (Object)UNKNOWN_VERSION) && Intrinsics.areEqual((Object)version1, (Object)version2))) {
            boolean bl = false;
            String string = "Using different versions of the Android Gradle plugin (" + version1 + ", " + version2 + ") in the same build is not allowed.";
            throw new IllegalStateException(string.toString());
        }
    }

    private static final <T> T createProxy(Object objectFromAnotherClassloader, Class<T> targetInterface) {
        Object object;
        InvocationHandler invocationHandler;
        if (objectFromAnotherClassloader instanceof Proxy && (invocationHandler = Proxy.getInvocationHandler(objectFromAnotherClassloader)) instanceof CrossClassloaderInvocationHandler) {
            return BuildServicesKt.createProxy(((CrossClassloaderInvocationHandler)invocationHandler).getTargetObject(), targetInterface);
        }
        if (Intrinsics.areEqual((Object)objectFromAnotherClassloader.getClass().getClassLoader(), (Object)targetInterface.getClassLoader())) {
            object = objectFromAnotherClassloader;
        } else {
            Class[] classArray = new Class[]{targetInterface};
            object = Proxy.newProxyInstance(targetInterface.getClassLoader(), classArray, (InvocationHandler)new CrossClassloaderInvocationHandler(objectFromAnotherClassloader));
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> T copyObject(Object objectFromAnotherClassloader, Class<T> targetType) {
        Object object;
        ByteArrayOutputStream $this$copyObject_u24lambda_u242 = new ByteArrayOutputStream();
        boolean bl = false;
        Closeable closeable = new ObjectOutputStream($this$copyObject_u24lambda_u242);
        Throwable throwable = null;
        try {
            ObjectOutputStream it = (ObjectOutputStream)closeable;
            boolean bl2 = false;
            it.writeObject(objectFromAnotherClassloader);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] serializedObject = $this$copyObject_u24lambda_u242.toByteArray();
        Intrinsics.checkNotNull((Object)serializedObject);
        Closeable closeable2 = new CrossClassloaderObjectInputStream(new ByteArrayInputStream(serializedObject), targetType);
        Throwable throwable3 = null;
        try {
            CrossClassloaderObjectInputStream it = (CrossClassloaderObjectInputStream)closeable2;
            boolean bl3 = false;
            object = it.readObject();
        }
        catch (Throwable throwable4) {
            throwable3 = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
        }
        return (T)object;
    }

    private static final String checkSameAgpVersion$getVersion(ClassLoader classLoader) {
        String string;
        try {
            Object object = classLoader.loadClass(Version.class.getName()).getField("ANDROID_GRADLE_PLUGIN_VERSION").get(null);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            string = (String)object;
        }
        catch (Throwable e) {
            string = UNKNOWN_VERSION;
        }
        return string;
    }

    public static final /* synthetic */ void access$checkSameAgpVersion(ClassLoader classLoader1, ClassLoader classLoader2) {
        BuildServicesKt.checkSameAgpVersion(classLoader1, classLoader2);
    }

    public static final /* synthetic */ Object access$createProxy(Object objectFromAnotherClassloader, Class targetInterface) {
        return BuildServicesKt.createProxy(objectFromAnotherClassloader, targetInterface);
    }

    public static final /* synthetic */ Object access$copyObject(Object objectFromAnotherClassloader, Class targetType) {
        return BuildServicesKt.copyObject(objectFromAnotherClassloader, targetType);
    }

    static {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        perClassLoaderConstant = string;
    }
}

