/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.cxx.configure.SdkSourceProperties;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.utils.cxx.CxxDiagnosticCode;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u00a8\u0006\u0007"}, d2={"computeNdkSymLinkFolder", "Ljava/io/File;", "originalNdkFolder", "cxxVariantFolder", "ndkSymlinkFolder", "trySymlinkNdk", "", "gradle-core"})
public final class NdkSymlinkerKt {
    @Nullable
    public static final File computeNdkSymLinkFolder(@NotNull File originalNdkFolder, @NotNull File cxxVariantFolder, @Nullable File ndkSymlinkFolder) {
        Intrinsics.checkNotNullParameter((Object)originalNdkFolder, (String)"originalNdkFolder");
        Intrinsics.checkNotNullParameter((Object)cxxVariantFolder, (String)"cxxVariantFolder");
        if (ndkSymlinkFolder == null) {
            return null;
        }
        String string = ndkSymlinkFolder.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"$", (boolean)false, (int)2, null)) {
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_SYMLINK_FAILED, "Could not symlink from " + originalNdkFolder + " to request " + ndkSymlinkFolder + " because that path contains '$'", new Object[0]);
            return null;
        }
        if (!originalNdkFolder.isDirectory()) {
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_SYMLINK_FAILED, "Could not symlink from " + originalNdkFolder + " to request " + ndkSymlinkFolder + " because " + originalNdkFolder + " doesn't exist", new Object[0]);
            return null;
        }
        if (!originalNdkFolder.toPath().resolve("source.properties").toFile().isFile()) {
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_SYMLINK_FAILED, "Could not symlink from " + originalNdkFolder + " to request " + ndkSymlinkFolder + " because " + originalNdkFolder + " doesn't have source.properties", new Object[0]);
            return null;
        }
        String version = SdkSourceProperties.Companion.tryReadPackageRevision(originalNdkFolder);
        if (version == null) {
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_SYMLINK_FAILED, "Could not symlink from " + originalNdkFolder + " to request " + ndkSymlinkFolder + " because " + originalNdkFolder + " doesn't have source.properties that looks like NDK", new Object[0]);
            return null;
        }
        Path absoluteNdkSymlinkFolder = cxxVariantFolder.toPath().resolve(ndkSymlinkFolder.getPath()).resolve("ndk").normalize();
        return absoluteNdkSymlinkFolder.resolve(version).toFile();
    }

    public static final boolean trySymlinkNdk(@NotNull File originalNdkFolder, @NotNull File ndkSymlinkFolder) {
        Intrinsics.checkNotNullParameter((Object)originalNdkFolder, (String)"originalNdkFolder");
        Intrinsics.checkNotNullParameter((Object)ndkSymlinkFolder, (String)"ndkSymlinkFolder");
        if (!originalNdkFolder.isDirectory()) {
            throw new IllegalStateException(("Expected NDK folder at " + originalNdkFolder).toString());
        }
        if (ndkSymlinkFolder.exists()) {
            LoggingEnvironmentKt.infoln("Symlink target " + ndkSymlinkFolder + " already existed", new Object[0]);
            return true;
        }
        ndkSymlinkFolder.getParentFile().mkdirs();
        Path originalNdkFolderRealPath = originalNdkFolder.toPath().toRealPath(new LinkOption[0]);
        LoggingEnvironmentKt.lifecycleln("Symlinking NDK folder " + originalNdkFolder + " to " + ndkSymlinkFolder, new Object[0]);
        try {
            File file;
            File it = file = Files.createSymbolicLink(ndkSymlinkFolder.toPath(), originalNdkFolderRealPath, new FileAttribute[0]).toFile();
            boolean bl = false;
            LoggingEnvironmentKt.lifecycleln("Symlink successfully created", new Object[0]);
            return true;
        }
        catch (FileAlreadyExistsException e) {
            LoggingEnvironmentKt.infoln("Symlink target " + ndkSymlinkFolder + " already existed", new Object[0]);
            return true;
        }
        catch (IOException e) {
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_SYMLINK_FAILED, "Could not symlink NDK folder " + originalNdkFolder + " to " + ndkSymlinkFolder + " due to exception " + e, new Object[0]);
            return false;
        }
    }
}

