/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profgen;

import com.android.tools.profgen.ClassFileResource;
import com.android.tools.profgen.ClassFileResourceKt;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/profgen/ArchiveClassFileResourceProvider;", "Ljava/io/Closeable;", "archive", "Ljava/nio/file/Path;", "zipFile", "Ljava/util/zip/ZipFile;", "(Ljava/nio/file/Path;Ljava/util/zip/ZipFile;)V", "close", "", "getClassFileResources", "", "Lcom/android/tools/profgen/ClassFileResource;", "profgen"})
public final class ArchiveClassFileResourceProvider
implements Closeable {
    @NotNull
    private final Path archive;
    @Nullable
    private ZipFile zipFile;

    public ArchiveClassFileResourceProvider(@NotNull Path archive, @Nullable ZipFile zipFile) {
        Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
        this.archive = archive;
        this.zipFile = zipFile;
    }

    public /* synthetic */ ArchiveClassFileResourceProvider(Path path, ZipFile zipFile, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            zipFile = null;
        }
        this(path, zipFile);
    }

    @NotNull
    public final Collection<ClassFileResource> getClassFileResources() {
        List classFileResources = new ArrayList();
        ZipFile zipFile = this.zipFile;
        if (zipFile == null) {
            ZipFile zipFile2;
            ZipFile it = zipFile2 = new ZipFile(this.archive.toFile(), StandardCharsets.UTF_8);
            boolean bl = false;
            this.zipFile = it;
            zipFile = zipFile2;
        }
        ZipFile zipFile3 = zipFile;
        Enumeration<? extends ZipEntry> zipEntries = zipFile3.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            Intrinsics.checkNotNull((Object)zipEntry);
            if (!ClassFileResourceKt.access$isClassFile(zipEntry)) continue;
            String string = zipEntry.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String classBinaryName = StringsKt.dropLast((String)string, (int)6);
            String classDescriptor = ClassFileResourceKt.getClassDescriptorFromBinaryName(classBinaryName);
            ClassFileResource classFileResource2 = new ClassFileResource(zipFile3, zipEntry, classDescriptor){
                final /* synthetic */ ZipFile $zipFile;
                final /* synthetic */ ZipEntry $zipEntry;
                final /* synthetic */ String $classDescriptor;
                {
                    this.$zipFile = $zipFile;
                    this.$zipEntry = $zipEntry;
                    this.$classDescriptor = $classDescriptor;
                }

                @NotNull
                public InputStream getByteStream() {
                    InputStream inputStream = this.$zipFile.getInputStream(this.$zipEntry);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                    return inputStream;
                }

                @NotNull
                public String getClassDescriptor() {
                    return this.$classDescriptor;
                }
            };
            classFileResources.add(classFileResource2);
        }
        return classFileResources;
    }

    @Override
    public void close() {
        block0: {
            ZipFile zipFile = this.zipFile;
            if (zipFile == null) break block0;
            zipFile.close();
        }
    }
}

