/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.instrumentation;

import com.android.build.api.instrumentation.AsmClassVisitorFactory;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ServiceLoader;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001e\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\b0\u0006\u001a\"\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"ASM_API_VERSION_FOR_INSTRUMENTATION", "", "getJavaMajorVersionOfCompiledClass", "byteCode", "", "getParamsImplClass", "Ljava/lang/Class;", "factoryClass", "Lcom/android/build/api/instrumentation/AsmClassVisitorFactory;", "loadTransformFunction", "Ljava/util/function/BiConsumer;", "Ljava/io/InputStream;", "Ljava/io/OutputStream;", "jarFile", "Ljava/io/File;", "jarFileClassLoader", "Ljava/lang/ClassLoader;", "gradle-core"})
public final class InstrumentationUtilsKt {
    public static final int ASM_API_VERSION_FOR_INSTRUMENTATION = 589824;

    @NotNull
    public static final Class<?> getParamsImplClass(@NotNull Class<? extends AsmClassVisitorFactory<?>> factoryClass) {
        Intrinsics.checkNotNullParameter(factoryClass, (String)"factoryClass");
        Type type = factoryClass.getGenericInterfaces()[0];
        Intrinsics.checkNotNull((Object)type, (String)"null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
        Type type2 = ((ParameterizedType)type).getActualTypeArguments()[0];
        Intrinsics.checkNotNull((Object)type2, (String)"null cannot be cast to non-null type java.lang.Class<*>");
        return (Class)type2;
    }

    @NotNull
    public static final BiConsumer<InputStream, OutputStream> loadTransformFunction(@NotNull File jarFile, @NotNull ClassLoader jarFileClassLoader) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter((Object)jarFileClassLoader, (String)"jarFileClassLoader");
        ServiceLoader<BiConsumer> serviceLoader = ServiceLoader.load(BiConsumer.class, jarFileClassLoader);
        ArrayList functions = Lists.newArrayList(serviceLoader.iterator());
        Intrinsics.checkNotNull((Object)functions);
        if (!(!((Collection)functions).isEmpty())) {
            boolean $i$a$-check-InstrumentationUtilsKt$loadTransformFunction$32 = false;
            String $i$a$-check-InstrumentationUtilsKt$loadTransformFunction$32 = "Transform jar " + jarFile.getAbsolutePath() + " does not provide a BiConsumer to apply";
            throw new IllegalStateException($i$a$-check-InstrumentationUtilsKt$loadTransformFunction$32.toString());
        }
        if (!(functions.size() <= 1)) {
            boolean $i$a$-check-InstrumentationUtilsKt$loadTransformFunction$42 = false;
            String $i$a$-check-InstrumentationUtilsKt$loadTransformFunction$42 = "Transform jar " + jarFile.getAbsolutePath() + " than one BiConsumer to apply";
            throw new IllegalStateException($i$a$-check-InstrumentationUtilsKt$loadTransformFunction$42.toString());
        }
        BiConsumer uncheckedFunction = (BiConsumer)functions.get(0);
        Type[] types = uncheckedFunction.getClass().getGenericInterfaces();
        Intrinsics.checkNotNull((Object)types);
        for (Type type : types) {
            if (!(type instanceof ParameterizedType)) continue;
            Type[] args = ((ParameterizedType)type).getActualTypeArguments();
            if (!Intrinsics.areEqual((Object)((ParameterizedType)type).getRawType(), BiConsumer.class) || args.length != 2 || !Intrinsics.areEqual((Object)args[0], InputStream.class) || !Intrinsics.areEqual((Object)args[1], OutputStream.class)) continue;
            Intrinsics.checkNotNull((Object)uncheckedFunction, (String)"null cannot be cast to non-null type java.util.function.BiConsumer<java.io.InputStream, java.io.OutputStream>");
            return uncheckedFunction;
        }
        throw new IllegalStateException("Transform jar " + jarFile.getAbsolutePath() + " must provide a BiConsumer<InputStream, OutputStream>");
    }

    public static final int getJavaMajorVersionOfCompiledClass(@NotNull byte[] byteCode) {
        Intrinsics.checkNotNullParameter((Object)byteCode, (String)"byteCode");
        int offset = 6;
        return byteCode[offset] << 8 | byteCode[offset + 1];
    }
}

