/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.logging;

import com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment;
import com.android.build.gradle.internal.cxx.string.StringEncoder;
import com.android.utils.cxx.CxxBugDiagnosticCode;
import com.android.utils.cxx.CxxDiagnosticCode;
import com.google.protobuf.GeneratedMessageV3;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a/\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\t\u001a%\u0010\n\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0000\u00a2\u0006\u0002\u0010\u000b\u001a/\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\u000f\u001a'\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\u0011\u001a'\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\u0011\u001a\u001a\u0010\u0013\u001a\u00020\u00012\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015\u001a/\u0010\u0018\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\u000f\u001a'\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0019"}, d2={"bugln", "", "bugCode", "Lcom/android/utils/cxx/CxxBugDiagnosticCode;", "format", "", "args", "", "", "(Lcom/android/utils/cxx/CxxBugDiagnosticCode;Ljava/lang/String;[Ljava/lang/Object;)V", "checkedFormat", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "errorln", "diagnosticCode", "Lcom/android/utils/cxx/CxxDiagnosticCode;", "(Lcom/android/utils/cxx/CxxDiagnosticCode;Ljava/lang/String;[Ljava/lang/Object;)V", "infoln", "(Ljava/lang/String;[Ljava/lang/Object;)V", "lifecycleln", "logStructured", "message", "Lkotlin/Function1;", "Lcom/android/build/gradle/internal/cxx/string/StringEncoder;", "Lcom/google/protobuf/GeneratedMessageV3;", "warnln", "gradle-core"})
public final class LoggingEnvironmentKt {
    public static final void bugln(@NotNull CxxBugDiagnosticCode bugCode, @NotNull String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)bugCode, (String)"bugCode");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ThreadLoggingEnvironment.Companion.reportFormattedBugToCurrentLogger(LoggingEnvironmentKt.checkedFormat(format, args), bugCode);
    }

    public static final void errorln(@NotNull CxxDiagnosticCode diagnosticCode, @NotNull String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)diagnosticCode, (String)"diagnosticCode");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ThreadLoggingEnvironment.Companion.reportFormattedErrorToCurrentLogger(LoggingEnvironmentKt.checkedFormat(format, args), diagnosticCode);
    }

    public static final void warnln(@NotNull String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ThreadLoggingEnvironment.Companion.reportFormattedWarningToCurrentLogger(LoggingEnvironmentKt.checkedFormat(format, args), null);
    }

    public static final void warnln(@NotNull CxxDiagnosticCode diagnosticCode, @NotNull String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)diagnosticCode, (String)"diagnosticCode");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ThreadLoggingEnvironment.Companion.reportFormattedWarningToCurrentLogger(LoggingEnvironmentKt.checkedFormat(format, args), diagnosticCode);
    }

    public static final void lifecycleln(@NotNull String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ThreadLoggingEnvironment.Companion.reportFormattedLifecycleToCurrentLogger(LoggingEnvironmentKt.checkedFormat(format, args));
    }

    public static final void infoln(@NotNull String format, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ThreadLoggingEnvironment.Companion.reportFormattedInfoToCurrentLogger(LoggingEnvironmentKt.checkedFormat(format, args));
    }

    public static final void logStructured(@NotNull Function1<? super StringEncoder, ? extends GeneratedMessageV3> message2) {
        Intrinsics.checkNotNullParameter(message2, (String)"message");
        ThreadLoggingEnvironment.Companion.logStructuredMessageToCurrentLogger(message2);
    }

    @NotNull
    public static final String checkedFormat(@NotNull String format, @NotNull Object[] args) {
        String string;
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (args.length == 0) {
            return format;
        }
        try {
            Object[] objectArray = Arrays.copyOf(args, args.length);
            String string2 = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            string = string2;
        }
        catch (Throwable e) {
            String string3 = e.getMessage();
            int n = args.length;
            String string4 = ArraysKt.joinToString$default((Object[])args, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            StackTraceElement[] stackTraceElementArray = e.getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            string = StringsKt.trimIndent((String)("\n        " + string3 + "\n        format = " + format + "\n        args[" + n + "] = " + string4 + "\n        stacktrace = " + ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)));
        }
        return string;
    }
}

