/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.settings;

import com.android.build.gradle.internal.cxx.settings.SettingsEnvironment;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0003JF\u0010\u000e\u001a\u00020\u000f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00112 \b\u0002\u0010\u0012\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0013\u0012\u0004\u0012\u00020\u00140\nH\u0002J\"\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u0002R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\t\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/cxx/settings/SettingsEnvironmentNameResolver;", "", "environments", "", "Lcom/android/build/gradle/internal/cxx/settings/SettingsEnvironment;", "(Ljava/util/List;)V", "environmentMap", "", "", "lookupTables", "", "resolve", "qualifiedName", "environmentNames", "toLookup", "", "excludeEnvironmentNames", "", "matches", "Lkotlin/Pair;", "Lcom/android/build/gradle/internal/cxx/settings/SettingsEnvironmentNameResolver$Match;", "toLookupTable", "Match", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nSettingsEnvironmentNameResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsEnvironmentNameResolver.kt\ncom/android/build/gradle/internal/cxx/settings/SettingsEnvironmentNameResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,146:1\n1477#2:147\n1502#2,3:148\n1505#2,3:158\n372#3,7:151\n*S KotlinDebug\n*F\n+ 1 SettingsEnvironmentNameResolver.kt\ncom/android/build/gradle/internal/cxx/settings/SettingsEnvironmentNameResolver\n*L\n72#1:147\n72#1:148,3\n72#1:158,3\n72#1:151,7\n*E\n"})
public final class SettingsEnvironmentNameResolver {
    @NotNull
    private final Map<List<String>, Map<String, String>> lookupTables;
    @NotNull
    private final Map<String, List<SettingsEnvironment>> environmentMap;

    /*
     * WARNING - void declaration
     */
    public SettingsEnvironmentNameResolver(@NotNull List<SettingsEnvironment> environments) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Intrinsics.checkNotNullParameter(environments, (String)"environments");
        this.lookupTables = new LinkedHashMap();
        Iterable iterable = environments;
        SettingsEnvironmentNameResolver settingsEnvironmentNameResolver = this;
        boolean $i$f$groupBy = false;
        void var4_5 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            SettingsEnvironment env = (SettingsEnvironment)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = env.getEnvironment();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        settingsEnvironmentNameResolver.environmentMap = destination$iv$iv;
    }

    private final void toLookup(List<String> environmentNames, Set<String> excludeEnvironmentNames, Map<Pair<String, String>, Match> matches) {
        for (String environmentName : environmentNames) {
            if (!excludeEnvironmentNames.add(environmentName)) continue;
            List list = this.environmentMap.get(environmentName);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            for (SettingsEnvironment environment : list) {
                Integer n = environment.getGroupPriority();
                int currentGroupPriority = n != null ? n : 0;
                for (Map.Entry<String, String> entry2 : environment.getProperties().entrySet()) {
                    String name = entry2.getKey();
                    String value = entry2.getValue();
                    Pair fullname = TuplesKt.to((Object)environment.getNamespace(), (Object)name);
                    Match prior = matches.get(fullname);
                    if (prior != null && currentGroupPriority <= prior.getGroupPriority()) continue;
                    matches.put((Pair<String, String>)fullname, new Match(currentGroupPriority, value));
                }
                this.toLookup(environment.getInheritEnvironments(), excludeEnvironmentNames, matches);
            }
        }
    }

    static /* synthetic */ void toLookup$default(SettingsEnvironmentNameResolver settingsEnvironmentNameResolver, List list, Set set, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = new LinkedHashMap();
        }
        settingsEnvironmentNameResolver.toLookup(list, set, map);
    }

    private final Map<String, String> toLookupTable(List<String> environmentNames) {
        Map matches = new LinkedHashMap();
        this.toLookup(environmentNames, new LinkedHashSet(), matches);
        Map result2 = new LinkedHashMap();
        for (Map.Entry entry2 : matches.entrySet()) {
            Pair key = (Pair)entry2.getKey();
            Match match2 = (Match)entry2.getValue();
            String environment = (String)key.component1();
            String name = (String)key.component2();
            String qualified = environment + "." + name;
            result2.put(qualified, match2.getPropertyValue());
            if (!Intrinsics.areEqual((Object)environment, (Object)"env")) continue;
            result2.put(name, match2.getPropertyValue());
        }
        return result2;
    }

    @Nullable
    public final String resolve(@NotNull String qualifiedName, @NotNull List<String> environmentNames) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter(environmentNames, (String)"environmentNames");
        return this.lookupTables.computeIfAbsent(environmentNames, new Function(this, environmentNames){
            final /* synthetic */ SettingsEnvironmentNameResolver this$0;
            final /* synthetic */ List<String> $environmentNames;
            {
                this.this$0 = $receiver;
                this.$environmentNames = $environmentNames;
            }

            @NotNull
            public final Map<String, String> apply(@NotNull List<String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return SettingsEnvironmentNameResolver.access$toLookupTable(this.this$0, this.$environmentNames);
            }
        }).get(qualifiedName);
    }

    public static final /* synthetic */ Map access$toLookupTable(SettingsEnvironmentNameResolver $this, List environmentNames) {
        return $this.toLookupTable(environmentNames);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/internal/cxx/settings/SettingsEnvironmentNameResolver$Match;", "", "groupPriority", "", "propertyValue", "", "(ILjava/lang/String;)V", "getGroupPriority", "()I", "getPropertyValue", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "gradle-core"})
    private static final class Match {
        private final int groupPriority;
        @NotNull
        private final String propertyValue;

        public Match(int groupPriority, @NotNull String propertyValue) {
            Intrinsics.checkNotNullParameter((Object)propertyValue, (String)"propertyValue");
            this.groupPriority = groupPriority;
            this.propertyValue = propertyValue;
        }

        public final int getGroupPriority() {
            return this.groupPriority;
        }

        @NotNull
        public final String getPropertyValue() {
            return this.propertyValue;
        }

        public final int component1() {
            return this.groupPriority;
        }

        @NotNull
        public final String component2() {
            return this.propertyValue;
        }

        @NotNull
        public final Match copy(int groupPriority, @NotNull String propertyValue) {
            Intrinsics.checkNotNullParameter((Object)propertyValue, (String)"propertyValue");
            return new Match(groupPriority, propertyValue);
        }

        public static /* synthetic */ Match copy$default(Match match2, int n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = match2.groupPriority;
            }
            if ((n2 & 2) != 0) {
                string = match2.propertyValue;
            }
            return match2.copy(n, string);
        }

        @NotNull
        public String toString() {
            return "Match(groupPriority=" + this.groupPriority + ", propertyValue=" + this.propertyValue + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.groupPriority);
            result2 = result2 * 31 + this.propertyValue.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Match)) {
                return false;
            }
            Match match2 = (Match)other;
            if (this.groupPriority != match2.groupPriority) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.propertyValue, (Object)match2.propertyValue);
        }
    }
}

