/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.json;

import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.PassThroughPrefixingLoggingEnvironment;
import com.android.utils.cxx.CxxDiagnosticCode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a.\u0010\u0006\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a8\u0006\f"}, d2={"checkCanonicalize", "", "location", "", "file", "Ljava/io/File;", "lint", "Lcom/android/build/gradle/internal/cxx/json/NativeBuildConfigValueMini;", "json", "defaultAbis", "", "supportedAbis", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nLint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lint.kt\ncom/android/build/gradle/internal/cxx/json/LintKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1603#2,9:137\n1855#2:146\n1856#2:148\n1612#2:149\n766#2:150\n857#2,2:151\n1#3:147\n1#3:153\n*S KotlinDebug\n*F\n+ 1 Lint.kt\ncom/android/build/gradle/internal/cxx/json/LintKt\n*L\n104#1:137,9\n104#1:146\n104#1:148\n104#1:149\n105#1:150\n105#1:151,2\n104#1:147\n*E\n"})
public final class LintKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void lint(@NotNull NativeBuildConfigValueMini $this$lint, @NotNull File json, @NotNull List<String> defaultAbis2, @NotNull List<String> supportedAbis2) {
        Intrinsics.checkNotNullParameter((Object)$this$lint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(defaultAbis2, (String)"defaultAbis");
        Intrinsics.checkNotNullParameter(supportedAbis2, (String)"supportedAbis");
        AutoCloseable autoCloseable = new PassThroughPrefixingLoggingEnvironment(json, null, false, 6, null);
        Throwable throwable = null;
        try {
            void $this$filterTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Object library;
            boolean bl;
            PassThroughPrefixingLoggingEnvironment logger = (PassThroughPrefixingLoggingEnvironment)autoCloseable;
            boolean bl2 = false;
            for (File file : $this$lint.buildFiles) {
                if (file.isFile()) continue;
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.BUILD_FILE_DID_NOT_EXIST, "expected buildFiles file '" + file + "' to exist", new Object[0]);
            }
            List<String> list = $this$lint.buildTargetsCommandComponents;
            List<String> buildCommand = list == null ? CollectionsKt.emptyList() : list;
            boolean bl3 = bl = !((Collection)buildCommand).isEmpty();
            if (bl && !new File(buildCommand.get(0)).isFile()) {
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.BUILD_TARGET_COMMAND_COMPONENTS_DID_NOT_EXIST, "expected buildTargetsCommandComponents command '" + buildCommand.get(0) + "' to exist", new Object[0]);
            } else if (bl && !Intrinsics.areEqual((Object)CollectionsKt.last(buildCommand), (Object)"{LIST_OF_TARGETS_TO_BUILD}")) {
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.BUILD_TARGET_COMMAND_COMPONENTS_DID_NOT_EXIST, "expected buildTargetsCommandComponents command '" + CollectionsKt.joinToString$default((Iterable)buildCommand, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "' to have {LIST_OF_TARGETS_TO_BUILD} at the end", new Object[0]);
            }
            Map<String, NativeLibraryValueMini> map = $this$lint.libraries;
            Intrinsics.checkNotNullExpressionValue(map, (String)"libraries");
            for (Map.Entry<String, NativeLibraryValueMini> entry2 : map.entrySet()) {
                String string;
                List<String> buildCommandComponents;
                String name = entry2.getKey();
                library = entry2.getValue();
                List<String> list2 = ((NativeLibraryValueMini)library).buildCommandComponents;
                List<String> list3 = buildCommandComponents = list2 == null ? CollectionsKt.emptyList() : list2;
                if (buildCommandComponents.isEmpty()) {
                    if (!bl) {
                        LoggingEnvironmentKt.errorln(CxxDiagnosticCode.BUILD_TARGET_COMMAND_COMPONENTS_DID_NOT_EXIST, "expected buildTargetsCommandComponents or " + name + ".buildCommandComponents to exist", new Object[0]);
                    }
                } else if (!new File(buildCommandComponents.get(0)).isFile()) {
                    LoggingEnvironmentKt.errorln(CxxDiagnosticCode.BUILD_TARGET_COMMAND_COMPONENTS_COMMAND_DID_NOT_EXIST, "expected " + name + ".buildCommandComponents command '" + buildCommandComponents.get(0) + "' to exist", new Object[0]);
                }
                if ((string = ((NativeLibraryValueMini)library).artifactName) == null) {
                    string = "";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"library.artifactName ?: \"\"");
                String artifactName = string;
                if (((CharSequence)artifactName).length() == 0) {
                    LoggingEnvironmentKt.errorln(CxxDiagnosticCode.LIBRARY_ARTIFACT_NAME_DID_NOT_EXIST, "expected " + name + ".artifactName to exist", new Object[0]);
                }
                for (File runtimeFile : ((NativeLibraryValueMini)library).runtimeFiles) {
                    String string2 = name + ".runtimeFiles";
                    Intrinsics.checkNotNullExpressionValue((Object)runtimeFile, (String)"runtimeFile");
                    LintKt.checkCanonicalize(string2, runtimeFile);
                }
                String string3 = ((NativeLibraryValueMini)library).abi;
                if (string3 == null) {
                    string3 = "";
                }
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"library.abi ?: \"\"");
                String abiName = string3;
                if (((CharSequence)abiName).length() == 0) {
                    LoggingEnvironmentKt.errorln(CxxDiagnosticCode.LIBRARY_ABI_NAME_DID_NOT_EXIST, "expected " + name + ".abi to exist", new Object[0]);
                    continue;
                }
                if (supportedAbis2.contains(abiName)) continue;
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.LIBRARY_ABI_NAME_IS_INVALID, name + ".abi '" + abiName + "' is invalid. Valid values are '" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)defaultAbis2), null, null, null, (int)0, null, null, (int)63, null) + "'", new Object[0]);
            }
            Iterable iterable = $this$lint.libraries.values();
            boolean $i$f$mapNotNull = false;
            library = iterable;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl32 = false;
                NativeLibraryValueMini it = (NativeLibraryValueMini)element$iv$iv;
                boolean bl4 = false;
                if (String.valueOf(it.abi) == null) continue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = iterable2;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (File element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)((Object)element$iv$iv);
                boolean bl6 = false;
                if (!supportedAbis2.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List allAbis = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            if (allAbis.size() > 1) {
                LoggingEnvironmentKt.errorln(CxxDiagnosticCode.LIBRARY_HAD_MULTIPLE_ABIS, "unexpected mismatched library ABIs: " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)allAbis), null, null, null, (int)0, null, null, (int)63, null), new Object[0]);
            }
            if (!((Collection)logger.getErrors()).isEmpty()) {
                throw new IllegalStateException("Failed C/C++ configuration.".toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final void checkCanonicalize(String location2, File file) {
        try {
            file.getCanonicalFile();
        }
        catch (IOException e) {
            Object object;
            block5: {
                block4: {
                    object = e.getCause();
                    if (object == null) break block4;
                    Throwable it = object;
                    boolean bl = false;
                    String string = " (" + it + ")";
                    object = string;
                    if (string != null) break block5;
                }
                object = "";
            }
            Object cause = object;
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.COULD_NOT_CANONICALIZE_PATH, "Could not canonicalize '" + file + "' in " + location2 + " due to " + e.getClass().getSimpleName() + (String)cause, new Object[0]);
        }
    }
}

