/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.AvdManager;
import com.android.build.gradle.internal.AvdSnapshotHandler;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.ManagedVirtualDeviceLockManager;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.services.AndroidLocationsBuildService;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.build.gradle.internal.testing.AdbHelper;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.prefs.AndroidLocationsProvider;
import com.android.repository.Revision;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.utils.ILogger;
import com.android.utils.PathUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002'(B\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J2\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0019J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0019J\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\u0006\u0010$\u001a\u00020 J\u0016\u0010%\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0019R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/android/build/gradle/internal/AvdComponentsBuildService;", "Lorg/gradle/api/services/BuildService;", "Lcom/android/build/gradle/internal/AvdComponentsBuildService$Parameters;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/api/provider/ProviderFactory;)V", "avdFolder", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "getAvdFolder", "()Lorg/gradle/api/provider/Provider;", "avdManager", "Lcom/android/build/gradle/internal/AvdManager;", "emulatorDirectory", "getEmulatorDirectory", "lockManager", "Lcom/android/build/gradle/internal/ManagedVirtualDeviceLockManager;", "getLockManager", "()Lcom/android/build/gradle/internal/ManagedVirtualDeviceLockManager;", "logger", "Lcom/android/utils/ILogger;", "allAvds", "", "", "avdProvider", "imageProvider", "imageHash", "deviceName", "hardwareProfile", "closeOpenEmulators", "", "idPrefix", "deleteAvds", "avds", "deleteLegacyGradleManagedDeviceAvdDirectory", "ensureLoadableSnapshot", "emulatorGpuMode", "Parameters", "RegistrationAction", "gradle-core"})
public abstract class AvdComponentsBuildService
implements BuildService<Parameters> {
    @NotNull
    private final ObjectFactory objectFactory;
    @NotNull
    private final ProviderFactory providerFactory;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final Provider<AvdManager> avdManager;
    @NotNull
    private final ManagedVirtualDeviceLockManager lockManager;
    @NotNull
    private final Provider<Directory> avdFolder;
    @NotNull
    private final Provider<Directory> emulatorDirectory;

    @Inject
    public AvdComponentsBuildService(@NotNull ObjectFactory objectFactory, @NotNull ProviderFactory providerFactory) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        this.objectFactory = objectFactory;
        this.providerFactory = providerFactory;
        LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(AvdComponentsBuildService.class);
        Intrinsics.checkNotNullExpressionValue((Object)loggerWrapper, (String)"getLogger(AvdComponentsBuildService::class.java)");
        this.logger = loggerWrapper;
        Provider provider2 = this.providerFactory.provider(new Callable(this){
            final /* synthetic */ AvdComponentsBuildService this$0;
            {
                this.this$0 = $receiver;
            }

            public final AvdManager call() {
                AndroidLocationsBuildService locationsService = (AndroidLocationsBuildService)((Parameters)this.this$0.getParameters()).getAndroidLocationsService().get();
                Provider versionedSdkLoader2 = ((Parameters)this.this$0.getParameters()).getSdkService().map(new Transformer(this.this$0){
                    final /* synthetic */ AvdComponentsBuildService this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final SdkComponentsBuildService.VersionedSdkLoader transform(SdkComponentsBuildService it) {
                        return it.sdkLoader((Provider<String>)((Provider)((Parameters)this.this$0.getParameters()).getCompileSdkVersion()), (Provider<Revision>)((Provider)((Parameters)this.this$0.getParameters()).getBuildToolsRevision()));
                    }
                });
                AdbHelper adbHelper2 = (AdbHelper)((SdkComponentsBuildService.VersionedSdkLoader)versionedSdkLoader2.get()).getAdbHelper().get();
                Long snapshotTimeoutSecs = ((Parameters)this.this$0.getParameters()).getDeviceSetupTimeoutMinutes().isPresent() ? Long.valueOf(((Number)((Parameters)this.this$0.getParameters()).getDeviceSetupTimeoutMinutes().get()).longValue() * 60L) : null;
                File file = ((Directory)((Parameters)this.this$0.getParameters()).getAvdLocation().get()).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"parameters.avdLocation.get().asFile");
                Intrinsics.checkNotNullExpressionValue((Object)versionedSdkLoader2, (String)"versionedSdkLoader");
                AndroidSdkHandler androidSdkHandler = AndroidSdkHandler.getInstance((AndroidLocationsProvider)locationsService, (Path)((Directory)((SdkComponentsBuildService)((Parameters)this.this$0.getParameters()).getSdkService().get()).getSdkDirectoryProvider().get()).getAsFile().toPath());
                Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"getInstance(\n           \u2026le.toPath()\n            )");
                Intrinsics.checkNotNullExpressionValue((Object)locationsService, (String)"locationsService");
                AndroidLocationsProvider androidLocationsProvider = locationsService;
                Object object = ((Parameters)this.this$0.getParameters()).getShowEmulatorKernelLogging().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.showEmulatorKernelLogging.get()");
                boolean bl = (Boolean)object;
                Intrinsics.checkNotNullExpressionValue((Object)adbHelper2, (String)"adbHelper");
                AvdSnapshotHandler avdSnapshotHandler = new AvdSnapshotHandler(bl, snapshotTimeoutSecs, adbHelper2, 0L, null, null, 56, null);
                AndroidLocationsProvider androidLocationsProvider2 = locationsService;
                Object object2 = ((Parameters)this.this$0.getParameters()).getMaxConcurrentDevices().getOrElse((Object)4);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.maxConcurrent\u2026tOrElse(DEFAULT_MAX_GMDS)");
                return new AvdManager(file, (Provider<SdkComponentsBuildService.VersionedSdkLoader>)versionedSdkLoader2, androidSdkHandler, androidLocationsProvider, avdSnapshotHandler, new ManagedVirtualDeviceLockManager(androidLocationsProvider2, ((Number)object2).intValue(), 0L, 4, null), adbHelper2);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"providerFactory.provider\u2026adbHelper\n        )\n    }");
        this.avdManager = provider2;
        this.lockManager = ((AvdManager)this.avdManager.get()).getDeviceLockManager();
        this.avdFolder = (Provider)((Parameters)this.getParameters()).getAvdLocation();
        Provider provider3 = ((Parameters)this.getParameters()).getSdkService().flatMap(new Transformer(this){
            final /* synthetic */ AvdComponentsBuildService this$0;
            {
                this.this$0 = $receiver;
            }

            public final Provider<? extends Directory> transform(SdkComponentsBuildService it) {
                return it.sdkLoader((Provider<String>)((Provider)((Parameters)this.this$0.getParameters()).getCompileSdkVersion()), (Provider<Revision>)((Provider)((Parameters)this.this$0.getParameters()).getBuildToolsRevision())).getEmulatorDirectoryProvider();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"parameters.sdkService.fl\u2026rectoryProvider\n        }");
        this.emulatorDirectory = provider3;
    }

    @NotNull
    public final ManagedVirtualDeviceLockManager getLockManager() {
        return this.lockManager;
    }

    @NotNull
    public final Provider<Directory> getAvdFolder() {
        return this.avdFolder;
    }

    @NotNull
    public final Provider<Directory> getEmulatorDirectory() {
        return this.emulatorDirectory;
    }

    @NotNull
    public final List<String> allAvds() {
        return ((AvdManager)this.avdManager.get()).allAvds();
    }

    @NotNull
    public final List<String> deleteAvds(@NotNull List<String> avds) {
        Intrinsics.checkNotNullParameter(avds, (String)"avds");
        return ((AvdManager)this.avdManager.get()).deleteAvds(avds);
    }

    public final void deleteLegacyGradleManagedDeviceAvdDirectory() {
        PathUtils.deleteRecursivelyIfExists((Path)((AndroidLocationsBuildService)((Parameters)this.getParameters()).getAndroidLocationsService().get()).getPrefsLocation().resolve("gradle").resolve("avd"));
    }

    @NotNull
    public final Provider<Directory> avdProvider(@NotNull Provider<Directory> imageProvider, @NotNull String imageHash, @NotNull String deviceName, @NotNull String hardwareProfile) {
        Intrinsics.checkNotNullParameter(imageProvider, (String)"imageProvider");
        Intrinsics.checkNotNullParameter((Object)imageHash, (String)"imageHash");
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        Intrinsics.checkNotNullParameter((Object)hardwareProfile, (String)"hardwareProfile");
        DirectoryProperty directoryProperty = this.objectFactory.directoryProperty().fileProvider(this.providerFactory.provider(new Callable(this, imageProvider, imageHash, deviceName, hardwareProfile){
            final /* synthetic */ AvdComponentsBuildService this$0;
            final /* synthetic */ Provider<Directory> $imageProvider;
            final /* synthetic */ String $imageHash;
            final /* synthetic */ String $deviceName;
            final /* synthetic */ String $hardwareProfile;
            {
                this.this$0 = $receiver;
                this.$imageProvider = $imageProvider;
                this.$imageHash = $imageHash;
                this.$deviceName = $deviceName;
                this.$hardwareProfile = $hardwareProfile;
            }

            public final File call() {
                return ((AvdManager)AvdComponentsBuildService.access$getAvdManager$p(this.this$0).get()).createOrRetrieveAvd(this.$imageProvider, this.$imageHash, this.$deviceName, this.$hardwareProfile);
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"fun avdProvider(\n       \u2026rdwareProfile)\n        })");
        return (Provider)directoryProperty;
    }

    public final void ensureLoadableSnapshot(@NotNull String deviceName, @NotNull String emulatorGpuMode) {
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        Intrinsics.checkNotNullParameter((Object)emulatorGpuMode, (String)"emulatorGpuMode");
        ((AvdManager)this.avdManager.get()).loadSnapshotIfNeeded(deviceName, emulatorGpuMode);
    }

    public final void closeOpenEmulators(@NotNull String idPrefix) {
        Intrinsics.checkNotNullParameter((Object)idPrefix, (String)"idPrefix");
        ((AvdManager)this.avdManager.get()).closeOpenEmulators(idPrefix);
    }

    public static final /* synthetic */ Provider access$getAvdManager$p(AvdComponentsBuildService $this) {
        return $this.avdManager;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006R\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0006R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0006R\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0006R\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0006\u00a8\u0006\u001c\u00c0\u0006\u0003"}, d2={"Lcom/android/build/gradle/internal/AvdComponentsBuildService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "androidLocationsService", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/services/AndroidLocationsBuildService;", "getAndroidLocationsService", "()Lorg/gradle/api/provider/Property;", "avdLocation", "Lorg/gradle/api/file/DirectoryProperty;", "getAvdLocation", "()Lorg/gradle/api/file/DirectoryProperty;", "buildToolsRevision", "Lcom/android/repository/Revision;", "getBuildToolsRevision", "compileSdkVersion", "", "getCompileSdkVersion", "deviceSetupTimeoutMinutes", "", "getDeviceSetupTimeoutMinutes", "maxConcurrentDevices", "getMaxConcurrentDevices", "sdkService", "Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "getSdkService", "showEmulatorKernelLogging", "", "getShowEmulatorKernelLogging", "gradle-core"})
    public static interface Parameters
    extends BuildServiceParameters {
        @NotNull
        public Property<SdkComponentsBuildService> getSdkService();

        @NotNull
        public Property<String> getCompileSdkVersion();

        @NotNull
        public Property<Revision> getBuildToolsRevision();

        @NotNull
        public Property<AndroidLocationsBuildService> getAndroidLocationsService();

        @NotNull
        public DirectoryProperty getAvdLocation();

        @NotNull
        public Property<Boolean> getShowEmulatorKernelLogging();

        @NotNull
        public Property<Integer> getDeviceSetupTimeoutMinutes();

        @NotNull
        public Property<Integer> getMaxConcurrentDevices();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001BM\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/AvdComponentsBuildService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/AvdComponentsBuildService;", "Lcom/android/build/gradle/internal/AvdComponentsBuildService$Parameters;", "project", "Lorg/gradle/api/Project;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "avdFolderLocation", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "sdkService", "Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "compileSdkVersion", "", "buildToolsRevision", "Lcom/android/repository/Revision;", "(Lorg/gradle/api/Project;Lcom/android/build/gradle/options/ProjectOptions;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;)V", "configure", "", "parameters", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nAvdComponents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvdComponents.kt\ncom/android/build/gradle/internal/AvdComponentsBuildService$RegistrationAction\n+ 2 buildServices.kt\ncom/android/build/gradle/internal/services/BuildServicesKt\n*L\n1#1,208:1\n78#2:209\n78#2:210\n*S KotlinDebug\n*F\n+ 1 AvdComponents.kt\ncom/android/build/gradle/internal/AvdComponentsBuildService$RegistrationAction\n*L\n194#1:209\n195#1:210\n*E\n"})
    public static final class RegistrationAction
    extends ServiceRegistrationAction<AvdComponentsBuildService, Parameters> {
        @NotNull
        private final ProjectOptions projectOptions;
        @NotNull
        private final Provider<Directory> avdFolderLocation;
        @NotNull
        private final Provider<SdkComponentsBuildService> sdkService;
        @NotNull
        private final Provider<String> compileSdkVersion;
        @NotNull
        private final Provider<Revision> buildToolsRevision;

        public RegistrationAction(@NotNull Project project, @NotNull ProjectOptions projectOptions, @NotNull Provider<Directory> avdFolderLocation, @NotNull Provider<SdkComponentsBuildService> sdkService, @NotNull Provider<String> compileSdkVersion2, @NotNull Provider<Revision> buildToolsRevision2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)projectOptions, (String)"projectOptions");
            Intrinsics.checkNotNullParameter(avdFolderLocation, (String)"avdFolderLocation");
            Intrinsics.checkNotNullParameter(sdkService, (String)"sdkService");
            Intrinsics.checkNotNullParameter(compileSdkVersion2, (String)"compileSdkVersion");
            Intrinsics.checkNotNullParameter(buildToolsRevision2, (String)"buildToolsRevision");
            super(project, AvdComponentsBuildService.class, null, null, 12, null);
            this.projectOptions = projectOptions;
            this.avdFolderLocation = avdFolderLocation;
            this.sdkService = sdkService;
            this.compileSdkVersion = compileSdkVersion2;
            this.buildToolsRevision = buildToolsRevision2;
        }

        @Override
        public void configure(@NotNull Parameters parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            parameters.getAvdLocation().set(this.avdFolderLocation);
            parameters.getSdkService().set(this.sdkService);
            parameters.getCompileSdkVersion().set(this.compileSdkVersion);
            parameters.getBuildToolsRevision().set(this.buildToolsRevision);
            Property<SdkComponentsBuildService> property = parameters.getSdkService();
            BuildServiceRegistry buildServiceRegistry = this.getProject().getGradle().getSharedServices();
            Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"project.gradle.sharedServices");
            BuildServiceRegistry buildServiceRegistry$iv = buildServiceRegistry;
            boolean $i$f$getBuildService = false;
            property.set(BuildServicesKt.getBuildService(buildServiceRegistry$iv, SdkComponentsBuildService.class));
            Property<AndroidLocationsBuildService> property2 = parameters.getAndroidLocationsService();
            BuildServiceRegistry buildServiceRegistry2 = this.getProject().getGradle().getSharedServices();
            Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry2, (String)"project.gradle.sharedServices");
            buildServiceRegistry$iv = buildServiceRegistry2;
            $i$f$getBuildService = false;
            property2.set(BuildServicesKt.getBuildService(buildServiceRegistry$iv, AndroidLocationsBuildService.class));
            parameters.getShowEmulatorKernelLogging().set((Object)this.projectOptions.get(BooleanOption.GRADLE_MANAGED_DEVICE_EMULATOR_SHOW_KERNEL_LOGGING));
            parameters.getDeviceSetupTimeoutMinutes().set((Object)this.projectOptions.get(IntegerOption.GRADLE_MANAGED_DEVICE_SETUP_TIMEOUT_MINUTES));
            parameters.getMaxConcurrentDevices().set((Object)this.projectOptions.get(IntegerOption.GRADLE_MANAGED_DEVICE_MAX_CONCURRENT_DEVICES));
        }
    }
}

