/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.testing.AdbHelper;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.testing.utils.ManagedDeviceUtilsKt;
import com.android.utils.FileUtils;
import com.android.utils.GrabProcessOutput;
import com.android.utils.ILogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001/BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u001a\b\u0002\u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0004\u0012\u00020\u000f0\f\u00a2\u0006\u0002\u0010\u0010J8\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u000eJ \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0015H\u0002J6\u0010\"\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u0019J4\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000e2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0014\u0010%\u001a\u00020\u00152\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'J8\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\"\u0010+\u001a\u00020\u001c*\u00020,2\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001c0.H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/android/build/gradle/internal/AvdSnapshotHandler;", "", "showEmulatorKernelLogging", "", "deviceBootAndSnapshotCheckTimeoutSec", "", "adbHelper", "Lcom/android/build/gradle/internal/testing/AdbHelper;", "extraWaitAfterBootCompleteMs", "executor", "Ljava/util/concurrent/Executor;", "processFactory", "Lkotlin/Function1;", "", "", "Ljava/lang/ProcessBuilder;", "(ZLjava/lang/Long;Lcom/android/build/gradle/internal/testing/AdbHelper;JLjava/util/concurrent/Executor;Lkotlin/jvm/functions/Function1;)V", "Ljava/lang/Long;", "checkSnapshotLoadable", "avdName", "emulatorExecutable", "Ljava/io/File;", "avdLocation", "emulatorGpuFlag", "logger", "Lcom/android/utils/ILogger;", "snapshotName", "deleteSnapshotForDevice", "", "deviceName", "avdManager", "Lcom/android/sdklib/internal/avd/AvdManager;", "ensureEmulatorVersionRequirement", "emulatorDir", "generateSnapshot", "getEmulatorCommand", "additionalParams", "getEmulatorExecutable", "emulatorDirectoryProvider", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "startEmulatorThenStop", "createSnapshot", "waitUntilTimeout", "Ljava/lang/Process;", "onTimeout", "Lkotlin/Function0;", "EmulatorSnapshotCannotCreatedException", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nAvdSnapshotHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AvdSnapshotHandler.kt\ncom/android/build/gradle/internal/AvdSnapshotHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,460:1\n1#2:461\n37#3,2:462\n*S KotlinDebug\n*F\n+ 1 AvdSnapshotHandler.kt\ncom/android/build/gradle/internal/AvdSnapshotHandler\n*L\n93#1:462,2\n*E\n"})
public final class AvdSnapshotHandler {
    private final boolean showEmulatorKernelLogging;
    @Nullable
    private final Long deviceBootAndSnapshotCheckTimeoutSec;
    @NotNull
    private final AdbHelper adbHelper;
    private final long extraWaitAfterBootCompleteMs;
    @NotNull
    private final Executor executor;
    @NotNull
    private final Function1<List<String>, ProcessBuilder> processFactory;

    public AvdSnapshotHandler(boolean showEmulatorKernelLogging, @Nullable Long deviceBootAndSnapshotCheckTimeoutSec, @NotNull AdbHelper adbHelper2, long extraWaitAfterBootCompleteMs, @NotNull Executor executor2, @NotNull Function1<? super List<String>, ProcessBuilder> processFactory2) {
        Intrinsics.checkNotNullParameter((Object)adbHelper2, (String)"adbHelper");
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        Intrinsics.checkNotNullParameter(processFactory2, (String)"processFactory");
        this.showEmulatorKernelLogging = showEmulatorKernelLogging;
        this.deviceBootAndSnapshotCheckTimeoutSec = deviceBootAndSnapshotCheckTimeoutSec;
        this.adbHelper = adbHelper2;
        this.extraWaitAfterBootCompleteMs = extraWaitAfterBootCompleteMs;
        this.executor = executor2;
        this.processFactory = processFactory2;
    }

    public /* synthetic */ AvdSnapshotHandler(boolean bl, Long l, AdbHelper adbHelper2, long l2, Executor executor2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            l2 = 5000L;
        }
        if ((n & 0x10) != 0) {
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor()");
            executor2 = executorService;
        }
        if ((n & 0x20) != 0) {
            function1 = 1.INSTANCE;
        }
        this(bl, l, adbHelper2, l2, executor2, (Function1<? super List<String>, ProcessBuilder>)function1);
    }

    @NotNull
    public final File getEmulatorExecutable(@NotNull Provider<Directory> emulatorDirectoryProvider2) {
        Intrinsics.checkNotNullParameter(emulatorDirectoryProvider2, (String)"emulatorDirectoryProvider");
        Directory directory2 = (Directory)emulatorDirectoryProvider2.getOrNull();
        File file = directory2 != null ? directory2.getAsFile() : null;
        if (file == null) {
            throw new IllegalStateException("Emulator dir does not exist".toString());
        }
        File emulatorDir = file;
        this.ensureEmulatorVersionRequirement(emulatorDir);
        return FilesKt.resolve((File)emulatorDir, (String)"emulator");
    }

    private final List<String> getEmulatorCommand(String avdName, File emulatorExecutable, String emulatorGpuFlag, List<String> additionalParams) {
        String string;
        SpreadBuilder spreadBuilder = new SpreadBuilder(11);
        spreadBuilder.add((Object)emulatorExecutable.getAbsolutePath());
        spreadBuilder.add((Object)("@" + avdName));
        spreadBuilder.add((Object)"-no-window");
        spreadBuilder.add((Object)"-no-boot-anim");
        spreadBuilder.add((Object)"-no-audio");
        spreadBuilder.add((Object)"-delay-adb");
        String string2 = string = "-verbose";
        SpreadBuilder spreadBuilder2 = spreadBuilder;
        boolean bl = false;
        boolean bl2 = this.showEmulatorKernelLogging;
        spreadBuilder2.add((Object)(bl2 ? string : null));
        String it = string = "-show-kernel";
        spreadBuilder2 = spreadBuilder;
        boolean bl3 = false;
        bl2 = this.showEmulatorKernelLogging;
        spreadBuilder2.add((Object)(bl2 ? string : null));
        spreadBuilder.add((Object)"-gpu");
        spreadBuilder.add((Object)emulatorGpuFlag);
        Collection $this$toTypedArray$iv = additionalParams;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        return CollectionsKt.listOfNotNull((Object[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
    }

    public final boolean checkSnapshotLoadable(@NotNull String avdName, @NotNull File emulatorExecutable, @NotNull File avdLocation, @NotNull String emulatorGpuFlag, @NotNull ILogger logger, @NotNull String snapshotName) {
        Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
        Intrinsics.checkNotNullParameter((Object)emulatorExecutable, (String)"emulatorExecutable");
        Intrinsics.checkNotNullParameter((Object)avdLocation, (String)"avdLocation");
        Intrinsics.checkNotNullParameter((Object)emulatorGpuFlag, (String)"emulatorGpuFlag");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)snapshotName, (String)"snapshotName");
        logger.info("Checking " + snapshotName + " on device " + avdName + " is loadable.", new Object[0]);
        Object object = new String[]{"-read-only", "-no-snapshot-save", "-check-snapshot-loadable", snapshotName};
        ProcessBuilder processBuilder2 = (ProcessBuilder)this.processFactory.invoke(this.getEmulatorCommand(avdName, emulatorExecutable, emulatorGpuFlag, CollectionsKt.listOf((Object[])object)));
        Map<String, String> map = processBuilder2.environment();
        Intrinsics.checkNotNullExpressionValue(map, (String)"processBuilder.environment()");
        object = map;
        String string = "ANDROID_AVD_HOME";
        String string2 = avdLocation.getAbsolutePath();
        object.put(string, string2);
        Process process2 = processBuilder2.start();
        Ref.ObjectRef success2 = new Ref.ObjectRef();
        success2.element = new AtomicBoolean(false);
        Ref.BooleanRef timeout = new Ref.BooleanRef();
        Ref.ObjectRef outputProcessed = new Ref.ObjectRef();
        outputProcessed.element = new CountDownLatch(1);
        try {
            GrabProcessOutput.grabProcessOutput((Process)process2, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.ASYNC, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput((Ref.ObjectRef<CountDownLatch>)outputProcessed, logger, (Ref.ObjectRef<AtomicBoolean>)success2){
                final /* synthetic */ Ref.ObjectRef<CountDownLatch> $outputProcessed;
                final /* synthetic */ ILogger $logger;
                final /* synthetic */ Ref.ObjectRef<AtomicBoolean> $success;
                {
                    this.$outputProcessed = $outputProcessed;
                    this.$logger = $logger;
                    this.$success = $success;
                }

                public void out(@Nullable String line) {
                    if (line == null) {
                        ((CountDownLatch)this.$outputProcessed.element).countDown();
                        return;
                    }
                    this.$logger.verbose(line, new Object[0]);
                    if (StringsKt.contains$default((CharSequence)line, (CharSequence)"Loadable", (boolean)false, (int)2, null)) {
                        ((AtomicBoolean)this.$success.element).set(true);
                        ((CountDownLatch)this.$outputProcessed.element).countDown();
                    } else if (StringsKt.contains$default((CharSequence)line, (CharSequence)"Not loadable", (boolean)false, (int)2, null)) {
                        ((CountDownLatch)this.$outputProcessed.element).countDown();
                    }
                }

                public void err(@Nullable String line) {
                }
            });
        }
        catch (Exception e) {
            process2.destroy();
            throw new RuntimeException(e);
        }
        Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"process");
        this.waitUntilTimeout(process2, logger, (Function0<Unit>)((Function0)new Function0<Unit>(timeout, logger, snapshotName, avdName){
            final /* synthetic */ Ref.BooleanRef $timeout;
            final /* synthetic */ ILogger $logger;
            final /* synthetic */ String $snapshotName;
            final /* synthetic */ String $avdName;
            {
                this.$timeout = $timeout;
                this.$logger = $logger;
                this.$snapshotName = $snapshotName;
                this.$avdName = $avdName;
                super(0);
            }

            public final void invoke() {
                this.$timeout.element = true;
                this.$logger.warning("Timed out trying to check " + this.$snapshotName + " for " + this.$avdName + " is loadable.", new Object[0]);
            }
        }));
        if (!timeout.element) {
            Long l = this.deviceBootAndSnapshotCheckTimeoutSec;
            long timeoutSec = l != null ? l : 600L;
            ((CountDownLatch)outputProcessed.element).await(timeoutSec, TimeUnit.SECONDS);
        }
        return ((AtomicBoolean)success2.element).get();
    }

    public static /* synthetic */ boolean checkSnapshotLoadable$default(AvdSnapshotHandler avdSnapshotHandler, String string, File file, File file2, String string2, ILogger iLogger, String string3, int n, Object object) {
        if ((n & 0x20) != 0) {
            string3 = "default_boot";
        }
        return avdSnapshotHandler.checkSnapshotLoadable(string, file, file2, string2, iLogger, string3);
    }

    private final void waitUntilTimeout(Process $this$waitUntilTimeout, ILogger logger, Function0<Unit> onTimeout) {
        long timeoutSec;
        Long l = this.deviceBootAndSnapshotCheckTimeoutSec;
        long l2 = timeoutSec = l != null ? l : 600L;
        if (timeoutSec > 0L) {
            logger.verbose("Waiting for a process to complete (timeout " + timeoutSec + " seconds)", new Object[0]);
            if (!$this$waitUntilTimeout.waitFor(timeoutSec, TimeUnit.SECONDS)) {
                onTimeout.invoke();
            }
        } else {
            logger.verbose("Waiting for a process to complete (no timeout)", new Object[0]);
            $this$waitUntilTimeout.waitFor();
        }
    }

    public final void generateSnapshot(@NotNull String avdName, @NotNull File emulatorExecutable, @NotNull File avdLocation, @NotNull String emulatorGpuFlag, @NotNull AvdManager avdManager2, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)avdName, (String)"avdName");
        Intrinsics.checkNotNullParameter((Object)emulatorExecutable, (String)"emulatorExecutable");
        Intrinsics.checkNotNullParameter((Object)avdLocation, (String)"avdLocation");
        Intrinsics.checkNotNullParameter((Object)emulatorGpuFlag, (String)"emulatorGpuFlag");
        Intrinsics.checkNotNullParameter((Object)avdManager2, (String)"avdManager");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        logger.verbose("Creating snapshot for " + avdName, new Object[0]);
        int maxRetryAttempt = 5;
        EmulatorSnapshotCannotCreatedException lastException = null;
        int n = 0;
        while (n < maxRetryAttempt) {
            int attempt = n++;
            boolean bl = false;
            try {
                logger.verbose("Starting Emulator to create a snapshot for " + avdName + " (Attempt " + (attempt + 1) + "/" + maxRetryAttempt + ")", new Object[0]);
                this.startEmulatorThenStop(true, avdName, emulatorExecutable, avdLocation, emulatorGpuFlag, logger);
                if (!AvdSnapshotHandler.checkSnapshotLoadable$default(this, avdName, emulatorExecutable, avdLocation, emulatorGpuFlag, logger, null, 32, null)) {
                    throw new EmulatorSnapshotCannotCreatedException("Snapshot setup for " + avdName + " ran successfully, but the snapshot failed to be created. This is likely to a lack of disk space for the snapshot. Try the cleanManagedDevices task with the --unused-only flag to remove any unused devices for this project.");
                }
                logger.verbose("Starting Emulator to validate a snapshot for " + avdName + " (Attempt " + (attempt + 1) + "/" + maxRetryAttempt + ")", new Object[0]);
                this.startEmulatorThenStop(false, avdName, emulatorExecutable, avdLocation, emulatorGpuFlag, logger);
                logger.info("Successfully created snapshot for: " + avdName, new Object[0]);
                return;
            }
            catch (EmulatorSnapshotCannotCreatedException e) {
                logger.warning("Failed to create Emulator snapshot image (" + (attempt + 1) + "/" + maxRetryAttempt + "). Error: " + e, new Object[0]);
                lastException = e;
            }
        }
        this.deleteSnapshotForDevice(avdName, avdManager2, logger);
        EmulatorSnapshotCannotCreatedException emulatorSnapshotCannotCreatedException = lastException;
        if (emulatorSnapshotCannotCreatedException == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lastException");
            emulatorSnapshotCannotCreatedException = null;
        }
        throw emulatorSnapshotCannotCreatedException;
    }

    private final void deleteSnapshotForDevice(String deviceName, AvdManager avdManager2, ILogger logger) {
        Path path;
        File file;
        String[] stringArray = avdManager2.getAvd(deviceName, false);
        File file2 = file = stringArray != null && (path = stringArray.getDataFolderPath()) != null ? path.toFile() : null;
        if (file == null) {
            return;
        }
        File avdDir = file;
        stringArray = new String[]{"snapshots", "default_boot"};
        File gmdSnapshot = FileUtils.join((File)avdDir, (String[])stringArray);
        if (gmdSnapshot.exists() && gmdSnapshot.isDirectory()) {
            try {
                logger.warning("Deleting unbootable snapshot for device: " + deviceName, new Object[0]);
                FileUtils.deleteRecursivelyIfExists((File)gmdSnapshot);
            }
            catch (IOException ioException) {
                logger.error((Throwable)ioException, "Could not delete snapshot at location: " + gmdSnapshot.getAbsolutePath() + ".", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startEmulatorThenStop(boolean createSnapshot, String avdName, File emulatorExecutable, File avdLocation, String emulatorGpuFlag, ILogger logger) {
        String string;
        String deviceId = ManagedDeviceUtilsKt.createSetupDeviceId((String)avdName);
        Object object = new String[5];
        String string2 = string = "-no-snapshot-load";
        int n = 0;
        Object[] objectArray = object;
        String string3 = emulatorGpuFlag;
        File file = emulatorExecutable;
        String string4 = avdName;
        AvdSnapshotHandler avdSnapshotHandler = this;
        Function1<List<String>, ProcessBuilder> function1 = this.processFactory;
        boolean bl = false;
        boolean bl2 = createSnapshot;
        objectArray[n] = bl2 ? string : null;
        String it = string = "-read-only";
        n = 1;
        objectArray = object;
        boolean bl3 = false;
        bl2 = !createSnapshot;
        objectArray[n] = bl2 ? string : null;
        it = string = "-no-snapshot-save";
        n = 2;
        objectArray = object;
        boolean bl4 = false;
        bl2 = !createSnapshot;
        objectArray[n] = bl2 ? string : null;
        object[3] = "-id";
        object[4] = deviceId;
        ProcessBuilder processBuilder2 = (ProcessBuilder)function1.invoke(avdSnapshotHandler.getEmulatorCommand(string4, file, string3, CollectionsKt.listOfNotNull((Object[])object)));
        Map<String, String> map = processBuilder2.environment();
        Intrinsics.checkNotNullExpressionValue(map, (String)"processBuilder.environment()");
        object = map;
        string = "ANDROID_AVD_HOME";
        string2 = avdLocation.getAbsolutePath();
        object.put(string, string2);
        Map<String, String> map2 = processBuilder2.environment();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"processBuilder.environment()");
        object = map2;
        string = "ANDROID_EMULATOR_WAIT_TIME_BEFORE_KILL";
        Long l = this.deviceBootAndSnapshotCheckTimeoutSec;
        string2 = String.valueOf(l != null ? l : 600L);
        object.put(string, string2);
        Process emulatorProcess = processBuilder2.start();
        AtomicBoolean bootCompleted = new AtomicBoolean(false);
        try {
            this.executor.execute(new Runnable(emulatorProcess, this, deviceId, logger, avdName, bootCompleted){
                final /* synthetic */ Process $emulatorProcess;
                final /* synthetic */ AvdSnapshotHandler this$0;
                final /* synthetic */ String $deviceId;
                final /* synthetic */ ILogger $logger;
                final /* synthetic */ String $avdName;
                final /* synthetic */ AtomicBoolean $bootCompleted;
                {
                    this.$emulatorProcess = $emulatorProcess;
                    this.this$0 = $receiver;
                    this.$deviceId = $deviceId;
                    this.$logger = $logger;
                    this.$avdName = $avdName;
                    this.$bootCompleted = $bootCompleted;
                }

                public final void run() {
                    String emulatorSerial = null;
                    while (this.$emulatorProcess.isAlive()) {
                        try {
                            emulatorSerial = AvdSnapshotHandler.access$getAdbHelper$p(this.this$0).findDeviceSerialWithId(this.$deviceId, this.$logger);
                            break;
                        }
                        catch (Exception e) {
                            this.$logger.verbose("Waiting for " + this.$avdName + " to be attached to adb. Last attempt: " + e, new Object[0]);
                            Thread.sleep(5000L);
                        }
                    }
                    if (emulatorSerial == null) {
                        return;
                    }
                    this.$logger.verbose(this.$avdName + " is attached to adb (" + emulatorSerial + ").", new Object[0]);
                    while (this.$emulatorProcess.isAlive() && !AvdSnapshotHandler.access$getAdbHelper$p(this.this$0).isBootCompleted(emulatorSerial, this.$logger)) {
                        this.$logger.verbose("Waiting for " + this.$avdName + " to boot up.", new Object[0]);
                        Thread.sleep(5000L);
                    }
                    this.$logger.verbose("Booting " + this.$avdName + " is completed.", new Object[0]);
                    while (this.$emulatorProcess.isAlive() && !AvdSnapshotHandler.access$getAdbHelper$p(this.this$0).isPackageManagerStarted(emulatorSerial, this.$logger)) {
                        this.$logger.verbose("Waiting for PackageManager to be ready on " + this.$avdName + ".", new Object[0]);
                        Thread.sleep(5000L);
                    }
                    this.$logger.verbose("PackageManager is ready on " + this.$avdName + ".", new Object[0]);
                    if (AvdSnapshotHandler.access$getExtraWaitAfterBootCompleteMs$p(this.this$0) > 0L) {
                        Thread.sleep(AvdSnapshotHandler.access$getExtraWaitAfterBootCompleteMs$p(this.this$0));
                    }
                    if (this.$emulatorProcess.isAlive()) {
                        this.$logger.verbose(this.$avdName + " is ready to take a snapshot.", new Object[0]);
                        this.$bootCompleted.set(true);
                        AvdSnapshotHandler.access$getAdbHelper$p(this.this$0).killDevice(emulatorSerial);
                    } else {
                        this.$logger.warning("Emulator process exited unexpectedly with the return code " + this.$emulatorProcess.exitValue() + ".", new Object[0]);
                    }
                }
            });
            GrabProcessOutput.grabProcessOutput((Process)emulatorProcess, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.ASYNC, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(logger){
                final /* synthetic */ ILogger $logger;
                {
                    this.$logger = $logger;
                }

                public void out(@Nullable String line) {
                    if (line == null) {
                        return;
                    }
                    this.$logger.verbose(line, new Object[0]);
                }

                public void err(@Nullable String line) {
                    if (line == null) {
                        return;
                    }
                    this.$logger.verbose(line, new Object[0]);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)emulatorProcess, (String)"emulatorProcess");
            this.waitUntilTimeout(emulatorProcess, logger, (Function0<Unit>)((Function0)new Function0<Unit>(logger, avdName){
                final /* synthetic */ ILogger $logger;
                final /* synthetic */ String $avdName;
                {
                    this.$logger = $logger;
                    this.$avdName = $avdName;
                    super(0);
                }

                public final void invoke() {
                    this.$logger.warning("Snapshot creation timed out. Closing emulator.", new Object[0]);
                    throw new EmulatorSnapshotCannotCreatedException(StringsKt.trimIndent((String)("\n                    Gradle was not able to complete device setup for: " + this.$avdName + "\n                    This could be due to having insufficient resources to provision the number of\n                    devices requested. Try running the test again and request fewer devices or\n                    fewer shards.\n                ")));
                }
            }));
            if (!bootCompleted.get()) {
                throw new EmulatorSnapshotCannotCreatedException(StringsKt.trimIndent((String)("\n                    Gradle was not able to complete device setup for: " + avdName + "\n                    The emulator failed to open the managed device to generate the snapshot.\n                    This is because the emulator closed unexpectedly (" + emulatorProcess.exitValue() + "),\n                    try updating the emulator and ensure a device can be run from Android Studio.\n                ")));
            }
        }
        finally {
            emulatorProcess.destroy();
        }
    }

    private final void ensureEmulatorVersionRequirement(File emulatorDir) {
        File packageFile = FilesKt.resolve((File)emulatorDir, (String)"package.xml");
        Pattern versionPattern = Pattern.compile("<major>(\\d+)</major><minor>(\\d+)</minor><micro>(\\d+)</micro>");
        for (String line : Files.readAllLines(packageFile.toPath())) {
            Matcher matcher = versionPattern.matcher(line);
            if (!matcher.find()) continue;
            String string = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(1)");
            int majorVersion = Integer.parseInt(string);
            String string2 = matcher.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"matcher.group(2)");
            int minorVersion = Integer.parseInt(string2);
            String string3 = matcher.group(3);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"matcher.group(3)");
            int microVersion = Integer.parseInt(string3);
            if (majorVersion > 30) {
                return;
            }
            if (majorVersion == 30 && minorVersion > 6) {
                return;
            }
            if (majorVersion == 30 && minorVersion == 6 && microVersion >= 4) {
                return;
            }
            throw new IllegalStateException(("Emulator needs to be updated in order to use managed devices. Minimum version required: 30.6.4. Version found: " + majorVersion + "." + minorVersion + "." + microVersion + ".").toString());
        }
        throw new IllegalStateException(("Could not determine version of Emulator in " + emulatorDir.getAbsolutePath() + ". Update emulator in order to use Managed Devices.").toString());
    }

    public static final /* synthetic */ AdbHelper access$getAdbHelper$p(AvdSnapshotHandler $this) {
        return $this.adbHelper;
    }

    public static final /* synthetic */ long access$getExtraWaitAfterBootCompleteMs$p(AvdSnapshotHandler $this) {
        return $this.extraWaitAfterBootCompleteMs;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/AvdSnapshotHandler$EmulatorSnapshotCannotCreatedException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "(Ljava/lang/String;)V", "gradle-core"})
    public static final class EmulatorSnapshotCannotCreatedException
    extends RuntimeException {
        public EmulatorSnapshotCannotCreatedException(@NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            super(message2);
        }
    }
}

