/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.ExtractAarTransformKt;
import com.android.builder.utils.ZipEntryUtils;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@VisibleForTesting
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fR\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/dependency/AarExtractor;", "", "()V", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "choosePathInOutput", "", "entryName", "extract", "", "aar", "Ljava/io/File;", "outputDir", "gradle-core"})
public final class AarExtractor {
    @NotNull
    private final StringBuilder stringBuilder;

    /*
     * WARNING - void declaration
     */
    public AarExtractor() {
        void $this$stringBuilder_u24lambda_u240;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder(60);
        AarExtractor aarExtractor = this;
        boolean bl = false;
        $this$stringBuilder_u24lambda_u240.append("jars");
        $this$stringBuilder_u24lambda_u240.append(File.separatorChar);
        aarExtractor.stringBuilder = stringBuilder;
    }

    private final String choosePathInOutput(String entryName) {
        String string;
        this.stringBuilder.setLength(5);
        if (Intrinsics.areEqual((Object)entryName, (Object)"classes.jar") || Intrinsics.areEqual((Object)entryName, (Object)"lint.jar")) {
            this.stringBuilder.append(entryName);
            String string2 = this.stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n                string\u2026.toString()\n            }");
            string = string2;
        } else if (StringsKt.startsWith$default((String)entryName, (String)"libs/", (boolean)false, (int)2, null)) {
            String string3 = entryName.substring(5);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String pathWithinLibs = string3;
            if (Intrinsics.areEqual((Object)pathWithinLibs, (Object)"classes.jar")) {
                this.stringBuilder.append("libs/").append("classes-2.jar");
            } else if (Intrinsics.areEqual((Object)pathWithinLibs, (Object)"lint.jar")) {
                this.stringBuilder.append("libs/").append("lint-2.jar");
            } else {
                this.stringBuilder.append("libs/").append(pathWithinLibs);
            }
            String string4 = this.stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"{\n                // In \u2026.toString()\n            }");
            string = string4;
        } else {
            string = entryName;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void extract(@NotNull File aar, @NotNull File outputDir) {
        Intrinsics.checkNotNullParameter((Object)aar, (String)"aar");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        Closeable closeable = new FileInputStream(aar);
        int n = 8192;
        closeable = new ZipInputStream(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n));
        Throwable throwable = null;
        try {
            ZipInputStream zipInputStream = (ZipInputStream)closeable;
            boolean bl = false;
            while (true) {
                ZipEntry zipEntry;
                ZipEntry zipEntry2 = zipEntry = zipInputStream.getNextEntry();
                if (zipEntry2 == null) break;
                Intrinsics.checkNotNullExpressionValue((Object)zipEntry2, (String)"zipInputStream.nextEntry ?: break");
                ZipEntry entry = zipEntry;
                if (entry.isDirectory() || !ZipEntryUtils.isValidZipEntryName((ZipEntry)entry)) continue;
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
                if (((CharSequence)string).length() == 0) continue;
                String string2 = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name");
                String path = FileUtils.toSystemDependentPath((String)this.choosePathInOutput(string2));
                File outputFile = new File(outputDir, path);
                Files.createParentDirs((File)outputFile);
                Files.asByteSink((File)outputFile, (FileWriteMode[])new FileWriteMode[0]).writeFrom((InputStream)zipInputStream);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        File classesJar = FilesKt.resolve((File)outputDir, (String)"jars/classes.jar");
        if (!classesJar.exists()) {
            Files.createParentDirs((File)classesJar);
            FilesKt.writeBytes((File)classesJar, (byte[])ExtractAarTransformKt.access$getEmptyJar$p());
        }
    }
}

