/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.json;

import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsonCompositeVisitor;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsonStatsBuildingVisitor;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsonStreamingParser;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsonStreamingVisitor;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsonsKtKt;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValue;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.cxx.json.PlainFileGsonTypeAdaptor;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;

public class AndroidBuildGradleJsons {
    public static NativeBuildConfigValueMini parseToMiniConfigAndGatherStatistics(JsonReader reader, GradleBuildVariant.Builder stats) throws IOException {
        GradleBuildVariant.NativeBuildConfigInfo.Builder config2 = GradleBuildVariant.NativeBuildConfigInfo.newBuilder();
        AndroidBuildGradleJsonStatsBuildingVisitor statsVisitor = new AndroidBuildGradleJsonStatsBuildingVisitor(config2);
        MiniConfigBuildingVisitor miniConfigVisitor = new MiniConfigBuildingVisitor();
        AndroidBuildGradleJsonCompositeVisitor composite = new AndroidBuildGradleJsonCompositeVisitor(statsVisitor, miniConfigVisitor);
        try (AndroidBuildGradleJsonStreamingParser parser2 = new AndroidBuildGradleJsonStreamingParser(reader, composite);){
            parser2.parse();
            stats.addNativeBuildConfig(config2);
            NativeBuildConfigValueMini nativeBuildConfigValueMini = miniConfigVisitor.miniConfig;
            return nativeBuildConfigValueMini;
        }
    }

    static NativeBuildConfigValueMini parseToMiniConfig(JsonReader reader) throws IOException {
        MiniConfigBuildingVisitor miniConfigVisitor = new MiniConfigBuildingVisitor();
        try (AndroidBuildGradleJsonStreamingParser parser2 = new AndroidBuildGradleJsonStreamingParser(reader, miniConfigVisitor);){
            parser2.parse();
            NativeBuildConfigValueMini nativeBuildConfigValueMini = miniConfigVisitor.miniConfig;
            return nativeBuildConfigValueMini;
        }
    }

    public static List<NativeBuildConfigValueMini> getNativeBuildMiniConfigs(List<CxxAbiModel> abis, GradleBuildVariant.Builder stats) throws IOException {
        ArrayList miniConfigs = Lists.newArrayList();
        for (CxxAbiModel abi : abis) {
            miniConfigs.add(AndroidBuildGradleJsons.getNativeBuildMiniConfig(abi, stats));
        }
        return miniConfigs;
    }

    public static NativeBuildConfigValueMini getNativeBuildMiniConfig(CxxAbiModel abi, GradleBuildVariant.Builder stats) {
        File androidGradleBuildJsonFile = CxxAbiModelKt.getJsonFile(abi);
        return AndroidBuildGradleJsonsKtKt.readMiniConfigCreateIfNecessary(androidGradleBuildJsonFile, stats);
    }

    public static void writeNativeBuildConfigValueToJsonFile(File outputJson, NativeBuildConfigValue nativeBuildConfigValue) throws IOException {
        Gson gson2 = new GsonBuilder().registerTypeAdapter(File.class, (Object)new PlainFileGsonTypeAdaptor()).disableHtmlEscaping().setPrettyPrinting().create();
        try (FileWriter jsonWriter = new FileWriter(outputJson);){
            gson2.toJson((Object)nativeBuildConfigValue, (Appendable)jsonWriter);
        }
    }

    public static void writeNativeBuildMiniConfigValueToJsonFile(File outputJson, NativeBuildConfigValueMini miniConfig) throws IOException {
        String actualResult = new GsonBuilder().registerTypeAdapter(File.class, (Object)new PlainFileGsonTypeAdaptor()).setPrettyPrinting().create().toJson((Object)miniConfig);
        outputJson.getParentFile().mkdirs();
        Files.write(outputJson.toPath(), actualResult.getBytes(Charsets.UTF_8), new OpenOption[0]);
    }

    private static class MiniConfigBuildingVisitor
    extends AndroidBuildGradleJsonStreamingVisitor {
        private final NativeBuildConfigValueMini miniConfig = new NativeBuildConfigValueMini();
        private String libraryName = null;

        MiniConfigBuildingVisitor() {
        }

        @Override
        protected void beginLibrary(String libraryName) {
            super.beginLibrary(libraryName);
            this.libraryName = libraryName;
            this.miniConfig.libraries.put(libraryName, new NativeLibraryValueMini());
        }

        @Override
        protected void visitLibraryAbi(String abi) {
            super.visitLibraryAbi(abi);
            this.miniConfig.libraries.get((Object)this.libraryName).abi = abi;
        }

        @Override
        protected void visitLibraryArtifactName(String artifactName) {
            super.visitLibraryArtifactName(artifactName);
            this.miniConfig.libraries.get((Object)this.libraryName).artifactName = artifactName;
        }

        @Override
        protected void visitLibraryBuildCommandComponents(List<String> buildCommandComponents) {
            super.visitLibraryBuildCommandComponents(buildCommandComponents);
            this.miniConfig.libraries.get((Object)this.libraryName).buildCommandComponents = buildCommandComponents;
        }

        @Override
        protected void visitCleanCommandsComponents(List<String> cleanCommandComponents) {
            super.visitCleanCommandsComponents(cleanCommandComponents);
            this.miniConfig.cleanCommandsComponents.add(cleanCommandComponents);
        }

        @Override
        protected void visitBuildTargetsCommandComponents(List<String> buildTargetsCommandComponents) {
            super.visitBuildTargetsCommandComponents(buildTargetsCommandComponents);
            this.miniConfig.buildTargetsCommandComponents = buildTargetsCommandComponents;
        }

        @Override
        protected void visitLibraryOutput(String output2) {
            if (output2 == null) {
                return;
            }
            super.visitLibraryOutput(output2);
            this.miniConfig.libraries.get((Object)this.libraryName).output = new File(output2);
        }

        @Override
        protected void visitBuildFile(String buildFile) {
            super.visitBuildFile(buildFile);
            this.miniConfig.buildFiles.add(new File(buildFile));
        }

        @Override
        protected void visitLibraryRuntimeFile(String runtimeFile) {
            super.visitLibraryRuntimeFile(runtimeFile);
            this.miniConfig.libraries.get((Object)this.libraryName).runtimeFiles.add(new File(runtimeFile));
        }
    }
}

