/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.profile.AnalyticsResourceManagerKt;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.profile.ProjectData;
import com.android.build.gradle.internal.profile.TaskMetadata;
import com.android.build.gradle.internal.profile.TaskProfilingRecord;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.VariantAwareTask;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptionService;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.profile.AnalyticsProfileWriter;
import com.android.builder.profile.NameAnonymizer;
import com.android.builder.profile.NameAnonymizerSerializer;
import com.android.builder.profile.Recorder;
import com.android.builder.profile.ThreadRecorder;
import com.android.tools.analytics.Anonymizer;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.build.gradle.internal.profile.GradleTaskExecutionType;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleBuildMemorySample;
import com.google.wireless.android.sdk.stats.GradleBuildProfile;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleBuildProject;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import com.google.wireless.android.sdk.stats.GradlePluginData;
import com.google.wireless.android.sdk.stats.GradleTaskExecution;
import com.google.wireless.android.sdk.stats.GradleTransformExecution;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u0005\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006\u0012\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u0002032\u0006\u00104\u001a\u000205J\u000e\u00106\u001a\u0002032\u0006\u00107\u001a\u000208J\b\u00109\u001a\u00020 H\u0002J\b\u0010:\u001a\u00020 H\u0002J\b\u0010;\u001a\u00020<H\u0002J\u001a\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002J\u000e\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u0006J\u0010\u0010F\u001a\u0002012\u0006\u0010E\u001a\u00020\u0006H\u0002J\u0012\u0010G\u001a\u0004\u0018\u00010\u00062\u0006\u0010H\u001a\u00020\u0006H\u0002J\u0010\u0010I\u001a\u00020\u00062\u0006\u0010J\u001a\u00020\u0006H\u0002J\u0010\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\u0006H\u0002J\u0010\u0010N\u001a\u0004\u0018\u00010-2\u0006\u0010H\u001a\u00020\u0006J\u0012\u0010O\u001a\u0004\u0018\u00010\u00062\u0006\u0010H\u001a\u00020\u0006H\u0002J\u0016\u0010P\u001a\u00020Q2\u0006\u0010E\u001a\u00020\u00062\u0006\u0010R\u001a\u00020\u0006J\u001a\u0010S\u001a\u0002012\u0006\u0010E\u001a\u00020\u00062\b\u0010R\u001a\u0004\u0018\u00010\u0006H\u0002J\u0012\u0010T\u001a\u0004\u0018\u00010\u00062\u0006\u0010H\u001a\u00020\u0006H\u0002J\u0016\u0010U\u001a\u0004\u0018\u00010\u00062\n\u0010V\u001a\u0006\u0012\u0002\b\u00030WH\u0002J\u0014\u0010X\u001a\u0002032\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00060ZJ(\u0010[\u001a\u0002032\u0006\u0010\\\u001a\u00020]2\u0006\u0010E\u001a\u00020\u00062\b\u0010^\u001a\u0004\u0018\u00010\u00062\u0006\u0010_\u001a\u00020`J2\u0010a\u001a\u0002032\u0006\u0010\\\u001a\u00020]2\b\u0010b\u001a\u0004\u0018\u00010c2\u0006\u0010E\u001a\u00020\u00062\b\u0010R\u001a\u0004\u0018\u00010\u00062\u0006\u0010_\u001a\u00020`J\u000e\u0010d\u001a\u0002032\u0006\u0010e\u001a\u00020)J\u001e\u0010f\u001a\u0002032\u0006\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u00020\t2\u0006\u0010j\u001a\u00020\tJ\u0010\u0010k\u001a\u0002032\u0006\u0010g\u001a\u00020hH\u0002J\u0010\u0010l\u001a\u0002032\b\u0010m\u001a\u0004\u0018\u00010nJ\u000e\u0010o\u001a\u0002032\u0006\u00104\u001a\u000205J\u0006\u0010p\u001a\u000203J.\u0010q\u001a\u0002032\u0006\u0010E\u001a\u00020\u00062\b\u0010R\u001a\u0004\u0018\u00010\u00062\u0006\u0010r\u001a\u00020s2\f\u0010t\u001a\b\u0012\u0004\u0012\u00020\u00180+R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u00178\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001aR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010'\u001a&\u0012\f\u0012\n **\u0004\u0018\u00010)0) **\u0012\u0012\f\u0012\n **\u0004\u0018\u00010)0)\u0018\u00010+0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020-0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006u"}, d2={"Lcom/android/build/gradle/internal/profile/AnalyticsResourceManager;", "", "profileBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfile$Builder;", "projects", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/android/build/gradle/internal/profile/ProjectData;", "enableProfileJson", "", "profileDir", "Ljava/io/File;", "taskMetadata", "Lcom/android/build/gradle/internal/profile/TaskMetadata;", "rootProjectPath", "applicationIds", "Lorg/gradle/api/provider/SetProperty;", "nameAnonymizer", "Lcom/android/builder/profile/NameAnonymizer;", "(Lcom/google/wireless/android/sdk/stats/GradleBuildProfile$Builder;Ljava/util/concurrent/ConcurrentHashMap;ZLjava/io/File;Ljava/util/concurrent/ConcurrentHashMap;Ljava/lang/String;Lorg/gradle/api/provider/SetProperty;Lcom/android/builder/profile/NameAnonymizer;)V", "analyticsWriter", "Lcom/android/builder/profile/AnalyticsProfileWriter;", "configurationSpans", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan;", "getConfigurationSpans", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "executionSpans", "getExecutionSpans$annotations", "()V", "getExecutionSpans", "initialMemorySample", "Lcom/google/wireless/android/sdk/stats/GradleBuildMemorySample;", "getInitialMemorySample", "()Lcom/google/wireless/android/sdk/stats/GradleBuildMemorySample;", "setInitialMemorySample", "(Lcom/google/wireless/android/sdk/stats/GradleBuildMemorySample;)V", "lastRecordId", "Ljava/util/concurrent/atomic/AtomicLong;", "otherEvents", "", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "kotlin.jvm.PlatformType", "", "taskRecords", "Lcom/android/build/gradle/internal/profile/TaskProfilingRecord;", "threadRecorder", "Lcom/android/builder/profile/Recorder;", "allocateRecordId", "", "collectTaskMetadata", "", "graph", "Lorg/gradle/api/execution/TaskExecutionGraph;", "configureAnalyticsService", "params", "Lcom/android/build/gradle/internal/profile/AnalyticsService$Params;", "createAndRecordMemorySample", "createMemorySample", "getFinalProfile", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfile;", "getProfileDir", "Ljava/nio/file/Path;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "gradle", "Lorg/gradle/api/invocation/Gradle;", "getProjectBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildProject$Builder;", "projectPath", "getProjectId", "getProjectPath", "taskPath", "getSystemProperty", "propertyName", "getTaskExecutionType", "Lcom/android/tools/build/gradle/internal/profile/GradleTaskExecutionType;", "taskName", "getTaskRecord", "getTypeName", "getVariantBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;", "variantName", "getVariantId", "getVariantName", "maybeGetJarName", "pluginClass", "Ljava/lang/Class;", "recordApplicationId", "applicationId", "Lorg/gradle/api/provider/Provider;", "recordBlockAtConfiguration", "executionType", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$ExecutionType;", "variant", "block", "Lcom/android/builder/profile/Recorder$VoidBlock;", "recordBlockAtExecution", "transform", "Lcom/google/wireless/android/sdk/stats/GradleTransformExecution;", "recordEvent", "event", "recordGlobalProperties", "project", "Lorg/gradle/api/Project;", "configurationCacheActive", "projectIsolationActive", "recordPlugins", "recordTaskExecutionSpan", "finishEvent", "Lorg/gradle/tooling/events/FinishEvent;", "recordTaskNames", "writeAndFinish", "writeRecord", "executionRecord", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$Builder;", "taskExecutionPhases", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nAnalyticsResourceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyticsResourceManager.kt\ncom/android/build/gradle/internal/profile/AnalyticsResourceManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,557:1\n1#2:558\n372#3,7:559\n215#4:566\n215#4,2:567\n216#4:569\n*S KotlinDebug\n*F\n+ 1 AnalyticsResourceManager.kt\ncom/android/build/gradle/internal/profile/AnalyticsResourceManager\n*L\n392#1:559,7\n431#1:566\n434#1:567,2\n431#1:569\n*E\n"})
public final class AnalyticsResourceManager {
    @NotNull
    private final GradleBuildProfile.Builder profileBuilder;
    @NotNull
    private final ConcurrentHashMap<String, ProjectData> projects;
    private boolean enableProfileJson;
    @Nullable
    private File profileDir;
    @NotNull
    private final ConcurrentHashMap<String, TaskMetadata> taskMetadata;
    @Nullable
    private String rootProjectPath;
    @Nullable
    private SetProperty<String> applicationIds;
    @NotNull
    private final NameAnonymizer nameAnonymizer;
    @NotNull
    private GradleBuildMemorySample initialMemorySample;
    @NotNull
    private final ConcurrentLinkedQueue<GradleBuildProfileSpan> configurationSpans;
    @NotNull
    private final ConcurrentLinkedQueue<GradleBuildProfileSpan> executionSpans;
    @Nullable
    private AtomicLong lastRecordId;
    @NotNull
    private final ConcurrentHashMap<String, TaskProfilingRecord> taskRecords;
    private final List<AndroidStudioEvent.Builder> otherEvents;
    @NotNull
    private final Recorder threadRecorder;
    @NotNull
    private final AnalyticsProfileWriter analyticsWriter;

    public AnalyticsResourceManager(@NotNull GradleBuildProfile.Builder profileBuilder, @NotNull ConcurrentHashMap<String, ProjectData> projects, boolean enableProfileJson, @Nullable File profileDir, @NotNull ConcurrentHashMap<String, TaskMetadata> taskMetadata, @Nullable String rootProjectPath, @Nullable SetProperty<String> applicationIds, @NotNull NameAnonymizer nameAnonymizer) {
        Intrinsics.checkNotNullParameter((Object)profileBuilder, (String)"profileBuilder");
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        Intrinsics.checkNotNullParameter(taskMetadata, (String)"taskMetadata");
        Intrinsics.checkNotNullParameter((Object)nameAnonymizer, (String)"nameAnonymizer");
        this.profileBuilder = profileBuilder;
        this.projects = projects;
        this.enableProfileJson = enableProfileJson;
        this.profileDir = profileDir;
        this.taskMetadata = taskMetadata;
        this.rootProjectPath = rootProjectPath;
        this.applicationIds = applicationIds;
        this.nameAnonymizer = nameAnonymizer;
        this.initialMemorySample = this.createMemorySample();
        this.configurationSpans = new ConcurrentLinkedQueue();
        this.executionSpans = new ConcurrentLinkedQueue();
        this.taskRecords = new ConcurrentHashMap();
        this.otherEvents = Collections.synchronizedList(new ArrayList());
        this.threadRecorder = (Recorder)new ThreadRecorder();
        this.analyticsWriter = new AnalyticsProfileWriter();
    }

    public /* synthetic */ AnalyticsResourceManager(GradleBuildProfile.Builder builder, ConcurrentHashMap concurrentHashMap, boolean bl, File file, ConcurrentHashMap concurrentHashMap2, String string, SetProperty setProperty, NameAnonymizer nameAnonymizer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            nameAnonymizer = new NameAnonymizer();
        }
        this(builder, concurrentHashMap, bl, file, concurrentHashMap2, string, (SetProperty<String>)setProperty, nameAnonymizer);
    }

    @NotNull
    public final GradleBuildMemorySample getInitialMemorySample() {
        return this.initialMemorySample;
    }

    public final void setInitialMemorySample(@NotNull GradleBuildMemorySample gradleBuildMemorySample) {
        Intrinsics.checkNotNullParameter((Object)gradleBuildMemorySample, (String)"<set-?>");
        this.initialMemorySample = gradleBuildMemorySample;
    }

    @NotNull
    public final ConcurrentLinkedQueue<GradleBuildProfileSpan> getConfigurationSpans() {
        return this.configurationSpans;
    }

    @NotNull
    public final ConcurrentLinkedQueue<GradleBuildProfileSpan> getExecutionSpans() {
        return this.executionSpans;
    }

    @VisibleForTesting
    public static /* synthetic */ void getExecutionSpans$annotations() {
    }

    public final void writeAndFinish() {
        GradleBuildProfile gradleBuildProfile = this.getFinalProfile();
        List<AndroidStudioEvent.Builder> list = this.otherEvents;
        Intrinsics.checkNotNullExpressionValue(list, (String)"otherEvents");
        this.analyticsWriter.writeAndFinish(gradleBuildProfile, list, this.profileDir, this.enableProfileJson);
    }

    @NotNull
    public final GradleBuildProject.Builder getProjectBuilder(@NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        return this.projects.computeIfAbsent(projectPath, new Function(this){
            final /* synthetic */ AnalyticsResourceManager this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final ProjectData apply(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GradleBuildProject.Builder projectBuilder = GradleBuildProject.newBuilder();
                projectBuilder.setId(AnalyticsResourceManager.access$getNameAnonymizer$p(this.this$0).anonymizeProjectPath(it));
                Intrinsics.checkNotNullExpressionValue((Object)projectBuilder, (String)"projectBuilder");
                return new ProjectData(projectBuilder);
            }
        }).getProjectBuilder();
    }

    @NotNull
    public final GradleBuildVariant.Builder getVariantBuilder(@NotNull String projectPath, @NotNull String variantName) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        ProjectData projectData2 = this.projects.computeIfAbsent(projectPath, new Function(this){
            final /* synthetic */ AnalyticsResourceManager this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final ProjectData apply(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GradleBuildProject.Builder projectBuilder = GradleBuildProject.newBuilder();
                projectBuilder.setId(AnalyticsResourceManager.access$getNameAnonymizer$p(this.this$0).anonymizeProjectPath(it));
                Intrinsics.checkNotNullExpressionValue((Object)projectBuilder, (String)"projectBuilder");
                return new ProjectData(projectBuilder);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)projectData2, (String)"fun getVariantBuilder(pr\u2026ntBuilder\n        }\n    }");
        ProjectData projectData3 = projectData2;
        GradleBuildVariant.Builder builder = projectData3.getVariantBuilders().computeIfAbsent(variantName, new Function(this, projectPath){
            final /* synthetic */ AnalyticsResourceManager this$0;
            final /* synthetic */ String $projectPath;
            {
                this.this$0 = $receiver;
                this.$projectPath = $projectPath;
            }

            @NotNull
            public final GradleBuildVariant.Builder apply(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GradleBuildVariant.Builder variantBuilder = GradleBuildVariant.newBuilder();
                variantBuilder.setId(AnalyticsResourceManager.access$getNameAnonymizer$p(this.this$0).anonymizeVariant(this.$projectPath, it));
                return variantBuilder;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"fun getVariantBuilder(pr\u2026ntBuilder\n        }\n    }");
        return builder;
    }

    @Nullable
    public final TaskProfilingRecord getTaskRecord(@NotNull String taskPath) {
        Intrinsics.checkNotNullParameter((Object)taskPath, (String)"taskPath");
        if (!this.taskRecords.containsKey(taskPath)) {
            GradleBuildProfileSpan.Builder builder;
            GradleBuildProfileSpan.Builder $this$getTaskRecord_u24lambda_u240 = builder = GradleBuildProfileSpan.newBuilder();
            boolean bl = false;
            $this$getTaskRecord_u24lambda_u240.setType(GradleBuildProfileSpan.ExecutionType.TASK_EXECUTION);
            $this$getTaskRecord_u24lambda_u240.setId(this.allocateRecordId());
            $this$getTaskRecord_u24lambda_u240.setThreadId(Thread.currentThread().getId());
            GradleBuildProfileSpan.Builder builder2 = builder;
            String string = this.getProjectPath(taskPath);
            if (string == null) {
                return null;
            }
            String projectPath = string;
            String variantName = this.getVariantName(taskPath);
            Map map = this.taskRecords;
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"builder");
            map.put(taskPath, new TaskProfilingRecord(this, builder2, taskPath, projectPath, variantName));
        }
        return this.taskRecords.get(taskPath);
    }

    public final void recordTaskExecutionSpan(@Nullable FinishEvent finishEvent) {
        GradleTaskExecution.Builder builder;
        if (finishEvent == null || !(finishEvent instanceof TaskFinishEvent)) {
            return;
        }
        String taskPath = ((TaskFinishEvent)finishEvent).getDescriptor().getTaskPath();
        Intrinsics.checkNotNullExpressionValue((Object)taskPath, (String)"taskPath");
        TaskProfilingRecord taskProfilingRecord = this.getTaskRecord(taskPath);
        if (taskProfilingRecord == null) {
            return;
        }
        TaskProfilingRecord taskRecord2 = taskProfilingRecord;
        String string = this.getTypeName(taskPath);
        if (string == null) {
            return;
        }
        String typeName = string;
        GradleTaskExecutionType taskType = this.getTaskExecutionType(typeName);
        TaskOperationResult taskResult = ((TaskFinishEvent)finishEvent).getResult();
        GradleTaskExecution.Builder taskBuilder = taskRecord2.getSpanBuilder().getTaskBuilder();
        taskBuilder.setType(taskType.getNumber());
        Intrinsics.checkNotNullExpressionValue((Object)taskResult, (String)"taskResult");
        GradleTaskExecution.TaskState taskState = AnalyticsResourceManagerKt.getTaskState(taskResult);
        taskBuilder.setTaskState(taskState);
        GradleTaskExecution.Builder $this$recordTaskExecutionSpan_u24lambda_u241 = builder = taskBuilder;
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$0[taskState.ordinal()]) {
            case 1: {
                $this$recordTaskExecutionSpan_u24lambda_u241.setUpToDate(true);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                $this$recordTaskExecutionSpan_u24lambda_u241.setDidWork(true);
                break;
            }
            case 5: {
                $this$recordTaskExecutionSpan_u24lambda_u241.setSkipped(true);
                break;
            }
            case 6: {
                $this$recordTaskExecutionSpan_u24lambda_u241.setFailed(true);
                break;
            }
            case 7: {
            }
        }
        taskRecord2.setTaskStartTime(taskResult.getStartTime());
        taskRecord2.setTaskEndTime(taskResult.getEndTime());
        taskRecord2.writeTaskSpan();
        this.createAndRecordMemorySample();
    }

    public final synchronized long allocateRecordId() {
        if (this.lastRecordId == null) {
            int spansCount = this.configurationSpans.size();
            this.lastRecordId = new AtomicLong(1 + spansCount);
        }
        AtomicLong atomicLong = this.lastRecordId;
        Intrinsics.checkNotNull((Object)atomicLong);
        return atomicLong.incrementAndGet();
    }

    public final void recordBlockAtConfiguration(@NotNull GradleBuildProfileSpan.ExecutionType executionType, @NotNull String projectPath, @Nullable String variant, @NotNull Recorder.VoidBlock block) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        GradleBuildProfileSpan span = this.threadRecorder.record(executionType, Long.valueOf(this.getProjectId(projectPath)), Long.valueOf(this.getVariantId(projectPath, variant)), Long.valueOf(this.allocateRecordId()), block);
        this.configurationSpans.add(span);
    }

    public final void recordBlockAtExecution(@NotNull GradleBuildProfileSpan.ExecutionType executionType, @Nullable GradleTransformExecution transform2, @NotNull String projectPath, @Nullable String variantName, @NotNull Recorder.VoidBlock block) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        GradleBuildProfileSpan span = this.threadRecorder.record(executionType, transform2, Long.valueOf(this.getProjectId(projectPath)), Long.valueOf(this.getVariantId(projectPath, variantName)), Long.valueOf(this.allocateRecordId()), block);
        this.executionSpans.add(span);
    }

    public final void writeRecord(@NotNull String projectPath, @Nullable String variantName, @NotNull GradleBuildProfileSpan.Builder executionRecord, @NotNull List<GradleBuildProfileSpan> taskExecutionPhases) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)executionRecord, (String)"executionRecord");
        Intrinsics.checkNotNullParameter(taskExecutionPhases, (String)"taskExecutionPhases");
        long it = this.getProjectId(projectPath);
        boolean bl = false;
        executionRecord.setProject(it);
        if (variantName == null) {
            executionRecord.setVariant(0L);
        } else {
            it = this.getVariantId(projectPath, variantName);
            boolean bl2 = false;
            executionRecord.setVariant(it);
        }
        this.executionSpans.add(executionRecord.build());
        if (!((Collection)taskExecutionPhases).isEmpty()) {
            GradleBuildProfileSpan firstPhase = taskExecutionPhases.get(0);
            this.executionSpans.add(GradleBuildProfileSpan.newBuilder().setType(GradleBuildProfileSpan.ExecutionType.GRADLE_PRE_TASK_SPAN).setParentId(executionRecord.getId()).setThreadId(executionRecord.getThreadId()).setStartTimeInMs(executionRecord.getStartTimeInMs()).setDurationInMs(firstPhase.getStartTimeInMs() - executionRecord.getStartTimeInMs()).build());
        }
        this.executionSpans.addAll((Collection<GradleBuildProfileSpan>)taskExecutionPhases);
    }

    public final void configureAnalyticsService(@NotNull AnalyticsService.Params params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        params.getProfile().set((Object)Base64.getEncoder().encodeToString(this.profileBuilder.build().toByteArray()));
        params.getAnonymizer().set((Object)new NameAnonymizerSerializer().toJson((Object)this.nameAnonymizer));
        params.getProjects().set((Map)this.projects);
        params.getEnableProfileJson().set((Object)this.enableProfileJson);
        params.getProfileDir().set((Object)this.profileDir);
        params.getTaskMetadata().set((Map)this.taskMetadata);
        params.getRootProjectPath().set((Object)this.rootProjectPath);
        params.getApplicationId().set((Provider)this.applicationIds);
    }

    public final void recordGlobalProperties(@NotNull Project project, boolean configurationCacheActive, boolean projectIsolationActive) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        BuildServiceRegistry buildServiceRegistry = project.getGradle().getSharedServices();
        Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"project.gradle.sharedServices");
        ProjectOptions projectOptions = ((ProjectOptionService)BuildServicesKt.getBuildService(buildServiceRegistry, ProjectOptionService.class).get()).getProjectOptions();
        if (!projectIsolationActive) {
            this.recordPlugins(project);
        }
        this.profileBuilder.setOsName(this.getSystemProperty("os.name")).setOsVersion(this.getSystemProperty("os.version")).setJavaVersion(this.getSystemProperty("java.version")).setJavaVmVersion(this.getSystemProperty("java.vm.version")).setMaxMemory(Runtime.getRuntime().maxMemory()).setGradleVersion(project.getGradle().getGradleVersion());
        this.profileBuilder.setConfigurationCachingEnabled(configurationCacheActive);
        this.profileBuilder.setParallelTaskExecution(project.getGradle().getStartParameter().isParallelProjectExecutionEnabled());
        String string = project.getRootProject().getProjectDir().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.rootProject.projectDir.absolutePath");
        this.rootProjectPath = StringsKt.replace$default((String)string, (char)'\\', (char)'/', (boolean)false, (int)4, null);
        this.enableProfileJson = projectOptions.get(BooleanOption.ENABLE_PROFILE_JSON);
        Gradle gradle = project.getGradle();
        Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"project.gradle");
        Path path = this.getProfileDir(projectOptions, gradle);
        this.profileDir = path != null ? path.toFile() : null;
    }

    public final void collectTaskMetadata(@NotNull TaskExecutionGraph graph) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        for (Task task : graph.getAllTasks()) {
            String string;
            String variantName = task instanceof VariantAwareTask ? ((VariantAwareTask)task).getVariantName() : (String)task.getExtensions().findByName("AGP_VARIANT_NAME");
            Map map = this.taskMetadata;
            Intrinsics.checkNotNullExpressionValue((Object)task.getPath(), (String)"task.path");
            String string2 = task.getProject().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"task.project.path");
            String string3 = AnalyticsUtil.getPotentialTaskExecutionTypeName(task.getClass());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPotentialTaskExecutionTypeName(task.javaClass)");
            TaskMetadata taskMetadata = new TaskMetadata(string2, variantName, string3);
            map.put(string, taskMetadata);
        }
    }

    public final void recordEvent(@NotNull AndroidStudioEvent.Builder event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.otherEvents.add(event);
    }

    public final void recordApplicationId(@NotNull Provider<String> applicationId2) {
        block0: {
            Intrinsics.checkNotNullParameter(applicationId2, (String)"applicationId");
            SetProperty<String> setProperty = this.applicationIds;
            if (setProperty == null) break block0;
            setProperty.add(applicationId2);
        }
    }

    private final long getProjectId(String projectPath) {
        Long id;
        ProjectData projectData2 = this.projects.get(projectPath);
        Long l = projectData2 != null && (projectData2 = projectData2.getProjectBuilder()) != null ? Long.valueOf(projectData2.getId()) : (id = null);
        if (id != null) {
            return id;
        }
        return this.nameAnonymizer.anonymizeProjectPath(projectPath);
    }

    private final long getVariantId(String projectPath, String variantName) {
        Long variantId;
        Object object = this.projects.get(projectPath);
        Long l = object != null && (object = ((ProjectData)object).getVariantBuilders()) != null && (object = (GradleBuildVariant.Builder)object.get(variantName)) != null ? Long.valueOf(object.getId()) : (variantId = null);
        if (variantId != null) {
            return variantId;
        }
        return this.nameAnonymizer.anonymizeVariant(projectPath, variantName);
    }

    private final String getProjectPath(String taskPath) {
        TaskMetadata taskMetadata = this.taskMetadata.get(taskPath);
        return taskMetadata != null ? taskMetadata.getProjectPath() : null;
    }

    private final String getVariantName(String taskPath) {
        TaskMetadata taskMetadata = this.taskMetadata.get(taskPath);
        return taskMetadata != null ? taskMetadata.getVariantName() : null;
    }

    private final String getTypeName(String taskPath) {
        TaskMetadata taskMetadata = this.taskMetadata.get(taskPath);
        return taskMetadata != null ? taskMetadata.getTypeName() : null;
    }

    private final void recordPlugins(Project project) {
        project.getGradle().allprojects(new Action(this){
            final /* synthetic */ AnalyticsResourceManager this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final void execute(Project it) {
                void $this$forEach$iv;
                String string = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.path");
                GradleBuildProject.Builder projectBuilder = this.this$0.getProjectBuilder(string);
                PluginContainer pluginContainer = it.getPlugins();
                Intrinsics.checkNotNullExpressionValue((Object)pluginContainer, (String)"it.plugins");
                Iterable iterable = (Iterable)pluginContainer;
                AnalyticsResourceManager analyticsResourceManager = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Plugin plugin = (Plugin)element$iv;
                    boolean bl = false;
                    projectBuilder.addPlugin(AnalyticsUtil.toProto(plugin));
                    GradlePluginData.Builder pluginData = GradlePluginData.newBuilder().setClassName(plugin.getClass().getName());
                    if (AnalyticsResourceManager.access$maybeGetJarName(analyticsResourceManager, plugin.getClass()) != null) {
                        String jarName;
                        boolean bl2 = false;
                        pluginData.setJarName(jarName);
                    }
                    projectBuilder.addAppliedPlugins(pluginData);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final String maybeGetJarName(Class<?> pluginClass) {
        Object v;
        void $this$getOrPut$iv;
        Map map = AnalyticsResourceManagerKt.access$getPluginJarNamesMap$p();
        String string = pluginClass.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginClass.name");
        String key$iv = string;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            String string2;
            URL entryUrl;
            boolean bl = false;
            String string3 = pluginClass.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"pluginClass.simpleName");
            String string4 = pluginClass.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"pluginClass.simpleName");
            Object it = StringsKt.substringBefore((String)string3, (char)'$', (String)string4);
            boolean bl2 = false;
            URL uRL = entryUrl = pluginClass.getResource((String)it + ".class");
            if (uRL != null) {
                CharSequence charSequence;
                Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"entryUrl");
                it = entryUrl;
                boolean bl3 = false;
                String string5 = ((URL)it).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"it.path");
                CharSequence charSequence2 = StringsKt.substringAfterLast((String)StringsKt.substringBefore((String)string5, (String)".jar!", (String)""), (char)'/', (String)"");
                if (charSequence2.length() == 0) {
                    boolean bl4 = false;
                    charSequence = null;
                } else {
                    charSequence = charSequence2;
                }
                string2 = (String)charSequence;
            } else {
                string2 = null;
            }
            String answer$iv = string2;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            v = answer$iv;
        } else {
            v = value$iv;
        }
        return (String)v;
    }

    public final void recordTaskNames(@NotNull TaskExecutionGraph graph) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        for (Task task : graph.getAllTasks()) {
            String string = task.getProject().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.project.path");
            this.getProjectBuilder(string).addTaskNames(task.getClass().getName());
        }
    }

    private final GradleTaskExecutionType getTaskExecutionType(String taskName) {
        GradleTaskExecutionType gradleTaskExecutionType;
        try {
            gradleTaskExecutionType = GradleTaskExecutionType.valueOf((String)taskName);
        }
        catch (IllegalArgumentException ignored) {
            gradleTaskExecutionType = GradleTaskExecutionType.UNKNOWN_TASK_TYPE;
        }
        return gradleTaskExecutionType;
    }

    private final String getSystemProperty(String propertyName) {
        String string = System.getProperty(propertyName);
        if (string == null) {
            string = "";
        }
        return string;
    }

    private final GradleBuildProfile getFinalProfile() {
        this.profileBuilder.addMemorySample(this.initialMemorySample);
        GradleBuildMemorySample endMemorySample = this.createAndRecordMemorySample();
        this.profileBuilder.addAllSpan((Iterable)this.configurationSpans);
        this.profileBuilder.addAllSpan((Iterable)this.executionSpans);
        Map $this$forEach$iv = this.projects;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl = false;
            GradleBuildProject.Builder projectBuilder = ((ProjectData)it.getValue()).getProjectBuilder();
            Map<String, GradleBuildVariant.Builder> $this$forEach$iv2 = ((ProjectData)it.getValue()).getVariantBuilders();
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<String, GradleBuildVariant.Builder>> iterator3 = $this$forEach$iv2.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry<String, GradleBuildVariant.Builder> element$iv2;
                Map.Entry<String, GradleBuildVariant.Builder> entry = element$iv2 = iterator3.next();
                boolean bl2 = false;
                projectBuilder.addVariant(entry.getValue());
            }
            this.profileBuilder.addProject(projectBuilder);
        }
        this.profileBuilder.setBuildTime(endMemorySample.getTimestamp() - this.initialMemorySample.getTimestamp()).setGcCount(endMemorySample.getGcCount() - this.initialMemorySample.getGcCount()).setGcTime(endMemorySample.getGcTimeMs() - this.initialMemorySample.getGcTimeMs());
        String string = Anonymizer.anonymize((String)this.rootProjectPath);
        if (string == null) {
            string = "*ANONYMIZATION_ERROR*";
        }
        String anonymizedProjectId = string;
        SetProperty<String> setProperty = this.applicationIds;
        if (setProperty != null) {
            SetProperty<String> it = setProperty;
            boolean bl = false;
            Object object = it.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.get()");
            this.profileBuilder.addAllRawProjectId((Iterable)CollectionsKt.sorted((Iterable)((Iterable)object)));
        }
        this.profileBuilder.setProjectId(anonymizedProjectId);
        GradleBuildProfile gradleBuildProfile = this.profileBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)gradleBuildProfile, (String)"profileBuilder.build()");
        return gradleBuildProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final GradleBuildMemorySample createAndRecordMemorySample() {
        GradleBuildMemorySample stats = this.createMemorySample();
        GradleBuildProfile.Builder builder = this.profileBuilder;
        synchronized (builder) {
            boolean bl = false;
            GradleBuildProfile.Builder builder2 = this.profileBuilder.addMemorySample(stats);
        }
        return stats;
    }

    private final GradleBuildMemorySample createMemorySample() {
        GradleBuildMemorySample gradleBuildMemorySample = GradleBuildMemorySample.newBuilder().setJavaProcessStats(CommonMetricsData.getJavaProcessStats()).setTimestamp(System.currentTimeMillis()).build();
        Intrinsics.checkNotNullExpressionValue((Object)gradleBuildMemorySample, (String)"newBuilder()\n           \u2026s())\n            .build()");
        return gradleBuildMemorySample;
    }

    private final Path getProfileDir(ProjectOptions projectOptions, Gradle gradle) {
        String profileDir = projectOptions.get(StringOption.PROFILE_OUTPUT_DIR);
        boolean enableJsonProfile = projectOptions.get(BooleanOption.ENABLE_PROFILE_JSON);
        return profileDir != null ? gradle.getRootProject().file((Object)profileDir).toPath() : (enableJsonProfile ? gradle.getRootProject().getBuildDir().toPath().resolve("android-profile") : null);
    }

    public static final /* synthetic */ NameAnonymizer access$getNameAnonymizer$p(AnalyticsResourceManager $this) {
        return $this.nameAnonymizer;
    }

    public static final /* synthetic */ String access$maybeGetJarName(AnalyticsResourceManager $this, Class pluginClass) {
        return $this.maybeGetJarName(pluginClass);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GradleTaskExecution.TaskState.values().length];
            try {
                nArray[GradleTaskExecution.TaskState.UP_TO_DATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GradleTaskExecution.TaskState.FROM_CACHE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GradleTaskExecution.TaskState.DID_WORK_INCREMENTAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GradleTaskExecution.TaskState.DID_WORK_NON_INCREMENTAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GradleTaskExecution.TaskState.SKIPPED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GradleTaskExecution.TaskState.FAILED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GradleTaskExecution.TaskState.UNKNOWN.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

