/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.SdkParsingUtilsKt;
import com.android.repository.api.LocalPackage;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.OptionalLibrary;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\b\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000eR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0016\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lcom/android/build/gradle/internal/PlatformComponents;", "", "targetPlatformVersion", "Lcom/android/sdklib/AndroidVersion;", "aidlFramework", "Ljava/io/File;", "androidJar", "targetBootClasspath", "", "additionalLibraries", "Lcom/android/sdklib/OptionalLibrary;", "optionalLibraries", "apiVersionsFile", "coreForSystemModulesJar", "(Lcom/android/sdklib/AndroidVersion;Ljava/io/File;Ljava/io/File;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/io/File;Ljava/io/File;)V", "getAdditionalLibraries$gradle_core", "()Ljava/util/List;", "getAidlFramework$gradle_core", "()Ljava/io/File;", "getAndroidJar$gradle_core", "getApiVersionsFile", "getCoreForSystemModulesJar$gradle_core", "getOptionalLibraries$gradle_core", "getTargetBootClasspath$gradle_core", "getTargetPlatformVersion$gradle_core", "()Lcom/android/sdklib/AndroidVersion;", "Companion", "gradle-core"})
final class PlatformComponents {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AndroidVersion targetPlatformVersion;
    @NotNull
    private final File aidlFramework;
    @NotNull
    private final File androidJar;
    @NotNull
    private final List<File> targetBootClasspath;
    @NotNull
    private final List<OptionalLibrary> additionalLibraries;
    @NotNull
    private final List<OptionalLibrary> optionalLibraries;
    @Nullable
    private final File apiVersionsFile;
    @Nullable
    private final File coreForSystemModulesJar;

    public PlatformComponents(@NotNull AndroidVersion targetPlatformVersion, @NotNull File aidlFramework2, @NotNull File androidJar, @NotNull List<? extends File> targetBootClasspath, @NotNull List<? extends OptionalLibrary> additionalLibraries, @NotNull List<? extends OptionalLibrary> optionalLibraries, @Nullable File apiVersionsFile2, @Nullable File coreForSystemModulesJar) {
        Intrinsics.checkNotNullParameter((Object)targetPlatformVersion, (String)"targetPlatformVersion");
        Intrinsics.checkNotNullParameter((Object)aidlFramework2, (String)"aidlFramework");
        Intrinsics.checkNotNullParameter((Object)androidJar, (String)"androidJar");
        Intrinsics.checkNotNullParameter(targetBootClasspath, (String)"targetBootClasspath");
        Intrinsics.checkNotNullParameter(additionalLibraries, (String)"additionalLibraries");
        Intrinsics.checkNotNullParameter(optionalLibraries, (String)"optionalLibraries");
        this.targetPlatformVersion = targetPlatformVersion;
        this.aidlFramework = aidlFramework2;
        this.androidJar = androidJar;
        this.targetBootClasspath = targetBootClasspath;
        this.additionalLibraries = additionalLibraries;
        this.optionalLibraries = optionalLibraries;
        this.apiVersionsFile = apiVersionsFile2;
        this.coreForSystemModulesJar = coreForSystemModulesJar;
    }

    @NotNull
    public final AndroidVersion getTargetPlatformVersion$gradle_core() {
        return this.targetPlatformVersion;
    }

    @NotNull
    public final File getAidlFramework$gradle_core() {
        return this.aidlFramework;
    }

    @NotNull
    public final File getAndroidJar$gradle_core() {
        return this.androidJar;
    }

    @NotNull
    public final List<File> getTargetBootClasspath$gradle_core() {
        return this.targetBootClasspath;
    }

    @NotNull
    public final List<OptionalLibrary> getAdditionalLibraries$gradle_core() {
        return this.additionalLibraries;
    }

    @NotNull
    public final List<OptionalLibrary> getOptionalLibraries$gradle_core() {
        return this.optionalLibraries;
    }

    @Nullable
    public final File getApiVersionsFile() {
        return this.apiVersionsFile;
    }

    @Nullable
    public final File getCoreForSystemModulesJar$gradle_core() {
        return this.coreForSystemModulesJar;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/PlatformComponents$Companion;", "", "()V", "build", "Lcom/android/build/gradle/internal/PlatformComponents;", "sdkDirectory", "Ljava/io/File;", "targetHash", "", "build$gradle_core", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nSdkDirectLoadingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkDirectLoadingStrategy.kt\ncom/android/build/gradle/internal/PlatformComponents$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,416:1\n1#2:417\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PlatformComponents build$gradle_core(@NotNull File sdkDirectory2, @NotNull String targetHash) {
            File it;
            File file;
            AndroidVersion platformVersionFromPlatformXml;
            Intrinsics.checkNotNullParameter((Object)sdkDirectory2, (String)"sdkDirectory");
            Intrinsics.checkNotNullParameter((Object)targetHash, (String)"targetHash");
            if (!AndroidTargetHash.isPlatform((String)targetHash)) {
                return null;
            }
            AndroidVersion androidVersion = AndroidTargetHash.getVersionFromHash((String)targetHash);
            if (androidVersion == null) {
                return null;
            }
            AndroidVersion platformVersionFromHash = androidVersion;
            String platformId = DetailsTypes.getPlatformPath((AndroidVersion)platformVersionFromHash);
            Intrinsics.checkNotNullExpressionValue((Object)platformId, (String)"platformId");
            File platformBase = FilesKt.resolve((File)sdkDirectory2, (String)StringsKt.replace$default((String)platformId, (char)';', (char)'/', (boolean)false, (int)4, null));
            File platformXml = FilesKt.resolve((File)platformBase, (String)"package.xml");
            LocalPackage platformPackage = SdkParsingUtilsKt.parsePackage(platformXml);
            if (platformPackage == null || !platformId.equals(platformPackage.getPath())) {
                return null;
            }
            AndroidVersion androidVersion2 = platformVersionFromPlatformXml = SdkParsingUtilsKt.parseAndroidVersion(platformPackage);
            AndroidVersion platformVersion = (androidVersion2 != null ? androidVersion2.getExtensionLevel() : null) == null ? platformVersionFromHash : platformVersionFromPlatformXml;
            File file2 = FilesKt.resolve((File)platformBase, (String)"framework.aidl");
            File file3 = FilesKt.resolve((File)platformBase, (String)"android.jar");
            ImmutableList immutableList = ImmutableList.of((Object)FilesKt.resolve((File)platformBase, (String)"android.jar"));
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of(platformBase.resolve(\u2026ts.FN_FRAMEWORK_LIBRARY))");
            File file4 = file = FilesKt.resolve((File)platformBase, (String)"data/api-versions.xml");
            List<OptionalLibrary> list = SdkParsingUtilsKt.parseOptionalLibraries(platformPackage);
            List<OptionalLibrary> list2 = SdkParsingUtilsKt.parseAdditionalLibraries(platformPackage);
            List list3 = (List)immutableList;
            File file5 = file3;
            File file6 = file2;
            AndroidVersion androidVersion3 = platformVersion;
            boolean bl = false;
            boolean bl2 = it.exists();
            it = FilesKt.resolve((File)platformBase, (String)"core-for-system-modules.jar");
            File file7 = bl2 ? file : null;
            boolean bl3 = false;
            File file8 = it.exists() ? it : null;
            File file9 = file8;
            File file10 = file7;
            List<OptionalLibrary> list4 = list;
            List<OptionalLibrary> list5 = list2;
            List list6 = list3;
            File file11 = file5;
            File file12 = file6;
            AndroidVersion androidVersion4 = androidVersion3;
            return new PlatformComponents(androidVersion4, file12, file11, list6, list5, list4, file10, file9);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

