/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.options;

import com.android.build.gradle.options.OptionalBooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;

public final class SigningOptions {
    public static final String SIGNING_CONFIG_NAME = "externalOverride";
    private final String storeFile;
    private final String storePassword;
    private final String keyAlias;
    private final String keyPassword;
    private final String storeType;
    private final Boolean v1Enabled;
    private final Boolean v2Enabled;

    public static SigningOptions readSigningOptions(ProjectOptions options) {
        String signingStoreFile = options.get(StringOption.IDE_SIGNING_STORE_FILE);
        String signingStorePassword = options.get(StringOption.IDE_SIGNING_STORE_PASSWORD);
        String signingKeyAlias = options.get(StringOption.IDE_SIGNING_KEY_ALIAS);
        String signingKeyPassword = options.get(StringOption.IDE_SIGNING_KEY_PASSWORD);
        if (signingStoreFile != null && signingStorePassword != null && signingKeyAlias != null && signingKeyPassword != null) {
            return new SigningOptions(signingStoreFile, signingStorePassword, signingKeyAlias, signingKeyPassword, options.get(StringOption.IDE_SIGNING_STORE_TYPE), options.get(OptionalBooleanOption.SIGNING_V1_ENABLED), options.get(OptionalBooleanOption.SIGNING_V2_ENABLED));
        }
        return null;
    }

    public SigningOptions(String storeFile2, String storePassword2, String keyAlias2, String keyPassword2, String storeType2, Boolean v1Enabled, Boolean v2Enabled) {
        this.storeFile = storeFile2;
        this.storeType = storeType2;
        this.storePassword = storePassword2;
        this.keyAlias = keyAlias2;
        this.keyPassword = keyPassword2;
        this.v1Enabled = v1Enabled;
        this.v2Enabled = v2Enabled;
    }

    public String getStoreFile() {
        return this.storeFile;
    }

    public String getStorePassword() {
        return this.storePassword;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getStoreType() {
        return this.storeType;
    }

    public Boolean getV1Enabled() {
        return this.v1Enabled;
    }

    public Boolean getV2Enabled() {
        return this.v2Enabled;
    }
}

