/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.crash;

import com.android.Version;
import com.android.build.gradle.internal.crash.ExternalApiUsageException;
import com.android.tools.analytics.crash.CrashReport;
import com.google.common.base.Throwables;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/crash/PluginExceptionReport;", "Lcom/android/tools/analytics/crash/CrashReport;", "exception", "", "(Ljava/lang/Throwable;)V", "getException", "()Ljava/lang/Throwable;", "getNoPiiStacktrace", "", "ex", "serializeTo", "", "builder", "Lorg/apache/http/entity/mime/MultipartEntityBuilder;", "Companion", "gradle-core"})
public final class PluginExceptionReport
extends CrashReport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Throwable exception;

    private PluginExceptionReport(Throwable exception) {
        super("AndroidGradlePlugin", Version.ANDROID_GRADLE_PLUGIN_VERSION, MapsKt.emptyMap(), "unexpectedException");
        this.exception = exception;
    }

    @NotNull
    public final Throwable getException() {
        return this.exception;
    }

    protected void serializeTo(@NotNull MultipartEntityBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.addTextBody("exception_info", this.getNoPiiStacktrace(this.exception));
    }

    private final String getNoPiiStacktrace(Throwable ex) {
        StringBuilder sb = new StringBuilder(ex.getClass().getName());
        sb.append(": <message removed>");
        StackTraceElement[] stackTraceElementArray = ex.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"ex.stackTrace");
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            sb.append("\n\tat ");
            sb.append(stackTraceElement);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public /* synthetic */ PluginExceptionReport(Throwable exception, DefaultConstructorMarker $constructor_marker) {
        this(exception);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\t"}, d2={"Lcom/android/build/gradle/internal/crash/PluginExceptionReport$Companion;", "", "()V", "create", "Lcom/android/build/gradle/internal/crash/PluginExceptionReport;", "ex", "", "isUsefulException", "", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PluginExceptionReport create(@NotNull Throwable ex) {
            Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
            if (ex instanceof ExternalApiUsageException) {
                return null;
            }
            Throwable rootCause = Throwables.getRootCause((Throwable)ex);
            Intrinsics.checkNotNullExpressionValue((Object)rootCause, (String)"rootCause");
            if (this.isUsefulException(rootCause)) {
                return new PluginExceptionReport(rootCause, null);
            }
            return null;
        }

        private final boolean isUsefulException(Throwable ex) {
            return ex instanceof NullPointerException || ex instanceof ArrayIndexOutOfBoundsException || ex instanceof IllegalStateException || ex instanceof IllegalArgumentException;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

