/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing.screenshot;

import com.android.build.gradle.internal.testing.screenshot.Response;
import com.android.build.gradle.internal.testing.screenshot.ResponseTypeAdapter;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/testing/screenshot/ResponseProcessor;", "", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "process", "Lcom/android/build/gradle/internal/testing/screenshot/Response;", "gradle-core"})
public final class ResponseProcessor {
    @NotNull
    private final Path path;

    public ResponseProcessor(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
    }

    @NotNull
    public final Response process() {
        int exitValue = 0;
        File responseFile = null;
        Response response = null;
        try {
            File file = this.path.resolve("response.json").toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"path.resolve(\"response.json\").toFile()");
            responseFile = file;
            Object object = new ResponseTypeAdapter().fromJson(FilesKt.readText$default((File)responseFile, null, (int)1, null));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ResponseTypeAdapter().fr\u2026(responseFile.readText())");
            response = (Response)object;
            exitValue = response.getStatus();
        }
        catch (Exception e) {
            throw new GradleException("Unable to render screenshots.", (Throwable)e);
        }
        if (exitValue == 3) {
            throw new GradleException("No previews found to render. Use @Preview annotation on your composables in your test files to render images");
        }
        return response;
    }
}

