/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.gradle.internal.plugins.AppPlugin;
import com.android.build.gradle.internal.plugins.DynamicFeaturePlugin;
import com.android.build.gradle.internal.plugins.FusedLibraryPlugin;
import com.android.build.gradle.internal.plugins.KotlinMultiplatformAndroidPlugin;
import com.android.build.gradle.internal.plugins.LibraryPlugin;
import com.android.build.gradle.internal.plugins.PrivacySandboxSdkPlugin;
import com.android.build.gradle.internal.plugins.TestPlugin;
import com.android.build.gradle.internal.services.RunOnceBuildService;
import com.android.build.gradle.internal.services.RunOnceBuildServiceImpl;
import com.android.build.gradle.internal.utils.DependencyInfo;
import com.android.build.gradle.internal.utils.ResolutionResultUtils;
import com.android.build.gradle.internal.utils.ViolatingPluginDetector;
import com.android.builder.errors.IssueReporter;
import com.android.ide.common.repository.GradleVersion;
import java.io.Closeable;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.invocation.Gradle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0016\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\t2\u0006\u0010\r\u001a\u00020\u000e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"'\u0010\u0002\u001a\u0018\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"ANDROID_GRADLE_PLUGIN_ID", "", "MUTUALLY_EXCLUSIVE_ANDROID_GRADLE_PLUGINS", "", "Ljava/lang/Class;", "", "getMUTUALLY_EXCLUSIVE_ANDROID_GRADLE_PLUGINS", "()Ljava/util/Map;", "pluginList", "", "Lcom/android/build/gradle/internal/utils/DependencyInfo;", "enforceMinimumVersionOfPlugin", "", "project", "Lorg/gradle/api/Project;", "pluginInfo", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "enforceMinimumVersionsOfPlugins", "getBuildSrcPlugins", "", "classLoader", "Ljava/lang/ClassLoader;", "getBuildscriptDependencies", "Lorg/gradle/api/artifacts/component/ModuleComponentIdentifier;", "gradle-core"})
@JvmName(name="GradlePluginUtils")
@SourceDebugExtension(value={"SMAP\nGradlePluginUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradlePluginUtils.kt\ncom/android/build/gradle/internal/utils/GradlePluginUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,268:1\n1549#2:269\n1620#2,3:270\n*S KotlinDebug\n*F\n+ 1 GradlePluginUtils.kt\ncom/android/build/gradle/internal/utils/GradlePluginUtils\n*L\n219#1:269\n219#1:270,3\n*E\n"})
public final class GradlePluginUtils {
    @NotNull
    private static final List<DependencyInfo> pluginList;
    @NotNull
    public static final String ANDROID_GRADLE_PLUGIN_ID = "com.android.base";
    @NotNull
    private static final Map<? extends Class<? extends Object>, String> MUTUALLY_EXCLUSIVE_ANDROID_GRADLE_PLUGINS;

    public static final void enforceMinimumVersionsOfPlugins(@NotNull Project project, @NotNull IssueReporter issueReporter2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)issueReporter2, (String)"issueReporter");
        if (((RunOnceBuildService)new RunOnceBuildServiceImpl.RegistrationAction(project).execute().get()).getOrSetActionPerformed("enforceMinimumVersionsOfPlugins", "com.android.build.gradle.internal.utils.GradlePluginUtils")) {
            return;
        }
        project.getGradle().projectsEvaluated(new Action(issueReporter2){
            final /* synthetic */ IssueReporter $issueReporter;
            {
                this.$issueReporter = $issueReporter;
            }

            public final void execute(Gradle gradle) {
                Set projectsToCheck = new LinkedHashSet<E>();
                gradle.allprojects(new Action(projectsToCheck){
                    final /* synthetic */ Set<Project> $projectsToCheck;
                    {
                        this.$projectsToCheck = $projectsToCheck;
                    }

                    public final void execute(Project it) {
                        if (it.getPluginManager().hasPlugin("com.android.base")) {
                            for (Project current = it; current != null && this.$projectsToCheck.add(current); current = current.getParent()) {
                            }
                        }
                    }
                });
                Set pluginsToCheck = new LinkedHashSet<E>();
                gradle.allprojects(new Action(pluginsToCheck){
                    final /* synthetic */ Set<DependencyInfo> $pluginsToCheck;
                    {
                        this.$pluginsToCheck = $pluginsToCheck;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void execute(Project it) {
                        if (it.getPluginManager().hasPlugin("com.android.base")) {
                            void $this$filterTo$iv$iv;
                            void $this$filter$iv;
                            Iterable iterable = GradlePluginUtils.access$getPluginList$p();
                            Set<DependencyInfo> set = this.$pluginsToCheck;
                            boolean $i$f$filter = false;
                            void var4_5 = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                DependencyInfo dependencyInfo = (DependencyInfo)element$iv$iv;
                                boolean bl = false;
                                boolean bl2 = dependencyInfo.getPluginId() == null || it.getPluginManager().hasPlugin(dependencyInfo.getPluginId());
                                if (!bl2) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            set.addAll((List)destination$iv$iv);
                        }
                    }
                });
                gradle.allprojects(new Action(projectsToCheck, pluginsToCheck, this.$issueReporter){
                    final /* synthetic */ Set<Project> $projectsToCheck;
                    final /* synthetic */ Set<DependencyInfo> $pluginsToCheck;
                    final /* synthetic */ IssueReporter $issueReporter;
                    {
                        this.$projectsToCheck = $projectsToCheck;
                        this.$pluginsToCheck = $pluginsToCheck;
                        this.$issueReporter = $issueReporter;
                    }

                    public final void execute(Project it) {
                        if (this.$projectsToCheck.contains(it)) {
                            for (DependencyInfo pluginToCheck : this.$pluginsToCheck) {
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                GradlePluginUtils.access$enforceMinimumVersionOfPlugin(it, pluginToCheck, this.$issueReporter);
                            }
                        }
                    }
                });
            }
        });
    }

    private static final void enforceMinimumVersionOfPlugin(Project project, DependencyInfo pluginInfo, IssueReporter issueReporter2) {
        Configuration buildScriptClasspath = project.getBuildscript().getConfigurations().getByName("classpath");
        ResolutionResult resolutionResult = buildScriptClasspath.getIncoming().getResolutionResult();
        Intrinsics.checkNotNullExpressionValue((Object)resolutionResult, (String)"buildScriptClasspath.incoming.resolutionResult");
        String string = project.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.displayName");
        List<String> pathsToViolatingPlugins = new ViolatingPluginDetector(resolutionResult, pluginInfo, string).detect();
        if (!((Collection)pathsToViolatingPlugins).isEmpty()) {
            Object[] objectArray = new Comparable[]{pluginInfo.getDisplayName(), pluginInfo.getDependencyGroup(), pluginInfo.getDependencyName(), pluginInfo.getMinimumVersion(), CollectionsKt.joinToString$default((Iterable)pathsToViolatingPlugins, (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null)};
            IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.THIRD_PARTY_GRADLE_PLUGIN_TOO_OLD, (String)("The Android Gradle plugin supports only " + pluginInfo.getDisplayName() + " Gradle plugin version " + pluginInfo.getMinimumVersion() + " and higher.\nThe following dependencies do not satisfy the required version:\n" + CollectionsKt.joinToString$default((Iterable)pathsToViolatingPlugins, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)), (String)CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)";", null, null, (int)0, null, null, (int)62, null), null, (int)8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ModuleComponentIdentifier> getBuildscriptDependencies(@NotNull Project project) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Configuration buildScriptClasspath = project.getBuildscript().getConfigurations().getByName("classpath");
        ResolutionResult resolutionResult = buildScriptClasspath.getIncoming().getResolutionResult();
        Intrinsics.checkNotNullExpressionValue((Object)resolutionResult, (String)"buildScriptClasspath.incoming.resolutionResult");
        Iterable $this$map$iv = ResolutionResultUtils.getModuleComponents$default(resolutionResult, null, 1, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResolvedComponentResult resolvedComponentResult = (ResolvedComponentResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ComponentIdentifier componentIdentifier = it.getId();
            Intrinsics.checkNotNull((Object)componentIdentifier, (String)"null cannot be cast to non-null type org.gradle.api.artifacts.component.ModuleComponentIdentifier");
            collection.add((ModuleComponentIdentifier)componentIdentifier);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Set<String> getBuildSrcPlugins(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Pattern pattern = Pattern.compile("META-INF/gradle-plugins/(.+)\\.properties");
        Enumeration<URL> urls = classLoader.getResources("META-INF/gradle-plugins");
        HashSet<String> buildSrcPlugins = new HashSet<String>();
        while (urls.hasMoreElements()) {
            URLConnection urlConnection;
            URL url = urls.nextElement();
            String string = url.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.toString()");
            if (!StringsKt.endsWith$default((String)string, (String)"buildSrc.jar!/META-INF/gradle-plugins", (boolean)false, (int)2, null) || !((urlConnection = url.openConnection()) instanceof JarURLConnection)) continue;
            Closeable closeable = ((JarURLConnection)urlConnection).getJarFile();
            Throwable throwable = null;
            try {
                JarFile jar = (JarFile)closeable;
                boolean bl = false;
                Enumeration<JarEntry> jarEntries = jar.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry entry = jarEntries.nextElement();
                    Matcher matcher = pattern.matcher(entry.getName());
                    if (!matcher.matches()) continue;
                    buildSrcPlugins.add(matcher.group(1));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return buildSrcPlugins;
    }

    @NotNull
    public static final Map<? extends Class<? extends Object>, String> getMUTUALLY_EXCLUSIVE_ANDROID_GRADLE_PLUGINS() {
        return MUTUALLY_EXCLUSIVE_ANDROID_GRADLE_PLUGINS;
    }

    public static final /* synthetic */ List access$getPluginList$p() {
        return pluginList;
    }

    public static final /* synthetic */ void access$enforceMinimumVersionOfPlugin(Project project, DependencyInfo pluginInfo, IssueReporter issueReporter2) {
        GradlePluginUtils.enforceMinimumVersionOfPlugin(project, pluginInfo, issueReporter2);
    }

    static {
        Object[] objectArray = new DependencyInfo[6];
        GradleVersion gradleVersion = GradleVersion.parse((String)"9.0.0-rc2");
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"parse(\"9.0.0-rc2\")");
        objectArray[0] = new DependencyInfo("Butterknife", "com.jakewharton", "butterknife-gradle-plugin", gradleVersion, null, 16, null);
        GradleVersion gradleVersion2 = GradleVersion.parse((String)"1.28.0");
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion2, (String)"parse(\"1.28.0\")");
        objectArray[1] = new DependencyInfo("Crashlytics", "io.fabric.tools", "gradle", gradleVersion2, null, 16, null);
        GradleVersion gradleVersion3 = GradleVersion.parse((String)"0.8.6");
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion3, (String)"parse(\"0.8.6\")");
        objectArray[2] = new DependencyInfo("Protobuf", "com.google.protobuf", "protobuf-gradle-plugin", gradleVersion3, null, 16, null);
        GradleVersion gradleVersion4 = GradleVersion.parse((String)"1.5.20");
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion4, (String)"parse(\"1.5.20\")");
        objectArray[3] = new DependencyInfo("Kotlin", "org.jetbrains.kotlin", "kotlin-gradle-plugin", gradleVersion4, null, 16, null);
        GradleVersion gradleVersion5 = GradleVersion.parse((String)"1.6.20");
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion5, (String)"parse(\"1.6.20\")");
        objectArray[4] = new DependencyInfo("kotlin-android-extensions", "org.jetbrains.kotlin", "kotlin-gradle-plugin", gradleVersion5, "org.jetbrains.kotlin.android.extensions");
        GradleVersion gradleVersion6 = GradleVersion.parse((String)"2.5.0");
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion6, (String)"parse(\"2.5.0\")");
        objectArray[5] = new DependencyInfo("Navigation Safe Args", "androidx.navigation", "navigation-safe-args-gradle-plugin", gradleVersion6, null, 16, null);
        pluginList = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to(AppPlugin.class, (Object)"com.android.application"), TuplesKt.to(LibraryPlugin.class, (Object)"com.android.library"), TuplesKt.to(DynamicFeaturePlugin.class, (Object)"com.android.dynamic-feature"), TuplesKt.to(TestPlugin.class, (Object)"com.android.test"), TuplesKt.to(KotlinMultiplatformAndroidPlugin.class, (Object)"com.android.kotlin.multiplatform.library"), TuplesKt.to(FusedLibraryPlugin.class, (Object)"com.android.fused-library"), TuplesKt.to(PrivacySandboxSdkPlugin.class, (Object)"com.android.privacy-sandbox-sdk")};
        MUTUALLY_EXCLUSIVE_ANDROID_GRADLE_PLUGINS = MapsKt.mapOf((Pair[])objectArray);
    }
}

