/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.Version;
import com.android.build.gradle.internal.component.AndroidTestCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.InstrumentedTestCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.testing.screenshot.ImageDiffer;
import com.android.build.gradle.internal.testing.screenshot.Response;
import com.android.build.gradle.internal.testing.screenshot.ResponseTypeAdapter;
import com.android.build.gradle.internal.testing.screenshot.Verify;
import com.android.buildanalyzer.common.TaskCategory;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.VerificationTask;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@BuildAnalyzer(primaryTaskCategory=TaskCategory.TEST)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0014R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u001e\u0010\f\u001a\u00020\r8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/PreviewScreenshotValidationTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "Lorg/gradle/api/tasks/VerificationTask;", "()V", "goldenImageDir", "Lorg/gradle/api/file/DirectoryProperty;", "getGoldenImageDir", "()Lorg/gradle/api/file/DirectoryProperty;", "imageOutputDir", "getImageOutputDir", "renderTaskOutputDir", "getRenderTaskOutputDir", "variantName", "", "getVariantName", "()Ljava/lang/String;", "setVariantName", "(Ljava/lang/String;)V", "doTaskAction", "", "Companion", "CreationAction", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nPreviewScreenshotValidationTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewScreenshotValidationTask.kt\ncom/android/build/gradle/internal/tasks/PreviewScreenshotValidationTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n766#2:176\n857#2,2:177\n*S KotlinDebug\n*F\n+ 1 PreviewScreenshotValidationTask.kt\ncom/android/build/gradle/internal/tasks/PreviewScreenshotValidationTask\n*L\n94#1:176\n94#1:177,2\n*E\n"})
public abstract class PreviewScreenshotValidationTask
extends NonIncrementalTask
implements VerificationTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Internal
    public String variantName;
    @NotNull
    public static final String previewlibCliToolConfigurationName = "_internal-screenshot-test-task-previewlib-cli";

    @Override
    @NotNull
    public String getVariantName() {
        String string = this.variantName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"variantName");
        return null;
    }

    @Override
    public void setVariantName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.variantName = string;
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract DirectoryProperty getGoldenImageDir();

    @InputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract DirectoryProperty getRenderTaskOutputDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getImageOutputDir();

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doTaskAction() {
        int exitValue = 0;
        try {
            File responseFile = ((Directory)this.getRenderTaskOutputDir().get()).file("response.json").getAsFile();
            ResponseTypeAdapter responseTypeAdapter = new ResponseTypeAdapter();
            Intrinsics.checkNotNullExpressionValue((Object)responseFile, (String)"responseFile");
            Response response = (Response)responseTypeAdapter.fromJson(FilesKt.readText$default((File)responseFile, null, (int)1, null));
            exitValue = response.getStatus();
        }
        catch (Exception e) {
            throw new GradleException("Unable to render screenshots.", (Throwable)e);
        }
        Object[] e = new Integer[]{1, 2};
        if (CollectionsKt.listOf((Object[])e).contains(exitValue)) {
            throw new GradleException("Screenshots could not be generated. See report for details.");
        }
        if (exitValue > 3) {
            throw new GradleException("Unknown error code " + exitValue + " returned.");
        }
        int missingGoldens = 0;
        int verificationFailures = 0;
        for (File screenshot : this.getRenderTaskOutputDir().getAsFileTree().getFiles()) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullExpressionValue((Object)screenshot, (String)"screenshot");
            FilesKt.copyTo$default((File)screenshot, (File)new File(((File)this.getImageOutputDir().getAsFile().get()).getAbsolutePath() + "/" + screenshot.getName()), (boolean)false, (int)0, (int)6, null);
            ImageDiffer.MSSIMMatcher imageDiffer = new ImageDiffer.MSSIMMatcher(0.0f, 1, null);
            Verify verifier = new Verify(imageDiffer, ((File)this.getImageOutputDir().getAsFile().get()).getAbsolutePath() + screenshot.getName());
            Set set = this.getGoldenImageDir().files(new Object[0]).getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"goldenImageDir.files().files");
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                File it = (File)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)screenshot.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            File goldenImageForScreenshot = (File)CollectionsKt.first((List)((List)destination$iv$iv));
            if (goldenImageForScreenshot == null) {
                ++missingGoldens;
                continue;
            }
            String string = goldenImageForScreenshot.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"goldenImageForScreenshot.absolutePath");
            BufferedImage bufferedImage = ImageIO.read(screenshot);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(screenshot)");
            Verify.AnalysisResult result2 = verifier.assertMatchGolden(string, bufferedImage);
            if (result2 instanceof Verify.AnalysisResult.Passed) continue;
            ++verificationFailures;
        }
        if (missingGoldens > 0 || verificationFailures > 0) {
            Object message2 = "Failed to validate screenshots.";
            if (missingGoldens > 0) {
                message2 = (String)message2 + " There were " + missingGoldens + " golden images missing.";
            }
            if (verificationFailures > 0) {
                message2 = (String)message2 + " " + verificationFailures + " screenshots failed to match their golden images.";
            }
            message2 = (String)message2 + " See test report for details.";
            throw new GradleException((String)message2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/build/gradle/internal/tasks/PreviewScreenshotValidationTask$Companion;", "", "()V", "previewlibCliToolConfigurationName", "", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/tasks/PreviewScreenshotValidationTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/PreviewScreenshotValidationTask;", "Lcom/android/build/gradle/internal/component/InstrumentedTestCreationConfig;", "androidTestCreationConfig", "Lcom/android/build/gradle/internal/component/AndroidTestCreationConfig;", "imageOutputDir", "Ljava/io/File;", "goldenImageDir", "(Lcom/android/build/gradle/internal/component/AndroidTestCreationConfig;Ljava/io/File;Ljava/io/File;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "maybeCreatePreviewlibCliToolConfiguration", "project", "Lorg/gradle/api/Project;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<PreviewScreenshotValidationTask, InstrumentedTestCreationConfig> {
        @NotNull
        private final AndroidTestCreationConfig androidTestCreationConfig;
        @NotNull
        private final File imageOutputDir;
        @NotNull
        private final File goldenImageDir;
        @NotNull
        private final String name;
        @NotNull
        private final Class<PreviewScreenshotValidationTask> type;

        public CreationAction(@NotNull AndroidTestCreationConfig androidTestCreationConfig, @NotNull File imageOutputDir, @NotNull File goldenImageDir) {
            Intrinsics.checkNotNullParameter((Object)androidTestCreationConfig, (String)"androidTestCreationConfig");
            Intrinsics.checkNotNullParameter((Object)imageOutputDir, (String)"imageOutputDir");
            Intrinsics.checkNotNullParameter((Object)goldenImageDir, (String)"goldenImageDir");
            super((ComponentCreationConfig)androidTestCreationConfig);
            this.androidTestCreationConfig = androidTestCreationConfig;
            this.imageOutputDir = imageOutputDir;
            this.goldenImageDir = goldenImageDir;
            this.name = VariantTaskCreationAction.computeTaskName$default(this, "previewScreenshot", null, 2, null);
            this.type = PreviewScreenshotValidationTask.class;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<PreviewScreenshotValidationTask> getType() {
            return this.type;
        }

        @Override
        public void configure(@NotNull PreviewScreenshotValidationTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            ComponentCreationConfig componentCreationConfig = this.creationConfig;
            AndroidTestCreationConfig androidTestCreationConfig = componentCreationConfig instanceof AndroidTestCreationConfig ? (AndroidTestCreationConfig)componentCreationConfig : null;
            VariantCreationConfig testedConfig = androidTestCreationConfig != null ? androidTestCreationConfig.getMainVariant() : null;
            Object object = testedConfig;
            if (object == null || (object = object.getName()) == null) {
                object = ((InstrumentedTestCreationConfig)this.creationConfig).getName();
            }
            task.setVariantName((String)object);
            VariantCreationConfig testedVariant = this.androidTestCreationConfig.getMainVariant();
            task.setDescription("Run screenshot tests for the " + testedVariant.getName() + " build.");
            task.setGroup("verification");
            Project project = task.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"task.project");
            this.maybeCreatePreviewlibCliToolConfiguration(project);
            task.getGoldenImageDir().set(this.goldenImageDir);
            task.getGoldenImageDir().disallowChanges();
            task.getImageOutputDir().set(this.imageOutputDir);
            task.getImageOutputDir().disallowChanges();
            ((InstrumentedTestCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.SCREENSHOTS_RENDERED.INSTANCE, (Property)task.getRenderTaskOutputDir());
        }

        private final void maybeCreatePreviewlibCliToolConfiguration(Project project) {
            ConfigurationContainer container = project.getConfigurations();
            DependencyHandler dependencies2 = project.getDependencies();
            if (container.findByName(PreviewScreenshotValidationTask.previewlibCliToolConfigurationName) == null) {
                Object object = container.create(PreviewScreenshotValidationTask.previewlibCliToolConfigurationName);
                Configuration $this$maybeCreatePreviewlibCliToolConfiguration_u24lambda_u240 = (Configuration)object;
                boolean bl = false;
                $this$maybeCreatePreviewlibCliToolConfiguration_u24lambda_u240.setVisible(false);
                $this$maybeCreatePreviewlibCliToolConfiguration_u24lambda_u240.setTransitive(true);
                $this$maybeCreatePreviewlibCliToolConfiguration_u24lambda_u240.setCanBeConsumed(false);
                $this$maybeCreatePreviewlibCliToolConfiguration_u24lambda_u240.setDescription("A configuration to resolve PreviewLib CLI tool dependencies.");
                dependencies2.add(PreviewScreenshotValidationTask.previewlibCliToolConfigurationName, (Object)("com.android.screenshot.cli:screenshot:" + Version.ANDROID_TOOLS_BASE_VERSION));
            }
        }
    }
}

