/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.Version;
import com.android.build.gradle.options.StringOption;
import com.android.builder.core.ComponentType;
import com.android.builder.core.ComponentTypeImpl;
import com.android.builder.errors.IssueReporter;
import com.android.ide.common.repository.AgpVersion;
import com.android.tools.lint.model.LintModelModuleType;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0002\u001a\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00012\b\b\u0002\u0010\u0007\u001a\u00020\u0001H\u0000\u001a\f\u0010\b\u001a\u00020\t*\u00020\nH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"LINT_XML_CONFIG_FILE_NAME", "", "getLintMavenArtifactVersion", "versionOverride", "reporter", "Lcom/android/builder/errors/IssueReporter;", "defaultVersion", "agpVersion", "toLintModelModuleType", "Lcom/android/tools/lint/model/LintModelModuleType;", "Lcom/android/builder/core/ComponentType;", "gradle-core"})
@JvmName(name="AndroidLintInputs")
public final class AndroidLintInputs {
    @NotNull
    public static final String LINT_XML_CONFIG_FILE_NAME = "lint.xml";

    @NotNull
    public static final LintModelModuleType toLintModelModuleType(@NotNull ComponentType $this$toLintModelModuleType) {
        LintModelModuleType lintModelModuleType;
        Intrinsics.checkNotNullParameter((Object)$this$toLintModelModuleType, (String)"<this>");
        ComponentType componentType = $this$toLintModelModuleType;
        if (componentType == ComponentTypeImpl.BASE_APK) {
            lintModelModuleType = LintModelModuleType.APP;
        } else if (componentType == ComponentTypeImpl.LIBRARY) {
            lintModelModuleType = LintModelModuleType.LIBRARY;
        } else if (componentType == ComponentTypeImpl.OPTIONAL_APK) {
            lintModelModuleType = LintModelModuleType.DYNAMIC_FEATURE;
        } else if (componentType == ComponentTypeImpl.TEST_APK) {
            lintModelModuleType = LintModelModuleType.TEST;
        } else if (componentType == ComponentTypeImpl.KMP_ANDROID) {
            lintModelModuleType = LintModelModuleType.LIBRARY;
        } else {
            throw new RuntimeException("Unsupported ComponentTypeImpl value");
        }
        return lintModelModuleType;
    }

    @NotNull
    public static final String getLintMavenArtifactVersion(@Nullable String versionOverride, @Nullable IssueReporter reporter, @NotNull String defaultVersion, @NotNull String agpVersion) {
        Intrinsics.checkNotNullParameter((Object)defaultVersion, (String)"defaultVersion");
        Intrinsics.checkNotNullParameter((Object)agpVersion, (String)"agpVersion");
        if (versionOverride == null) {
            return defaultVersion;
        }
        AgpVersion parsed = AgpVersion.Companion.tryParse(versionOverride);
        if (parsed == null) {
            IssueReporter issueReporter2 = reporter;
            if (issueReporter2 != null) {
                IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)StringsKt.trimIndent((String)("\n                    Could not parse lint version override '" + versionOverride + "'\n                    Recommendation: Remove or update the gradle property " + StringOption.LINT_VERSION_OVERRIDE.getPropertyName() + " to be at least " + agpVersion + "\n                    ")), null, null, (int)12, null);
            }
            return defaultVersion;
        }
        AgpVersion agpVersion2 = AgpVersion.Companion.parse(defaultVersion);
        String normalizedOverride = parsed.getMajor() + 23 + StringsKt.removePrefix((String)versionOverride, (CharSequence)String.valueOf(parsed.getMajor()));
        AgpVersion agpVersion3 = AgpVersion.Companion.tryParse(normalizedOverride);
        if (agpVersion3 == null) {
            throw new IllegalStateException("Unexpected parse error".toString());
        }
        AgpVersion normalizedParsed = agpVersion3;
        if (normalizedParsed.compareTo(agpVersion2) < 0) {
            IssueReporter issueReporter3 = reporter;
            if (issueReporter3 != null) {
                IssueReporter.reportError$default((IssueReporter)issueReporter3, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)StringsKt.trimIndent((String)("\n                    Lint must be at least version " + agpVersion + "\n                    Recommendation: Remove or update the gradle property " + StringOption.LINT_VERSION_OVERRIDE.getPropertyName() + " to be at least " + agpVersion + "\n                    ")), null, null, (int)12, null);
            }
            return defaultVersion;
        }
        return normalizedOverride;
    }

    public static /* synthetic */ String getLintMavenArtifactVersion$default(String string, IssueReporter issueReporter2, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            String string4 = Version.ANDROID_TOOLS_BASE_VERSION;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"ANDROID_TOOLS_BASE_VERSION");
            string2 = string4;
        }
        if ((n & 8) != 0) {
            String string5 = Version.ANDROID_GRADLE_PLUGIN_VERSION;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"ANDROID_GRADLE_PLUGIN_VERSION");
            string3 = string5;
        }
        return AndroidLintInputs.getLintMavenArtifactVersion(string, issueReporter2, string2, string3);
    }
}

