/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.configure.NdkAbiFileKt;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.ndk.AbiInfo;
import com.android.utils.cxx.CxxDiagnosticCode;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/cxx/configure/NdkAbiFile;", "", "abiFile", "Ljava/io/File;", "(Ljava/io/File;)V", "abiInfoList", "", "Lcom/android/build/gradle/internal/ndk/AbiInfo;", "getAbiInfoList", "()Ljava/util/List;", "fallbackAbis", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nNdkAbiFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NdkAbiFile.kt\ncom/android/build/gradle/internal/cxx/configure/NdkAbiFile\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,188:1\n3792#2:189\n4307#2,2:190\n1549#3:192\n1620#3,3:193\n*S KotlinDebug\n*F\n+ 1 NdkAbiFile.kt\ncom/android/build/gradle/internal/cxx/configure/NdkAbiFile\n*L\n73#1:189\n73#1:190,2\n74#1:192\n74#1:193,3\n*E\n"})
public final class NdkAbiFile {
    @NotNull
    private final List<AbiInfo> abiInfoList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdkAbiFile(@NotNull File abiFile) {
        List<AbiInfo> list;
        Intrinsics.checkNotNullParameter((Object)abiFile, (String)"abiFile");
        NdkAbiFile ndkAbiFile = this;
        if (abiFile.isFile()) {
            List<AbiInfo> list2;
            Closeable closeable = new FileReader(abiFile);
            NdkAbiFile ndkAbiFile2 = ndkAbiFile;
            Throwable throwable = null;
            try {
                List<AbiInfo> list3;
                FileReader reader = (FileReader)closeable;
                boolean bl = false;
                try {
                    Reader reader2 = reader;
                    String string = abiFile.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"abiFile.toString()");
                    list3 = NdkAbiFileKt.parseAbiJson(reader2, string);
                }
                catch (Throwable e) {
                    LoggingEnvironmentKt.errorln(CxxDiagnosticCode.NDK_CORRUPTED, "Could not parse '" + abiFile + "'.", new Object[0]);
                    list3 = this.fallbackAbis();
                }
                list2 = list3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            list = list2;
            ndkAbiFile = ndkAbiFile2;
        } else {
            list = this.fallbackAbis();
        }
        ndkAbiFile.abiInfoList = list;
    }

    @NotNull
    public final List<AbiInfo> getAbiInfoList() {
        return this.abiInfoList;
    }

    /*
     * WARNING - void declaration
     */
    private final List<AbiInfo> fallbackAbis() {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Abi[] $this$filter$iv = Abi.values();
        boolean $i$f$filter = false;
        Abi[] abiArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Abi element$iv$iv : $this$filterTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            if (!NdkAbiFileKt.access$isFallbackAbi((Abi)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Abi element$iv$iv;
            element$iv$iv = (Abi)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getTag();
            int n = NdkAbiFileKt.access$getBitness((Abi)it);
            String string2 = NdkAbiFileKt.getArchitecture((Abi)it);
            String string3 = NdkAbiFileKt.getTriple((Abi)it);
            String string4 = NdkAbiFileKt.access$getLlvmTriple((Abi)it);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tag");
            collection.add(new AbiInfo(string, n, true, false, string2, string3, string4));
        }
        return (List)destination$iv$iv;
    }
}

