/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.SdkConstants;
import com.android.build.gradle.internal.cxx.configure.ConfigureInvalidationState;
import com.android.build.gradle.internal.cxx.configure.ConfigureInvalidationStateKt;
import com.android.build.gradle.internal.cxx.configure.ConfigureStructuredLogCodecKt;
import com.android.build.gradle.internal.cxx.configure.NdkSymlinkerKt;
import com.android.build.gradle.internal.cxx.gradle.generator.CxxMetadataGenerator;
import com.android.build.gradle.internal.cxx.io.IoUtilsKt;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.PassThroughPrefixingLoggingEnvironment;
import com.android.build.gradle.internal.cxx.logging.PassThroughRecordingLoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment;
import com.android.build.gradle.internal.cxx.model.CreateCxxVariantModelKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CxxModuleModelKt;
import com.android.build.gradle.internal.cxx.model.JsonUtilKt;
import com.android.build.gradle.internal.cxx.model.PrefabConfigurationState;
import com.android.build.gradle.internal.cxx.process.ExecuteProcessCommand;
import com.android.build.gradle.internal.cxx.string.StringEncoder;
import com.android.build.gradle.internal.cxx.timing.TimingEnvironment;
import com.android.build.gradle.internal.cxx.timing.TimingEnvironmentKt;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.GeneratePrefabPackagesKt;
import com.android.ide.common.process.ProcessException;
import com.android.utils.FileUtils;
import com.android.utils.cxx.CxxDiagnosticCode;
import com.android.utils.cxx.os.OsBehaviorKt;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.protobuf.GeneratedMessageV3;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Internal;
import org.gradle.process.ExecOperations;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H&J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003H&R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/android/build/gradle/tasks/ExternalNativeJsonGenerator;", "Lcom/android/build/gradle/internal/cxx/gradle/generator/CxxMetadataGenerator;", "abi", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "variantBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;", "(Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;)V", "getAbi", "()Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "getVariantBuilder", "()Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;", "checkPrefabConfig", "", "configure", "ops", "Lorg/gradle/process/ExecOperations;", "forceConfigure", "", "configureOneAbi", "executeProcess", "getConfigureInputFiles", "", "Ljava/io/File;", "getProcessBuilder", "Lcom/android/build/gradle/internal/cxx/process/ExecuteProcessCommand;", "Companion", "gradle-core"})
public abstract class ExternalNativeJsonGenerator
implements CxxMetadataGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CxxAbiModel abi;
    @Nullable
    private final GradleBuildVariant.Builder variantBuilder;

    public ExternalNativeJsonGenerator(@NotNull CxxAbiModel abi, @Nullable GradleBuildVariant.Builder variantBuilder) {
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        this.abi = abi;
        this.variantBuilder = variantBuilder;
    }

    @Internal(value="Temporary to suppress Gradle warnings (bug 135900510), may need more investigation")
    @NotNull
    public final CxxAbiModel getAbi() {
        return this.abi;
    }

    @Override
    @Internal
    @Nullable
    public GradleBuildVariant.Builder getVariantBuilder() {
        return this.variantBuilder;
    }

    @Override
    public void configure(@NotNull ExecOperations ops2, boolean forceConfigure) {
        Intrinsics.checkNotNullParameter((Object)ops2, (String)"ops");
        ThreadLoggingEnvironment.Companion.requireExplicitLogger();
        if (this.abi.getVariant().getModule().getNdkFolderAfterSymLinking() != null && !this.abi.getVariant().getModule().getNdkFolder().isDirectory() && !NdkSymlinkerKt.trySymlinkNdk(this.abi.getVariant().getModule().getNdkFolderBeforeSymLinking(), this.abi.getVariant().getModule().getNdkFolderAfterSymLinking())) {
            return;
        }
        if (!this.abi.getVariant().getModule().getNdkFolder().isDirectory()) {
            throw new IllegalStateException("Expected NDK folder to exist".toString());
        }
        CreateCxxVariantModelKt.getPrefabPackageConfigurationList(this.abi.getVariant());
        CreateCxxVariantModelKt.getPrefabPackageDirectoryList(this.abi.getVariant());
        CreateCxxVariantModelKt.getPrefabClassPath(this.abi.getVariant());
        try {
            this.configureOneAbi(ops2, forceConfigure, this.abi);
        }
        catch (GradleException e) {
            Object[] objectArray = new Object[]{e.getMessage() + " : " + ExceptionsKt.stackTraceToString((Throwable)e)};
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.METADATA_GENERATION_GRADLE_EXCEPTION, "exception while building Json %s", objectArray);
        }
        catch (ProcessException e) {
            Object[] objectArray = new Object[]{CxxModuleModelKt.getBuildSystemTag(this.abi.getVariant().getModule()), this.abi.getVariant().getModule().getMakeFile(), e.getMessage() + " : " + ExceptionsKt.stackTraceToString((Throwable)e)};
            LoggingEnvironmentKt.errorln(CxxDiagnosticCode.METADATA_GENERATION_PROCESS_FAILURE, "error when building with %s using %s: %s", objectArray);
        }
    }

    protected void checkPrefabConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void configureOneAbi(ExecOperations ops2, boolean forceConfigure, CxxAbiModel abi) {
        AutoCloseable autoCloseable = new PassThroughPrefixingLoggingEnvironment(abi.getVariant().getModule().getMakeFile(), abi.getVariant().getVariantName() + "|" + CxxAbiModelKt.getName(abi), false, 4, null);
        Throwable throwable = null;
        try {
            PassThroughPrefixingLoggingEnvironment recorder = (PassThroughPrefixingLoggingEnvironment)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = new TimingEnvironment(CxxAbiModelKt.getMetadataGenerationTimingFolder(abi), "generate_cxx_metadata", null, 4, null);
            Throwable throwable2 = null;
            try {
                GradleBuildVariant.Builder builder;
                GradleBuildVariant.Builder variantBuilder;
                Object processBuilder;
                TimingEnvironment it = (TimingEnvironment)autoCloseable2;
                boolean bl2 = false;
                GradleBuildVariant.NativeBuildConfigInfo.Builder variantStats = GradleBuildVariant.NativeBuildConfigInfo.newBuilder();
                variantStats.setAbi(AnalyticsUtil.getAbi(CxxAbiModelKt.getName(abi)));
                variantStats.setDebuggable(abi.getVariant().isDebuggableEnabled());
                long startTime = System.currentTimeMillis();
                variantStats.setGenerationStartMs(startTime);
                try {
                    Object[] objectArray = new Object[]{abi.getAbiPlatformVersion(), CxxAbiModelKt.getName(abi), abi.getAbiPlatformVersion()};
                    LoggingEnvironmentKt.infoln("Start JSON generation. Platform version: %s min SDK version: %s", objectArray);
                    processBuilder = this.getProcessBuilder(abi);
                    String currentBuildCommand = StringsKt.trimIndent((String)("\n                        " + ((ExecuteProcessCommand)processBuilder).argsText() + "\n                        Build command args: " + CxxAbiModelKt.getBuildCommandArguments(abi) + "\n                        Version: 2\n                        "));
                    IoUtilsKt.writeTextIfDifferent(CxxAbiModelKt.getMetadataGenerationCommandFile(abi), currentBuildCommand);
                    String prefabConfigurationState = new PrefabConfigurationState(abi.getVariant().getModule().getProject().isPrefabEnabled(), CreateCxxVariantModelKt.getPrefabClassPath(abi.getVariant()), CreateCxxVariantModelKt.getPrefabPackageDirectoryList(abi.getVariant())).toJsonString();
                    IoUtilsKt.writeTextIfDifferent(CxxAbiModelKt.getPrefabConfigFile(abi), prefabConfigurationState);
                    ConfigureInvalidationState invalidationState2 = (ConfigureInvalidationState)TimingEnvironmentKt.time("create-invalidation-state", (Function0)new Function0<ConfigureInvalidationState>(forceConfigure, abi, this){
                        final /* synthetic */ boolean $forceConfigure;
                        final /* synthetic */ CxxAbiModel $abi;
                        final /* synthetic */ ExternalNativeJsonGenerator this$0;
                        {
                            this.$forceConfigure = $forceConfigure;
                            this.$abi = $abi;
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final ConfigureInvalidationState invoke() {
                            Object[] objectArray = new File[]{CxxAbiModelKt.getNinjaBuildFile(this.$abi), CxxAbiModelKt.getNinjaBuildLocationFile(this.$abi), CxxAbiModelKt.getCompileCommandsJsonFile(this.$abi), CxxAbiModelKt.getPrefabConfigFile(this.$abi), CxxAbiModelKt.getMiniConfigFile(this.$abi), CxxAbiModelKt.getSymbolFolderIndexFile(this.$abi), CxxAbiModelKt.getBuildFileIndexFile(this.$abi), CxxAbiModelKt.getAdditionalProjectFilesIndexFile(this.$abi), CxxAbiModelKt.getCompileCommandsJsonBinFile(this.$abi)};
                            return ConfigureInvalidationStateKt.createConfigurationInvalidationState(this.$forceConfigure, CxxAbiModelKt.getLastConfigureFingerPrintFile(this.$abi), ExternalNativeJsonGenerator.access$getConfigureInputFiles(this.this$0, this.$abi), CollectionsKt.listOf((Object)CxxAbiModelKt.getJsonFile(this.$abi)), CollectionsKt.listOf((Object[])objectArray), CollectionsKt.listOf((Object)CxxAbiModelKt.getMetadataGenerationCommandFile(this.$abi)));
                        }
                    });
                    LoggingEnvironmentKt.logStructured((Function1<? super StringEncoder, ? extends GeneratedMessageV3>)((Function1)new Function1<StringEncoder, GeneratedMessageV3>(invalidationState2){
                        final /* synthetic */ ConfigureInvalidationState $invalidationState;
                        {
                            this.$invalidationState = $invalidationState;
                            super(1);
                        }

                        @NotNull
                        public final GeneratedMessageV3 invoke(@NotNull StringEncoder encoder) {
                            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
                            return ConfigureStructuredLogCodecKt.encode(this.$invalidationState, encoder);
                        }
                    }));
                    CxxAbiModelKt.getLastConfigureFingerPrintFile(abi).delete();
                    if (ConfigureInvalidationStateKt.getShouldConfigure(invalidationState2)) {
                        NativeBuildConfigValueMini nativeBuildConfigValueMini;
                        Object object = new Object[]{CxxAbiModelKt.getJsonFile(abi)};
                        LoggingEnvironmentKt.infoln("rebuilding JSON %s due to:", (Object[])object);
                        for (String reason : ConfigureInvalidationStateKt.getShouldConfigureReasonMessages(invalidationState2)) {
                            LoggingEnvironmentKt.infoln(reason, new Object[0]);
                        }
                        if (CxxAbiModelKt.shouldGeneratePrefabPackages(abi)) {
                            TimingEnvironmentKt.time("generate-prefab-packages", (Function0)new Function0<Unit>(this, ops2, abi){
                                final /* synthetic */ ExternalNativeJsonGenerator this$0;
                                final /* synthetic */ ExecOperations $ops;
                                final /* synthetic */ CxxAbiModel $abi;
                                {
                                    this.this$0 = $receiver;
                                    this.$ops = $ops;
                                    this.$abi = $abi;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.this$0.checkPrefabConfig();
                                    GeneratePrefabPackagesKt.createPrefabBuildSystemGlue(this.$ops, this.$abi);
                                }
                            });
                        }
                        if (abi.getCxxBuildFolder().getParentFile().exists()) {
                            if (ConfigureInvalidationStateKt.getSoftConfigureOkay(invalidationState2)) {
                                object = new Object[]{abi.getCxxBuildFolder()};
                                LoggingEnvironmentKt.infoln("keeping json folder '%s' but regenerating project", (Object[])object);
                            } else {
                                object = new Object[]{abi.getCxxBuildFolder()};
                                LoggingEnvironmentKt.infoln("removing stale contents from '%s'", (Object[])object);
                                FileUtils.deletePath((File)abi.getCxxBuildFolder());
                            }
                        }
                        if (abi.getCxxBuildFolder().mkdirs()) {
                            object = new Object[]{abi.getCxxBuildFolder()};
                            LoggingEnvironmentKt.infoln("created folder '%s'", (Object[])object);
                        }
                        object = new Object[]{CxxModuleModelKt.getBuildSystemTag(abi.getVariant().getModule()), processBuilder};
                        LoggingEnvironmentKt.infoln("executing %s %s", (Object[])object);
                        TimingEnvironmentKt.time("execute-generate-process", (Function0)new Function0<Unit>(this, ops2, abi){
                            final /* synthetic */ ExternalNativeJsonGenerator this$0;
                            final /* synthetic */ ExecOperations $ops;
                            final /* synthetic */ CxxAbiModel $abi;
                            {
                                this.this$0 = $receiver;
                                this.$ops = $ops;
                                this.$abi = $abi;
                                super(0);
                            }

                            public final void invoke() {
                                this.this$0.executeProcess(this.$ops, this.$abi);
                            }
                        });
                        object = new Object[]{CxxModuleModelKt.getBuildSystemTag(abi.getVariant().getModule())};
                        LoggingEnvironmentKt.infoln("done executing %s", (Object[])object);
                        for (String requiredOutput : invalidationState2.getRequiredOutputFilesList()) {
                            File file = new File(requiredOutput);
                            if (file.isFile()) continue;
                            String string = "Expected metadata generation to create '%s' but it didn't";
                            Object[] objectArray2 = new Object[]{file};
                            String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                            throw new GradleException(string2);
                        }
                        variantBuilder = this.getVariantBuilder();
                        if (variantBuilder == null) {
                            nativeBuildConfigValueMini = AndroidBuildGradleJsons.getNativeBuildMiniConfig(abi, null);
                        } else {
                            NativeBuildConfigValueMini nativeBuildConfigValueMini2;
                            GradleBuildVariant.Builder builder2 = variantBuilder;
                            synchronized (builder2) {
                                boolean bl3 = false;
                                nativeBuildConfigValueMini2 = AndroidBuildGradleJsons.getNativeBuildMiniConfig(abi, variantBuilder);
                            }
                            nativeBuildConfigValueMini = nativeBuildConfigValueMini2;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)nativeBuildConfigValueMini, (String)"if (variantBuilder == nu\u2026                        }");
                        NativeBuildConfigValueMini miniconfig = nativeBuildConfigValueMini;
                        TimingEnvironmentKt.time("remove-unexpected-so-files", (Function0)new Function0<Unit>(abi, miniconfig){
                            final /* synthetic */ CxxAbiModel $abi;
                            final /* synthetic */ NativeBuildConfigValueMini $miniconfig;
                            {
                                this.$abi = $abi;
                                this.$miniconfig = $miniconfig;
                                super(0);
                            }

                            public final void invoke() {
                                com.android.build.gradle.tasks.ExternalNativeJsonGenerator$Companion.access$removeUnexpectedSoFiles(ExternalNativeJsonGenerator.Companion, this.$abi.getSoFolder(), this.$miniconfig);
                            }
                        });
                        IoUtilsKt.writeTextIfDifferent(CxxAbiModelKt.getMetadataGenerationCommandFile(abi), currentBuildCommand);
                        IoUtilsKt.writeTextIfDifferent(CxxAbiModelKt.getPrefabConfigFile(abi), prefabConfigurationState);
                        File file = CxxAbiModelKt.getSymbolFolderIndexFile(abi);
                        String string = abi.getSoFolder().getAbsolutePath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"abi.soFolder.absolutePath");
                        IoUtilsKt.writeTextIfDifferent(file, string);
                        File file2 = CxxAbiModelKt.getBuildFileIndexFile(abi);
                        List<File> list = miniconfig.buildFiles;
                        Intrinsics.checkNotNullExpressionValue(list, (String)"miniconfig.buildFiles");
                        Iterable iterable = list;
                        String string3 = System.lineSeparator();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"lineSeparator()");
                        IoUtilsKt.writeTextIfDifferent(file2, CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string3, null, null, (int)0, null, null, (int)62, null));
                        if (CxxAbiModelKt.getCompileCommandsJsonFile(abi).isFile()) {
                            File file3 = CxxAbiModelKt.getCompileCommandsJsonFile(abi);
                            File file4 = CxxAbiModelKt.getPredictableRepublishFolder(abi);
                            String string4 = CxxAbiModelKt.getCompileCommandsJsonFile(abi).getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"abi.compileCommandsJsonFile.name");
                            IoUtilsKt.synchronizeFile$default(file3, FilesKt.resolve((File)file4, (String)string4), null, 4, null);
                        }
                        variantStats.setOutcome(GradleBuildVariant.NativeBuildConfigInfo.GenerationOutcome.SUCCESS_BUILT);
                    } else {
                        variantBuilder = new Object[]{CxxAbiModelKt.getJsonFile(abi)};
                        LoggingEnvironmentKt.infoln("JSON '%s' was up-to-date", (Object[])variantBuilder);
                        variantStats.setOutcome(GradleBuildVariant.NativeBuildConfigInfo.GenerationOutcome.SUCCESS_UP_TO_DATE);
                    }
                    ConfigureInvalidationStateKt.recordConfigurationFingerPrint(invalidationState2);
                    LoggingEnvironmentKt.infoln("JSON generation completed without problems", new Object[0]);
                }
                catch (GradleException e) {
                    try {
                        variantStats.setOutcome(GradleBuildVariant.NativeBuildConfigInfo.GenerationOutcome.FAILED);
                        LoggingEnvironmentKt.infoln("JSON generation completed with problem. Exception: " + e, new Object[0]);
                        throw e;
                        catch (IOException e2) {
                            variantStats.setOutcome(GradleBuildVariant.NativeBuildConfigInfo.GenerationOutcome.FAILED);
                            LoggingEnvironmentKt.infoln("JSON generation completed with problem. Exception: " + e2, new Object[0]);
                            throw e2;
                        }
                        catch (ProcessException e3) {
                            variantStats.setOutcome(GradleBuildVariant.NativeBuildConfigInfo.GenerationOutcome.FAILED);
                            LoggingEnvironmentKt.infoln("JSON generation completed with problem. Exception: " + e3, new Object[0]);
                            throw e3;
                        }
                    }
                    catch (Throwable throwable3) {
                        GradleBuildVariant.Builder builder3;
                        variantStats.setGenerationDurationMs(System.currentTimeMillis() - startTime);
                        GradleBuildVariant.Builder builder4 = this.getVariantBuilder();
                        if (builder4 != null) {
                            GradleBuildVariant.Builder builder5;
                            GradleBuildVariant.Builder it2 = builder4;
                            boolean bl4 = false;
                            GradleBuildVariant.Builder builder6 = it2;
                            synchronized (builder6) {
                                boolean bl5 = false;
                                builder5 = it2.addNativeBuildConfig(variantStats);
                            }
                            builder3 = builder5;
                        } else {
                            builder3 = null;
                        }
                        CxxAbiModelKt.getJsonGenerationLoggingRecordFile(abi).getParentFile().mkdirs();
                        Path path = CxxAbiModelKt.getJsonGenerationLoggingRecordFile(abi).toPath();
                        String string = PassThroughRecordingLoggingEnvironmentKt.toJsonString(recorder.getRecord());
                        Charset charset = Charsets.UTF_8;
                        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                        byte[] byArray = string.getBytes(charset);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                        Files.write(path, byArray, new OpenOption[0]);
                        LoggingEnvironmentKt.infoln("Writing build model to " + CxxAbiModelKt.getModelOutputFile(abi), new Object[0]);
                        TimingEnvironmentKt.time("write-metadata-json-to-file", (Function0)new Function0<Unit>(abi){
                            final /* synthetic */ CxxAbiModel $abi;
                            {
                                this.$abi = $abi;
                                super(0);
                            }

                            public final void invoke() {
                                JsonUtilKt.writeJsonToFile(this.$abi);
                            }
                        });
                        throw throwable3;
                    }
                }
                variantStats.setGenerationDurationMs(System.currentTimeMillis() - startTime);
                GradleBuildVariant.Builder builder7 = this.getVariantBuilder();
                if (builder7 != null) {
                    GradleBuildVariant.Builder builder8;
                    GradleBuildVariant.Builder it3 = builder7;
                    boolean bl6 = false;
                    variantBuilder = it3;
                    synchronized (variantBuilder) {
                        boolean bl7 = false;
                        builder8 = it3.addNativeBuildConfig(variantStats);
                    }
                    builder = builder8;
                } else {
                    builder = null;
                }
                CxxAbiModelKt.getJsonGenerationLoggingRecordFile(abi).getParentFile().mkdirs();
                Path path = CxxAbiModelKt.getJsonGenerationLoggingRecordFile(abi).toPath();
                processBuilder = PassThroughRecordingLoggingEnvironmentKt.toJsonString(recorder.getRecord());
                Charset charset = Charsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                byte[] byArray = ((String)processBuilder).getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                Files.write(path, byArray, new OpenOption[0]);
                LoggingEnvironmentKt.infoln("Writing build model to " + CxxAbiModelKt.getModelOutputFile(abi), new Object[0]);
                TimingEnvironmentKt.time("write-metadata-json-to-file", (Function0)new /* invalid duplicate definition of identical inner class */);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
            return;
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public abstract ExecuteProcessCommand getProcessBuilder(@NotNull CxxAbiModel var1);

    public abstract void executeProcess(@NotNull ExecOperations var1, @NotNull CxxAbiModel var2);

    private final List<File> getConfigureInputFiles(CxxAbiModel abi) {
        Set result2 = new LinkedHashSet();
        result2.add(abi.getVariant().getModule().getMakeFile());
        if (abi.getVariant().getModule().getConfigureScript() != null) {
            File file = OsBehaviorKt.which((File)abi.getVariant().getModule().getConfigureScript());
            if (file == null) {
                file = abi.getVariant().getModule().getConfigureScript();
            }
            result2.add(file);
        }
        result2.addAll((Collection)CreateCxxVariantModelKt.getPrefabPackageConfigurationList(abi.getVariant()));
        if (!CxxAbiModelKt.getJsonFile(abi).exists()) {
            return CollectionsKt.toList((Iterable)result2);
        }
        NativeBuildConfigValueMini nativeBuildConfigValueMini = AndroidBuildGradleJsons.getNativeBuildMiniConfig(abi, this.getVariantBuilder());
        Intrinsics.checkNotNullExpressionValue((Object)nativeBuildConfigValueMini, (String)"getNativeBuildMiniConfig(abi, variantBuilder)");
        NativeBuildConfigValueMini config2 = nativeBuildConfigValueMini;
        List<File> list = config2.buildFiles;
        Intrinsics.checkNotNullExpressionValue(list, (String)"config.buildFiles");
        result2.addAll((Collection)list);
        return CollectionsKt.toList((Iterable)result2);
    }

    protected static final boolean isWindows() {
        return Companion.isWindows();
    }

    public static final /* synthetic */ List access$getConfigureInputFiles(ExternalNativeJsonGenerator $this, CxxAbiModel abi) {
        return $this.getConfigureInputFiles(abi);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u001a\u0010\u0003\u001a\u00020\u00048DX\u0085\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/tasks/ExternalNativeJsonGenerator$Companion;", "", "()V", "isWindows", "", "isWindows$annotations", "()Z", "removeUnexpectedSoFiles", "", "expectedOutputFolder", "Ljava/io/File;", "config", "Lcom/android/build/gradle/internal/cxx/json/NativeBuildConfigValueMini;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        protected final boolean isWindows() {
            return SdkConstants.CURRENT_PLATFORM == 2;
        }

        @JvmStatic
        protected static /* synthetic */ void isWindows$annotations() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void removeUnexpectedSoFiles(File expectedOutputFolder, NativeBuildConfigValueMini config2) throws IOException {
            if (!expectedOutputFolder.isDirectory()) {
                return;
            }
            ArrayList arrayList = Lists.newArrayList();
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList()");
            List expectedSoFiles = arrayList;
            for (NativeLibraryValueMini library : config2.libraries.values()) {
                File output2;
                if (library.output == null) continue;
                Path path = output2.toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"output.toPath()");
                expectedSoFiles.add(path);
            }
            AutoCloseable autoCloseable = Files.walk(expectedOutputFolder.toPath(), new FileVisitOption[0]);
            Throwable throwable = null;
            try {
                Stream paths = (Stream)autoCloseable;
                boolean bl = false;
                paths.filter(removeUnexpectedSoFiles.1.1.INSTANCE).filter(removeUnexpectedSoFiles.1.2.INSTANCE).filter(new Predicate(expectedSoFiles){
                    final /* synthetic */ List<Path> $expectedSoFiles;
                    {
                        this.$expectedSoFiles = $expectedSoFiles;
                    }

                    public final boolean test(Path it) {
                        return !this.$expectedSoFiles.contains(it);
                    }
                }).forEach(removeUnexpectedSoFiles.1.4.INSTANCE);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        public static final /* synthetic */ void access$removeUnexpectedSoFiles(Companion $this, File expectedOutputFolder, NativeBuildConfigValueMini config2) {
            $this.removeUnexpectedSoFiles(expectedOutputFolder, config2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

