/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.api.variant.impl.VariantApiExtensionsKt;
import com.android.build.gradle.internal.dependency.L8DesugarLibTransform;
import com.android.build.gradle.internal.services.TaskCreationServices;
import com.android.build.gradle.internal.tasks.factory.GlobalTaskCreationConfig;
import com.android.build.gradle.internal.utils.DesugarConfigJson;
import com.android.build.gradle.internal.utils.DesugarLibConfigExtractor;
import com.android.build.gradle.internal.utils.DesugarLibLintExtractor;
import com.android.build.gradle.internal.utils.DesugarLibUtils;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import java.io.File;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ValueSourceSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u000e\u0010!\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017\u001a \u0010\"\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0002\u001a\u001e\u0010&\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020(\u001a\u0010\u0010)\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a&\u0010*\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010#\u001a\u00020+2\u0006\u0010,\u001a\u00020-\u001a\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002\u001a \u00102\u001a\u00020/2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0002\u001a.\u00103\u001a\u00020/2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\u0006\u0010'\u001a\u00020(H\u0002\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"ATTR_ENABLE_CORE_LIBRARY_DESUGARING", "Lorg/gradle/api/attributes/Attribute;", "", "getATTR_ENABLE_CORE_LIBRARY_DESUGARING", "()Lorg/gradle/api/attributes/Attribute;", "ATTR_LINT_COMPILE_SDK", "ATTR_LINT_MIN_SDK", "D8_DESUGAR_METHODS", "DESUGARED_DESUGAR_LIB", "DESUGAR_LIB_COMPONENT_NAME", "DESUGAR_LIB_CONFIG", "DESUGAR_LIB_CONFIG_FILE", "DESUGAR_LIB_LINT", "getArtifactCollection", "Lorg/gradle/api/file/FileCollection;", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "getD8DesugarMethodFileFromTransform", "coreLibDesugar", "", "getDesugarLibConfig", "Lorg/gradle/api/provider/Provider;", "services", "Lcom/android/build/gradle/internal/services/TaskCreationServices;", "getDesugarLibConfigFile", "", "Ljava/io/File;", "project", "Lorg/gradle/api/Project;", "getDesugarLibConfigFromTransform", "getDesugarLibConfiguration", "getDesugarLibDependencyGraph", "Lorg/gradle/api/artifacts/result/ResolvedComponentResult;", "getDesugarLibJarFromMaven", "getDesugarLibLintFromTransform", "minSdkVersion", "", "compileSdkVersion", "getDesugaredDesugarLib", "fullBootClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getDesugaredDesugarLibFromTransfrom", "getDesugaredMethods", "Lcom/android/build/api/variant/AndroidVersion;", "global", "Lcom/android/build/gradle/internal/tasks/factory/GlobalTaskCreationConfig;", "registerDesugarLibConfigTransform", "", "dependencies", "Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "registerDesugarLibLintTransform", "registerDesugaredDesugarLibTransform", "libConfiguration", "gradle-core"})
@JvmName(name="DesugarLibUtils")
public final class DesugarLibUtils {
    @NotNull
    private static final String DESUGAR_LIB_CONFIG_FILE = "desugar.json";
    @NotNull
    public static final String DESUGARED_DESUGAR_LIB = "_internal-desugared-desugar-lib";
    @NotNull
    public static final String DESUGAR_LIB_CONFIG = "_internal-desugar-lib-config";
    @NotNull
    private static final String DESUGAR_LIB_COMPONENT_NAME = "desugar_jdk_libs_configuration";
    @NotNull
    private static final String DESUGAR_LIB_LINT = "_internal-desugar-lib-lint";
    @NotNull
    public static final String D8_DESUGAR_METHODS = "_internal-d8-desugar-methods";
    @NotNull
    private static final Attribute<String> ATTR_LINT_MIN_SDK;
    @NotNull
    private static final Attribute<String> ATTR_LINT_COMPILE_SDK;
    @NotNull
    private static final Attribute<String> ATTR_ENABLE_CORE_LIBRARY_DESUGARING;

    @NotNull
    public static final Attribute<String> getATTR_ENABLE_CORE_LIBRARY_DESUGARING() {
        return ATTR_ENABLE_CORE_LIBRARY_DESUGARING;
    }

    @NotNull
    public static final FileCollection getDesugarLibJarFromMaven(@NotNull TaskCreationServices services) {
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Configuration configuration = DesugarLibUtils.getDesugarLibConfiguration(services);
        return DesugarLibUtils.getArtifactCollection(configuration);
    }

    @NotNull
    public static final Provider<ResolvedComponentResult> getDesugarLibDependencyGraph(@NotNull TaskCreationServices services) {
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Configuration configuration = DesugarLibUtils.getDesugarLibConfiguration(services);
        Provider provider2 = configuration.getIncoming().getResolutionResult().getRootComponent();
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"configuration.incoming.r\u2026utionResult.rootComponent");
        return provider2;
    }

    @NotNull
    public static final FileCollection getDesugaredDesugarLib(@NotNull TaskCreationServices services, int minSdkVersion2, @NotNull ConfigurableFileCollection fullBootClasspath2) {
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)fullBootClasspath2, (String)"fullBootClasspath");
        Configuration configuration = DesugarLibUtils.getDesugarLibConfiguration(services);
        DesugarLibUtils.registerDesugaredDesugarLibTransform(services, minSdkVersion2, DesugarLibUtils.getDesugarLibConfig(services), fullBootClasspath2);
        return DesugarLibUtils.getDesugaredDesugarLibFromTransfrom(configuration);
    }

    @NotNull
    public static final Provider<String> getDesugarLibConfig(@NotNull TaskCreationServices services) {
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Object object = services.getConfigurations().findByName("coreLibraryDesugaring");
        Intrinsics.checkNotNull((Object)object);
        Configuration configuration = (Configuration)object;
        DesugarLibUtils.registerDesugarLibConfigTransform(services.getDependencies());
        return services.providerOf(DesugarConfigJson.class, (Action)new Action(configuration){
            final /* synthetic */ Configuration $configuration;
            {
                this.$configuration = $configuration;
            }

            public final void execute(ValueSourceSpec<DesugarConfigJson.Parameters> it) {
                ((DesugarConfigJson.Parameters)it.getParameters()).getDesugarJson().setFrom((Iterable)DesugarLibUtils.access$getDesugarLibConfigFromTransform(this.$configuration));
            }
        });
    }

    @NotNull
    public static final List<File> getDesugarLibConfigFile(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = project.getConfigurations().findByName("coreLibraryDesugaring");
        Intrinsics.checkNotNull((Object)object);
        Configuration configuration = (Configuration)object;
        Set set = DesugarLibUtils.getDesugarLibConfigFromTransform(configuration).getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getDesugarLibConfigFromT\u2026form(configuration).files");
        return CollectionsKt.toList((Iterable)set);
    }

    @NotNull
    public static final FileCollection getDesugaredMethods(@NotNull TaskCreationServices services, boolean coreLibDesugar, @NotNull com.android.build.api.variant.AndroidVersion minSdkVersion2, @NotNull GlobalTaskCreationConfig global) {
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)minSdkVersion2, (String)"minSdkVersion");
        Intrinsics.checkNotNullParameter((Object)global, (String)"global");
        ConfigurableFileCollection desugaredMethodsFiles = services.fileCollection();
        if (coreLibDesugar && global.getCompileSdkHashString() != null) {
            int minSdk2 = VariantApiExtensionsKt.getFeatureLevel(minSdkVersion2);
            AndroidVersion androidVersion = AndroidTargetHash.getPlatformVersion((String)global.getCompileSdkHashString());
            Intrinsics.checkNotNull((Object)androidVersion);
            int compileSdk = androidVersion.getFeatureLevel();
            DesugarLibUtils.registerDesugarLibLintTransform(services, minSdk2, compileSdk);
            Object[] objectArray = new Object[]{DesugarLibUtils.getDesugarLibLintFromTransform(DesugarLibUtils.getDesugarLibConfiguration(services), minSdk2, compileSdk)};
            desugaredMethodsFiles.from(objectArray);
        }
        Object[] objectArray = new Object[]{DesugarLibUtils.getD8DesugarMethodFileFromTransform(global.getFakeDependency(), coreLibDesugar)};
        HasConfigurableValuesKt.fromDisallowChanges(desugaredMethodsFiles, objectArray);
        return (FileCollection)desugaredMethodsFiles;
    }

    private static final Configuration getDesugarLibConfiguration(TaskCreationServices services) {
        Object object = services.getConfigurations().findByName("coreLibraryDesugaring");
        Intrinsics.checkNotNull((Object)object);
        Configuration configuration = (Configuration)object;
        if (configuration.getDependencies().isEmpty()) {
            throw new RuntimeException("coreLibraryDesugaring configuration contains no dependencies. If you intend to enable core library desugaring, please add dependencies to coreLibraryDesugaring configuration.");
        }
        return configuration;
    }

    private static final FileCollection getDesugarLibConfigFromTransform(Configuration configuration) {
        FileCollection fileCollection2 = configuration.getIncoming().artifactView((Action)getDesugarLibConfigFromTransform.1.INSTANCE).getArtifacts().getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"configuration.incoming.a\u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }

    private static final FileCollection getDesugaredDesugarLibFromTransfrom(Configuration configuration) {
        FileCollection fileCollection2 = configuration.getIncoming().artifactView((Action)getDesugaredDesugarLibFromTransfrom.1.INSTANCE).getArtifacts().getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"configuration.incoming.a\u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }

    private static final FileCollection getArtifactCollection(Configuration configuration) {
        FileCollection fileCollection2 = configuration.getIncoming().artifactView((Action)getArtifactCollection.1.INSTANCE).getArtifacts().getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"configuration.incoming.a\u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }

    private static final void registerDesugarLibConfigTransform(DependencyHandler dependencies2) {
        dependencies2.registerTransform(DesugarLibConfigExtractor.class, (Action)registerDesugarLibConfigTransform.1.INSTANCE);
    }

    private static final void registerDesugaredDesugarLibTransform(TaskCreationServices services, int minSdkVersion2, Provider<String> libConfiguration, ConfigurableFileCollection fullBootClasspath2) {
        services.getDependencies().registerTransform(L8DesugarLibTransform.class, new Action(minSdkVersion2, libConfiguration, fullBootClasspath2){
            final /* synthetic */ int $minSdkVersion;
            final /* synthetic */ Provider<String> $libConfiguration;
            final /* synthetic */ ConfigurableFileCollection $fullBootClasspath;
            {
                this.$minSdkVersion = $minSdkVersion;
                this.$libConfiguration = $libConfiguration;
                this.$fullBootClasspath = $fullBootClasspath;
            }

            public final void execute(TransformSpec<L8DesugarLibTransform.Parameters> spec) {
                spec.parameters(new Action(this.$minSdkVersion, this.$libConfiguration, this.$fullBootClasspath){
                    final /* synthetic */ int $minSdkVersion;
                    final /* synthetic */ Provider<String> $libConfiguration;
                    final /* synthetic */ ConfigurableFileCollection $fullBootClasspath;
                    {
                        this.$minSdkVersion = $minSdkVersion;
                        this.$libConfiguration = $libConfiguration;
                        this.$fullBootClasspath = $fullBootClasspath;
                    }

                    public final void execute(L8DesugarLibTransform.Parameters parameters) {
                        parameters.getMinSdkVersion().set((Object)this.$minSdkVersion);
                        parameters.getLibConfiguration().set(this.$libConfiguration);
                        Object[] objectArray = new Object[]{this.$fullBootClasspath};
                        parameters.getFullBootClasspath().from(objectArray);
                    }
                });
                spec.getFrom().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar");
                spec.getTo().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"_internal-desugared-desugar-lib");
            }
        });
    }

    private static final void registerDesugarLibLintTransform(TaskCreationServices services, int minSdkVersion2, int compileSdkVersion2) {
        services.getDependencies().registerTransform(DesugarLibLintExtractor.class, new Action(minSdkVersion2, compileSdkVersion2){
            final /* synthetic */ int $minSdkVersion;
            final /* synthetic */ int $compileSdkVersion;
            {
                this.$minSdkVersion = $minSdkVersion;
                this.$compileSdkVersion = $compileSdkVersion;
            }

            public final void execute(TransformSpec<DesugarLibLintExtractor.Parameters> spec) {
                spec.parameters(new Action(this.$minSdkVersion, this.$compileSdkVersion){
                    final /* synthetic */ int $minSdkVersion;
                    final /* synthetic */ int $compileSdkVersion;
                    {
                        this.$minSdkVersion = $minSdkVersion;
                        this.$compileSdkVersion = $compileSdkVersion;
                    }

                    public final void execute(DesugarLibLintExtractor.Parameters parameters) {
                        parameters.getMinSdkVersion().set((Object)this.$minSdkVersion);
                        parameters.getCompileSdkVersion().set((Object)this.$compileSdkVersion);
                    }
                });
                spec.getFrom().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"jar");
                spec.getTo().attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"_internal-desugar-lib-lint");
                spec.getFrom().attribute(DesugarLibUtils.access$getATTR_LINT_MIN_SDK$p(), (Object)String.valueOf(this.$minSdkVersion));
                spec.getTo().attribute(DesugarLibUtils.access$getATTR_LINT_MIN_SDK$p(), (Object)String.valueOf(this.$minSdkVersion));
                spec.getFrom().attribute(DesugarLibUtils.access$getATTR_LINT_COMPILE_SDK$p(), (Object)String.valueOf(this.$compileSdkVersion));
                spec.getTo().attribute(DesugarLibUtils.access$getATTR_LINT_COMPILE_SDK$p(), (Object)String.valueOf(this.$compileSdkVersion));
            }
        });
    }

    private static final FileCollection getDesugarLibLintFromTransform(Configuration configuration, int minSdkVersion2, int compileSdkVersion2) {
        FileCollection fileCollection2 = configuration.getIncoming().artifactView(new Action(minSdkVersion2, compileSdkVersion2){
            final /* synthetic */ int $minSdkVersion;
            final /* synthetic */ int $compileSdkVersion;
            {
                this.$minSdkVersion = $minSdkVersion;
                this.$compileSdkVersion = $compileSdkVersion;
            }

            public final void execute(ArtifactView.ViewConfiguration configuration) {
                configuration.attributes(new Action(this.$minSdkVersion, this.$compileSdkVersion){
                    final /* synthetic */ int $minSdkVersion;
                    final /* synthetic */ int $compileSdkVersion;
                    {
                        this.$minSdkVersion = $minSdkVersion;
                        this.$compileSdkVersion = $compileSdkVersion;
                    }

                    public final void execute(AttributeContainer it) {
                        it.attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"_internal-desugar-lib-lint");
                        it.attribute(DesugarLibUtils.access$getATTR_LINT_MIN_SDK$p(), (Object)String.valueOf(this.$minSdkVersion));
                        it.attribute(DesugarLibUtils.access$getATTR_LINT_COMPILE_SDK$p(), (Object)String.valueOf(this.$compileSdkVersion));
                    }
                });
            }
        }).getArtifacts().getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"minSdkVersion: Int,\n    \u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }

    private static final FileCollection getD8DesugarMethodFileFromTransform(Configuration configuration, boolean coreLibDesugar) {
        FileCollection fileCollection2 = configuration.getIncoming().artifactView(new Action(coreLibDesugar){
            final /* synthetic */ boolean $coreLibDesugar;
            {
                this.$coreLibDesugar = $coreLibDesugar;
            }

            public final void execute(ArtifactView.ViewConfiguration configuration) {
                configuration.attributes(new Action(this.$coreLibDesugar){
                    final /* synthetic */ boolean $coreLibDesugar;
                    {
                        this.$coreLibDesugar = $coreLibDesugar;
                    }

                    public final void execute(AttributeContainer it) {
                        it.attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"_internal-d8-desugar-methods");
                        it.attribute(DesugarLibUtils.getATTR_ENABLE_CORE_LIBRARY_DESUGARING(), (Object)String.valueOf(this.$coreLibDesugar));
                    }
                });
            }
        }).getArtifacts().getArtifactFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection2, (String)"coreLibDesugar: Boolean\n\u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }

    public static final /* synthetic */ FileCollection access$getDesugarLibConfigFromTransform(Configuration configuration) {
        return DesugarLibUtils.getDesugarLibConfigFromTransform(configuration);
    }

    public static final /* synthetic */ Attribute access$getATTR_LINT_MIN_SDK$p() {
        return ATTR_LINT_MIN_SDK;
    }

    public static final /* synthetic */ Attribute access$getATTR_LINT_COMPILE_SDK$p() {
        return ATTR_LINT_COMPILE_SDK;
    }

    static {
        Attribute attribute = Attribute.of((String)"lint-min-sdk", String.class);
        Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"of(\"lint-min-sdk\", String::class.java)");
        ATTR_LINT_MIN_SDK = attribute;
        Attribute attribute2 = Attribute.of((String)"lint-compile-sdk", String.class);
        Intrinsics.checkNotNullExpressionValue((Object)attribute2, (String)"of(\"lint-compile-sdk\", String::class.java)");
        ATTR_LINT_COMPILE_SDK = attribute2;
        Attribute attribute3 = Attribute.of((String)"enable-core-library-desugaring", String.class);
        Intrinsics.checkNotNullExpressionValue((Object)attribute3, (String)"of(\"enable-core-library-\u2026ing\", String::class.java)");
        ATTR_ENABLE_CORE_LIBRARY_DESUGARING = attribute3;
    }
}

