/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.component.ApplicationCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.ModuleMetadata;
import com.android.build.gradle.internal.tasks.ModuleMetadataWriterTask;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.buildanalyzer.common.TaskCategory;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.METADATA)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0014R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000bR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000bR\u001c\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/android/build/gradle/internal/tasks/ModuleMetadataWriterTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "abiFilters", "Lorg/gradle/api/provider/ListProperty;", "", "getAbiFilters", "()Lorg/gradle/api/provider/ListProperty;", "applicationId", "Lorg/gradle/api/provider/Property;", "getApplicationId", "()Lorg/gradle/api/provider/Property;", "debuggable", "", "getDebuggable", "ignoreAllLibraryKeepRules", "getIgnoreAllLibraryKeepRules", "ignoredLibraryKeepRules", "Lorg/gradle/api/provider/SetProperty;", "getIgnoredLibraryKeepRules", "()Lorg/gradle/api/provider/SetProperty;", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "versionCode", "", "getVersionCode", "versionName", "getVersionName", "doTaskAction", "", "CreationAction", "gradle-core"})
public abstract class ModuleMetadataWriterTask
extends NonIncrementalTask {
    @Input
    @NotNull
    public abstract Property<String> getApplicationId();

    @Input
    @Optional
    @NotNull
    public abstract Property<Integer> getVersionCode();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getVersionName();

    @Input
    @NotNull
    public abstract Property<Boolean> getDebuggable();

    @Input
    @NotNull
    public abstract ListProperty<String> getAbiFilters();

    @Input
    @NotNull
    public abstract SetProperty<String> getIgnoredLibraryKeepRules();

    @Input
    @NotNull
    public abstract Property<Boolean> getIgnoreAllLibraryKeepRules();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @Override
    protected void doTaskAction() {
        Object object = this.getApplicationId().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"applicationId.get()");
        String string = (String)object;
        Integer n = (Integer)this.getVersionCode().getOrNull();
        String string2 = n != null ? String.valueOf(n) : null;
        String string3 = (String)this.getVersionName().getOrNull();
        Object object2 = this.getDebuggable().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"debuggable.get()");
        boolean bl = (Boolean)object2;
        Object object3 = this.getAbiFilters().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"abiFilters.get()");
        List list = (List)object3;
        Object object4 = this.getIgnoredLibraryKeepRules().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"ignoredLibraryKeepRules.get()");
        Set set = (Set)object4;
        Object object5 = this.getIgnoreAllLibraryKeepRules().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"ignoreAllLibraryKeepRules.get()");
        ModuleMetadata declaration = new ModuleMetadata(string, string2, string3, bl, list, set, (Boolean)object5);
        File file = ((RegularFile)this.getOutputFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputFile.get().asFile");
        declaration.save(file);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/ModuleMetadataWriterTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ModuleMetadataWriterTask;", "Lcom/android/build/gradle/internal/component/ApplicationCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ApplicationCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ModuleMetadataWriterTask, ApplicationCreationConfig> {
        public CreationAction(@NotNull ApplicationCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super((ComponentCreationConfig)creationConfig);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("write", "ModuleMetadata");
        }

        @Override
        @NotNull
        public Class<ModuleMetadataWriterTask> getType() {
            return ModuleMetadataWriterTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<ModuleMetadataWriterTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((ApplicationCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("application-metadata.json").on(InternalArtifactType.BASE_MODULE_METADATA.INSTANCE);
        }

        @Override
        public void configure(@NotNull ModuleMetadataWriterTask task) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.getApplicationId().set(((ApplicationCreationConfig)this.creationConfig).getApplicationId());
            HasConfigurableValuesKt.setDisallowChanges(task.getDebuggable(), ((ApplicationCreationConfig)this.creationConfig).getDebuggable());
            HasConfigurableValuesKt.setDisallowChanges(task.getVersionCode(), (Provider)((ApplicationCreationConfig)this.creationConfig).getOutputs().getMainSplit().getVersionCode());
            HasConfigurableValuesKt.setDisallowChanges(task.getVersionName(), (Provider)((ApplicationCreationConfig)this.creationConfig).getOutputs().getMainSplit().getVersionName());
            HasConfigurableValuesKt.setDisallowChanges(task.getAbiFilters(), (Iterable)CollectionsKt.sorted((Iterable)((object = ((ApplicationCreationConfig)this.creationConfig).getNativeBuildCreationConfig()) != null && (object = object.getSupportedAbis()) != null ? (Collection)object : (Collection)CollectionsKt.emptyList())));
            HasConfigurableValuesKt.setDisallowChanges(task.getIgnoredLibraryKeepRules(), ((ApplicationCreationConfig)this.creationConfig).getOptimizationCreationConfig().getIgnoredLibraryKeepRules());
            HasConfigurableValuesKt.setDisallowChanges(task.getIgnoreAllLibraryKeepRules(), ((ApplicationCreationConfig)this.creationConfig).getOptimizationCreationConfig().getIgnoreAllLibraryKeepRules());
        }
    }
}

