/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing.utp;

import com.android.build.gradle.internal.dsl.EmulatorSnapshots;
import com.android.build.gradle.internal.testing.utp.RetentionConfig;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.OptionalBooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.google.common.base.Preconditions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"createRetentionConfig", "Lcom/android/build/gradle/internal/testing/utp/RetentionConfig;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "emulatorSnapshots", "Lcom/android/build/gradle/internal/dsl/EmulatorSnapshots;", "gradle-core"})
public final class RetentionConfigKt {
    @NotNull
    public static final RetentionConfig createRetentionConfig(@NotNull ProjectOptions projectOptions, @NotNull EmulatorSnapshots emulatorSnapshots) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)projectOptions, (String)"projectOptions");
        Intrinsics.checkNotNullParameter((Object)emulatorSnapshots, (String)"emulatorSnapshots");
        boolean enableFailureRetention = false;
        enableFailureRetention = emulatorSnapshots.getEnableForTestFailures();
        boolean retainAll = false;
        retainAll = emulatorSnapshots.getRetainAll();
        int maxSnapshots = 0;
        maxSnapshots = emulatorSnapshots.getMaxSnapshotsForTestFailures();
        Integer n = projectOptions.get(IntegerOption.TEST_FAILURE_RETENTION);
        if (n != null) {
            Integer failureRetentionValue = n;
            boolean bl2 = false;
            if (failureRetentionValue > 0) {
                enableFailureRetention = true;
                retainAll = false;
                maxSnapshots = failureRetentionValue;
            } else if (failureRetentionValue == 0) {
                enableFailureRetention = false;
            } else {
                enableFailureRetention = true;
                retainAll = true;
            }
        }
        Preconditions.checkArgument((!enableFailureRetention || retainAll || maxSnapshots > 0 ? 1 : 0) != 0, (String)("android.emulatorSnapshots.maxSnapshotsForTestFailures should be >0, actual value " + emulatorSnapshots.getMaxSnapshotsForTestFailures()), (Object[])new Object[0]);
        if (enableFailureRetention) {
            Logging.getLogger(RetentionConfig.class).warn("WARNING: The Emulator Snapshot for Test Failures DSL and associated tests are experimental");
        }
        if ((bl = projectOptions.get(OptionalBooleanOption.ENABLE_TEST_FAILURE_RETENTION_COMPRESS_SNAPSHOT)) == null) {
            bl = emulatorSnapshots.getCompressSnapshots();
        }
        boolean compressSnapshots = bl;
        return new RetentionConfig(enableFailureRetention, retainAll, compressSnapshots, maxSnapshots);
    }
}

