/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.BuildToolsExecutableInput;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkComponentsKt;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.BundleInstallUtils;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.testing.ConnectedDeviceProvider;
import com.android.build.gradle.options.BooleanOption;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.builder.internal.InstallUtils;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.builder.testing.api.DeviceConfigProviderImpl;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceProvider;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.DEPLOYMENT)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u0003\u001a\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u000e\u0010\u0017\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/build/gradle/internal/tasks/InstallVariantViaBundleTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "apkBundle", "Lorg/gradle/api/file/RegularFileProperty;", "getApkBundle", "()Lorg/gradle/api/file/RegularFileProperty;", "buildTools", "Lcom/android/build/gradle/internal/BuildToolsExecutableInput;", "getBuildTools", "()Lcom/android/build/gradle/internal/BuildToolsExecutableInput;", "installOptions", "", "", "minSdkCodename", "minSdkVersion", "", "privacySandboxSdkApksFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getPrivacySandboxSdkApksFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "privacySandboxSdkApksFromSplits", "getPrivacySandboxSdkApksFromSplits", "timeOutInMs", "doTaskAction", "", "CreationAction", "InstallRunnable", "Params", "gradle-core"})
public abstract class InstallVariantViaBundleTask
extends NonIncrementalTask {
    private int minSdkVersion;
    @Nullable
    private String minSdkCodename;
    private int timeOutInMs;
    @NotNull
    private List<String> installOptions = new ArrayList();

    public InstallVariantViaBundleTask() {
        this.getOutputs().upToDateWhen((Spec)1.INSTANCE);
    }

    @Nested
    @NotNull
    public abstract BuildToolsExecutableInput getBuildTools();

    @InputFile
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract RegularFileProperty getApkBundle();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    @NotNull
    public abstract ConfigurableFileCollection getPrivacySandboxSdkApksFiles();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @Optional
    @NotNull
    public abstract ConfigurableFileCollection getPrivacySandboxSdkApksFromSplits();

    @Override
    protected void doTaskAction() {
        this.getWorkerExecutor().noIsolation().submit(InstallRunnable.class, new Action(this){
            final /* synthetic */ InstallVariantViaBundleTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(Params it) {
                it.initializeFromAndroidVariantTask(this.this$0);
                it.getAdbExe().set(this.this$0.getBuildTools().adbExecutable());
                it.getApkBundle().set(((RegularFile)this.this$0.getApkBundle().get()).getAsFile());
                it.getTimeOutInMs().set((Object)InstallVariantViaBundleTask.access$getTimeOutInMs$p(this.this$0));
                it.getInstallOptions().set((Iterable)InstallVariantViaBundleTask.access$getInstallOptions$p(this.this$0));
                it.getVariantName().set((Object)this.this$0.getVariantName());
                it.getMinApiCodeName().set((Object)InstallVariantViaBundleTask.access$getMinSdkCodename$p(this.this$0));
                it.getMinSdkVersion().set((Object)InstallVariantViaBundleTask.access$getMinSdkVersion$p(this.this$0));
                it.getPrivacySandboxSdkApksFiles().set((Iterable)this.this$0.getPrivacySandboxSdkApksFiles().getFiles());
                it.getPrivacySandboxSdkApksFromSplits().set((Iterable)this.this$0.getPrivacySandboxSdkApksFromSplits().getFiles());
            }
        });
    }

    public static final /* synthetic */ int access$getTimeOutInMs$p(InstallVariantViaBundleTask $this) {
        return $this.timeOutInMs;
    }

    public static final /* synthetic */ String access$getMinSdkCodename$p(InstallVariantViaBundleTask $this) {
        return $this.minSdkCodename;
    }

    public static final /* synthetic */ int access$getMinSdkVersion$p(InstallVariantViaBundleTask $this) {
        return $this.minSdkVersion;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/InstallVariantViaBundleTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/InstallVariantViaBundleTask;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<InstallVariantViaBundleTask, ApkCreationConfig> {
        public CreationAction(@NotNull ApkCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super((ComponentCreationConfig)creationConfig);
        }

        @Override
        @NotNull
        public String getName() {
            return VariantTaskCreationAction.computeTaskName$default(this, "install", null, 2, null);
        }

        @Override
        @NotNull
        public Class<InstallVariantViaBundleTask> getType() {
            return InstallVariantViaBundleTask.class;
        }

        @Override
        public void configure(@NotNull InstallVariantViaBundleTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.setDescription("Installs the " + ((ApkCreationConfig)this.creationConfig).getDescription());
            task.setGroup("Install");
            Object it = ((ApkCreationConfig)this.creationConfig).getMinSdk();
            boolean bl = false;
            task.minSdkVersion = it.getApiLevel();
            task.minSdkCodename = it.getCodename();
            it = ((ApkCreationConfig)this.creationConfig).getGlobal().getInstallationOptions().getInstallOptions();
            boolean bl2 = false;
            task.installOptions.addAll((Collection)it);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.APKS_FROM_BUNDLE.INSTANCE, (Property)task.getApkBundle());
            task.timeOutInMs = ((ApkCreationConfig)this.creationConfig).getGlobal().getInstallationOptions().getTimeOutInMs();
            SdkComponentsKt.initialize(task.getBuildTools(), this.creationConfig);
            if (((ApkCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.PRIVACY_SANDBOX_SDK_SUPPORT)) {
                task.getPrivacySandboxSdkApksFiles().setFrom((Iterable)VariantDependencies.getArtifactFileCollection$default(((ApkCreationConfig)this.creationConfig).getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.ANDROID_PRIVACY_SANDBOX_SDK_APKS, null, 8, null));
                Object[] objectArray = new Object[]{((ApkCreationConfig)this.creationConfig).getArtifacts().get(InternalArtifactType.SDK_SPLITS_APKS.INSTANCE)};
                task.getPrivacySandboxSdkApksFromSplits().setFrom(objectArray);
            }
            task.getPrivacySandboxSdkApksFiles().disallowChanges();
            task.getPrivacySandboxSdkApksFromSplits().disallowChanges();
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<InstallVariantViaBundleTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((ApkCreationConfig)this.creationConfig).getTaskContainer().setInstallTask(taskProvider);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J$\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u001e\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\t2\u0006\u0010\u0012\u001a\u00020\nH\u0015J\b\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/InstallVariantViaBundleTask$InstallRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/InstallVariantViaBundleTask$Params;", "()V", "createDeviceProvider", "Lcom/android/builder/testing/api/DeviceProvider;", "iLogger", "Lcom/android/utils/ILogger;", "getApkFiles", "", "Ljava/nio/file/Path;", "apkBundles", "", "device", "Lcom/android/builder/testing/api/DeviceConfigProvider;", "getPrivacySandboxSdkApkFiles", "Ljava/io/File;", "kotlin.jvm.PlatformType", "apk", "run", "", "gradle-core"})
    @SourceDebugExtension(value={"SMAP\nInstallVariantViaBundleTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallVariantViaBundleTask.kt\ncom/android/build/gradle/internal/tasks/InstallVariantViaBundleTask$InstallRunnable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,292:1\n1549#2:293\n1620#2,3:294\n*S KotlinDebug\n*F\n+ 1 InstallVariantViaBundleTask.kt\ncom/android/build/gradle/internal/tasks/InstallVariantViaBundleTask$InstallRunnable\n*L\n231#1:293\n231#1:294,3\n*E\n"})
    public static abstract class InstallRunnable
    extends ProfileAwareWorkAction<Params> {
        @Override
        public void run() {
            Logger logger = Logging.getLogger(InstallVariantViaBundleTask.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(InstallVariantViaBundleTask::class.java)");
            Logger logger2 = logger;
            LoggerWrapper iLogger = new LoggerWrapper(logger2);
            DeviceProvider deviceProvider = this.createDeviceProvider(iLogger);
            deviceProvider.use(new Callable(deviceProvider, this, iLogger, logger2){
                final /* synthetic */ DeviceProvider $deviceProvider;
                final /* synthetic */ InstallRunnable this$0;
                final /* synthetic */ LoggerWrapper $iLogger;
                final /* synthetic */ Logger $logger;
                {
                    this.$deviceProvider = $deviceProvider;
                    this.this$0 = $receiver;
                    this.$iLogger = $iLogger;
                    this.$logger = $logger;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void call() {
                    int successfulInstallCount = 0;
                    List devices = this.$deviceProvider.getDevices();
                    Object object = ((Params)this.this$0.getParameters()).getMinSdkVersion().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.minSdkVersion.get()");
                    AndroidVersion androidVersion = new AndroidVersion(((Number)object).intValue(), (String)((Params)this.this$0.getParameters()).getMinApiCodeName().getOrNull());
                    for (DeviceConnector device : devices) {
                        void $this$mapTo$iv$iv;
                        List list;
                        Collection collection;
                        Object[] $this$mapTo$iv$iv2;
                        Object[] objectArray;
                        if (!InstallUtils.checkDeviceApiLevel((DeviceConnector)device, (AndroidVersion)androidVersion, (ILogger)this.$iLogger, (String)((String)((Params)this.this$0.getParameters()).getProjectPath().get()), (String)((String)((Params)this.this$0.getParameters()).getVariantName().get()))) continue;
                        DeviceConfigProviderImpl deviceConfigProvider = new DeviceConfigProviderImpl(device);
                        if (device.getSupportsPrivacySandbox()) {
                            for (Object apk : (List)((Params)this.this$0.getParameters()).getPrivacySandboxSdkApksFiles().get()) {
                                Path path = ((File)apk).toPath();
                                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"apk.toPath()");
                                List<File> apks = this.this$0.getPrivacySandboxSdkApkFiles(path);
                                objectArray = new Object[]{FileUtils.getNamesAsCommaSeparatedList((Iterable)apks), device.getName(), ((Params)this.this$0.getParameters()).getProjectPath().get(), ((Params)this.this$0.getParameters()).getVariantName().get()};
                                this.$logger.lifecycle("Installing privacy sandbox SDK APKs '{}' on '{}' for {}:{}", objectArray);
                                Collection collection2 = (Collection)((Params)this.this$0.getParameters()).getInstallOptions().get();
                                Object object2 = ((Params)this.this$0.getParameters()).getTimeOutInMs().get();
                                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.timeOutInMs.get()");
                                device.installPackages(apks, collection2, ((Number)object2).intValue(), (ILogger)this.$iLogger);
                            }
                        }
                        Object[] objectArray2 = new Object[]{device.getName(), ((Params)this.this$0.getParameters()).getProjectPath().get(), ((Params)this.this$0.getParameters()).getVariantName().get()};
                        this.$logger.lifecycle("Generating APKs for device '{}' for {}:{}", objectArray2);
                        if (!device.getSupportsPrivacySandbox()) {
                            void $this$map$iv;
                            Object apk;
                            Object object3 = ((Params)this.this$0.getParameters()).getPrivacySandboxSdkApksFromSplits().get();
                            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.privacySandboxSdkApksFromSplits.get()");
                            apk = (Iterable)object3;
                            boolean $i$f$map = false;
                            objectArray = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T t : $this$mapTo$iv$iv2) {
                                void it;
                                File file = (File)t;
                                collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(it.toPath());
                            }
                            list = (List)destination$iv$iv;
                        } else {
                            list = CollectionsKt.emptyList();
                        }
                        List privacySandboxSdkApkFromSplits = list;
                        Collection collection3 = privacySandboxSdkApkFromSplits;
                        Path path = ((RegularFile)((Params)this.this$0.getParameters()).getApkBundle().get()).getAsFile().toPath();
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"parameters.apkBundle.get().asFile.toPath()");
                        List apkBuiltArtifacts = CollectionsKt.plus((Collection)collection3, (Iterable)path);
                        List<Path> apkPaths = this.this$0.getApkFiles(apkBuiltArtifacts, (DeviceConfigProvider)deviceConfigProvider);
                        if (apkPaths.isEmpty()) {
                            $this$mapTo$iv$iv2 = new Object[]{device.getName(), ((Params)this.this$0.getParameters()).getProjectPath().get(), ((Params)this.this$0.getParameters()).getVariantName().get()};
                            this.$logger.lifecycle("Skipping device '{}' for '{}:{}': No APK generated", $this$mapTo$iv$iv2);
                            continue;
                        }
                        Iterable $this$map$iv = apkPaths;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection collection4 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            Path path2 = (Path)item$iv$iv;
                            collection = collection4;
                            boolean bl = false;
                            collection.add(it.toFile());
                        }
                        List apkFiles = (List)collection4;
                        Object[] objectArray3 = new Object[]{FileUtils.getNamesAsCommaSeparatedList((Iterable)apkFiles), device.getName(), ((Params)this.this$0.getParameters()).getProjectPath().get(), ((Params)this.this$0.getParameters()).getVariantName().get()};
                        this.$logger.lifecycle("Installing APKs '{}' on '{}' for {}:{}", objectArray3);
                        if (apkFiles.size() > 1) {
                            Collection collection5 = (Collection)((Params)this.this$0.getParameters()).getInstallOptions().get();
                            Object object4 = ((Params)this.this$0.getParameters()).getTimeOutInMs().get();
                            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"parameters.timeOutInMs.get()");
                            device.installPackages(apkFiles, collection5, ((Number)object4).intValue(), (ILogger)this.$iLogger);
                            ++successfulInstallCount;
                            continue;
                        }
                        File file = (File)apkFiles.get(0);
                        Collection collection6 = (Collection)((Params)this.this$0.getParameters()).getInstallOptions().get();
                        Object object5 = ((Params)this.this$0.getParameters()).getTimeOutInMs().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"parameters.timeOutInMs.get()");
                        device.installPackage(file, collection6, ((Number)object5).intValue(), (ILogger)this.$iLogger);
                        ++successfulInstallCount;
                    }
                    if (successfulInstallCount == 0) {
                        throw new GradleException("Failed to install on any devices.");
                    }
                    Object[] objectArray = new Object[]{successfulInstallCount, successfulInstallCount == 1 ? "device" : "devices"};
                    this.$logger.quiet("Installed on {} {}.", objectArray);
                }
            });
        }

        @NotNull
        protected DeviceProvider createDeviceProvider(@NotNull ILogger iLogger) {
            Intrinsics.checkNotNullParameter((Object)iLogger, (String)"iLogger");
            File file = ((RegularFile)((Params)this.getParameters()).getAdbExe().get()).getAsFile();
            Object object = ((Params)this.getParameters()).getTimeOutInMs().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.timeOutInMs.get()");
            return new ConnectedDeviceProvider(file, ((Number)object).intValue(), iLogger, System.getenv("ANDROID_SERIAL"));
        }

        @NotNull
        protected List<Path> getApkFiles(@NotNull Collection<? extends Path> apkBundles, @NotNull DeviceConfigProvider device) {
            Intrinsics.checkNotNullParameter(apkBundles, (String)"apkBundles");
            Intrinsics.checkNotNullParameter((Object)device, (String)"device");
            return this.getApkFiles(apkBundles, device);
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        @NotNull
        protected List<File> getPrivacySandboxSdkApkFiles(@NotNull Path apk) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)apk, (String)"apk");
            Iterable $this$map$iv = BundleInstallUtils.extractApkFilesBypassingBundleTool(apk);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Path path = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toFile());
            }
            return (List)destination$iv$iv;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0011R\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\rR\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\rR\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0011R\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/tasks/InstallVariantViaBundleTask$Params;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "adbExe", "Lorg/gradle/api/file/RegularFileProperty;", "getAdbExe", "()Lorg/gradle/api/file/RegularFileProperty;", "apkBundle", "getApkBundle", "installOptions", "Lorg/gradle/api/provider/ListProperty;", "", "getInstallOptions", "()Lorg/gradle/api/provider/ListProperty;", "minApiCodeName", "Lorg/gradle/api/provider/Property;", "getMinApiCodeName", "()Lorg/gradle/api/provider/Property;", "minSdkVersion", "", "getMinSdkVersion", "privacySandboxSdkApksFiles", "Ljava/io/File;", "getPrivacySandboxSdkApksFiles", "privacySandboxSdkApksFromSplits", "getPrivacySandboxSdkApksFromSplits", "timeOutInMs", "getTimeOutInMs", "variantName", "getVariantName", "gradle-core"})
    public static abstract class Params
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract RegularFileProperty getAdbExe();

        @NotNull
        public abstract RegularFileProperty getApkBundle();

        @NotNull
        public abstract Property<Integer> getTimeOutInMs();

        @NotNull
        public abstract ListProperty<String> getInstallOptions();

        @NotNull
        public abstract Property<String> getVariantName();

        @NotNull
        public abstract Property<String> getMinApiCodeName();

        @NotNull
        public abstract Property<Integer> getMinSdkVersion();

        @NotNull
        public abstract ListProperty<File> getPrivacySandboxSdkApksFiles();

        @NotNull
        public abstract ListProperty<File> getPrivacySandboxSdkApksFromSplits();
    }
}

