/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.dsl.AndroidSourceSetFactory;
import com.android.build.gradle.internal.scope.DelayedActionsExecutor;
import com.android.build.gradle.internal.services.DslServices;
import com.android.builder.errors.IssueReporter;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0017\u001a\u00020\u0018J\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\b\b\u0002\u0010\u001d\u001a\u00020\u0005H\u0002J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0005H\u0002J\u001c\u0010!\u001a\u00020\u00182\u0014\u0010\"\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00130#J'\u0010!\u001a\u00020\u00182\u001f\u0010\"\u001a\u001b\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\u00180$\u00a2\u0006\u0002\b%J\u0018\u0010&\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000fH\u0002J\u0006\u0010(\u001a\u00020\u0018J\u001a\u0010)\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u000f2\b\b\u0002\u0010 \u001a\u00020\u0005H\u0007J\u000e\u0010*\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006+"}, d2={"Lcom/android/build/gradle/internal/dependency/SourceSetManager;", "", "project", "Lorg/gradle/api/Project;", "publishPackage", "", "dslServices", "Lcom/android/build/gradle/internal/services/DslServices;", "buildArtifactActions", "Lcom/android/build/gradle/internal/scope/DelayedActionsExecutor;", "(Lorg/gradle/api/Project;ZLcom/android/build/gradle/internal/services/DslServices;Lcom/android/build/gradle/internal/scope/DelayedActionsExecutor;)V", "configurations", "Lorg/gradle/api/artifacts/ConfigurationContainer;", "configuredSourceSets", "", "", "logger", "Lorg/gradle/api/logging/Logger;", "sourceSetsContainer", "Lorg/gradle/api/NamedDomainObjectContainer;", "Lcom/android/build/gradle/api/AndroidSourceSet;", "getSourceSetsContainer", "()Lorg/gradle/api/NamedDomainObjectContainer;", "checkForUnconfiguredSourceSets", "", "createConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "name", "description", "canBeResolved", "createConfigurationsForSourceSet", "sourceSet", "isTestComponent", "executeAction", "action", "Lorg/gradle/api/Action;", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "getConfigDesc", "sourceSetName", "runBuildableArtifactsActions", "setUpSourceSet", "setUpTestSourceSet", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nSourceSetManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceSetManager.kt\ncom/android/build/gradle/internal/dependency/SourceSetManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n1855#2,2:144\n*S KotlinDebug\n*F\n+ 1 SourceSetManager.kt\ncom/android/build/gradle/internal/dependency/SourceSetManager\n*L\n122#1:144,2\n*E\n"})
public final class SourceSetManager {
    private final boolean publishPackage;
    @NotNull
    private final DslServices dslServices;
    @NotNull
    private final DelayedActionsExecutor buildArtifactActions;
    @NotNull
    private final NamedDomainObjectContainer<AndroidSourceSet> sourceSetsContainer;
    @NotNull
    private final ConfigurationContainer configurations;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Set<String> configuredSourceSets;

    public SourceSetManager(@NotNull Project project2, boolean publishPackage, @NotNull DslServices dslServices2, @NotNull DelayedActionsExecutor buildArtifactActions) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dslServices2, (String)"dslServices");
        Intrinsics.checkNotNullParameter((Object)buildArtifactActions, (String)"buildArtifactActions");
        this.publishPackage = publishPackage;
        this.dslServices = dslServices2;
        this.buildArtifactActions = buildArtifactActions;
        NamedDomainObjectContainer namedDomainObjectContainer = project2.container(AndroidSourceSet.class, (NamedDomainObjectFactory)new AndroidSourceSetFactory(project2, this.publishPackage, this.dslServices));
        Intrinsics.checkNotNullExpressionValue((Object)namedDomainObjectContainer, (String)"project.container(\n     \u2026ishPackage, dslServices))");
        this.sourceSetsContainer = namedDomainObjectContainer;
        ConfigurationContainer configurationContainer = project2.getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
        this.configurations = configurationContainer;
        Logger logger = Logging.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(this.javaClass)");
        this.logger = logger;
        this.configuredSourceSets = new LinkedHashSet();
    }

    @NotNull
    public final NamedDomainObjectContainer<AndroidSourceSet> getSourceSetsContainer() {
        return this.sourceSetsContainer;
    }

    @NotNull
    public final AndroidSourceSet setUpTestSourceSet(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.setUpSourceSet(name, true);
    }

    @JvmOverloads
    @NotNull
    public final AndroidSourceSet setUpSourceSet(@NotNull String name, boolean isTestComponent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        AndroidSourceSet sourceSet = (AndroidSourceSet)this.sourceSetsContainer.maybeCreate(name);
        if (!this.configuredSourceSets.contains(name)) {
            Intrinsics.checkNotNullExpressionValue((Object)sourceSet, (String)"sourceSet");
            this.createConfigurationsForSourceSet(sourceSet, isTestComponent);
            this.configuredSourceSets.add(name);
        }
        Intrinsics.checkNotNullExpressionValue((Object)sourceSet, (String)"sourceSet");
        return sourceSet;
    }

    public static /* synthetic */ AndroidSourceSet setUpSourceSet$default(SourceSetManager sourceSetManager, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return sourceSetManager.setUpSourceSet(string, bl);
    }

    private final void createConfigurationsForSourceSet(AndroidSourceSet sourceSet, boolean isTestComponent) {
        String apiName = sourceSet.getApiConfigurationName();
        String implementationName = sourceSet.getImplementationConfigurationName();
        String runtimeOnlyName = sourceSet.getRuntimeOnlyConfigurationName();
        String compileOnlyName = sourceSet.getCompileOnlyConfigurationName();
        Configuration api = !isTestComponent ? SourceSetManager.createConfiguration$default(this, apiName, this.getConfigDesc("API", sourceSet.getName()), false, 4, null) : null;
        Configuration implementation = SourceSetManager.createConfiguration$default(this, implementationName, this.getConfigDesc("Implementation only", sourceSet.getName()), false, 4, null);
        Configuration configuration = api;
        if (configuration != null) {
            Configuration it = configuration;
            boolean bl = false;
            Configuration[] configurationArray = new Configuration[]{it};
            implementation.extendsFrom(configurationArray);
        }
        SourceSetManager.createConfiguration$default(this, runtimeOnlyName, this.getConfigDesc("Runtime only", sourceSet.getName()), false, 4, null);
        SourceSetManager.createConfiguration$default(this, compileOnlyName, this.getConfigDesc("Compile only", sourceSet.getName()), false, 4, null);
        SourceSetManager.createConfiguration$default(this, sourceSet.getWearAppConfigurationName(), "Link to a wear app to embed for object '" + sourceSet.getName() + "'.", false, 4, null);
        SourceSetManager.createConfiguration$default(this, sourceSet.getAnnotationProcessorConfigurationName(), "Classpath for the annotation processor for '" + sourceSet.getName() + "'.", false, 4, null);
    }

    private final Configuration createConfiguration(String name, String description, boolean canBeResolved) {
        this.logger.debug("Creating configuration {}", (Object)name);
        Configuration configuration = (Configuration)this.configurations.maybeCreate(name);
        configuration.setVisible(false);
        configuration.setDescription(description);
        configuration.setCanBeConsumed(false);
        configuration.setCanBeResolved(canBeResolved);
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"configuration");
        return configuration;
    }

    static /* synthetic */ Configuration createConfiguration$default(SourceSetManager sourceSetManager, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return sourceSetManager.createConfiguration(string, string2, bl);
    }

    private final String getConfigDesc(String name, String sourceSetName) {
        return name + " dependencies for '" + sourceSetName + "' sources.";
    }

    public final void checkForUnconfiguredSourceSets() {
        Iterable $this$forEach$iv = (Iterable)this.sourceSetsContainer;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AndroidSourceSet sourceSet = (AndroidSourceSet)element$iv;
            boolean bl = false;
            if (this.configuredSourceSets.contains(sourceSet.getName())) continue;
            String message2 = "The SourceSet '" + sourceSet.getName() + "' is not recognized by the Android Gradle Plugin. Perhaps you misspelled something?";
            IssueReporter.reportError$default((IssueReporter)this.dslServices.getIssueReporter(), (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)message2, null, null, (int)12, null);
        }
    }

    public final void executeAction(@NotNull Action<NamedDomainObjectContainer<? extends AndroidSourceSet>> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        action.execute(this.sourceSetsContainer);
    }

    public final void executeAction(@NotNull Function1<? super NamedDomainObjectContainer<? extends AndroidSourceSet>, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        action.invoke(this.sourceSetsContainer);
    }

    public final void runBuildableArtifactsActions() {
        this.buildArtifactActions.runAll();
    }

    @JvmOverloads
    @NotNull
    public final AndroidSourceSet setUpSourceSet(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return SourceSetManager.setUpSourceSet$default(this, name, false, 2, null);
    }
}

