/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.component.impl.AnnotationProcessorImpl;
import com.android.build.api.variant.AnnotationProcessor;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.dependency.JdkImageTransformKt;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.decorator.LockableList;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.tasks.CommandLineArgumentProviderAdapter;
import com.android.build.gradle.tasks.JdkImageInput;
import com.android.build.gradle.tasks.ProcessorInfo;
import com.android.build.gradle.tasks.SerializableArtifact;
import com.android.builder.errors.DefaultIssueReporter;
import com.android.builder.errors.IssueReporter;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.wireless.android.sdk.stats.AnnotationProcessorInfo;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.jvm.toolchain.JavaCompiler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0010\u001a.\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000e0\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0010\u001a\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u0015\u001a\u00020\u0016\u001a2\u0010\u0017\u001a\u00020\u00072\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001c\u001a\"\u0010\u001d\u001a\u00020\u00072\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0014\u0010\u001e\u001a\u00020\u0007*\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003H\u0002\u001a\u0012\u0010!\u001a\u00020\u0007*\u00020\u001f2\u0006\u0010\"\u001a\u00020#\u001a\u0012\u0010$\u001a\u00020\u0007*\u00020\u001f2\u0006\u0010\"\u001a\u00020#\u001a\u0012\u0010%\u001a\u00020\u0007*\u00020\u001f2\u0006\u0010\"\u001a\u00020#\u001a\n\u0010&\u001a\u00020\u000e*\u00020'\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"ANNOTATION_PROCESSORS_INDICATOR_FILE", "", "DEFAULT_INCREMENTAL_COMPILATION", "", "INCREMENTAL_ANNOTATION_PROCESSORS_INDICATOR_FILE", "KSP_PROCESSORS_INDICATOR_FILE", "checkSdkCompatibility", "", "compileSdkVersion", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "detectAnnotationProcessors", "", "Lcom/android/build/gradle/tasks/SerializableArtifact;", "Lcom/android/build/gradle/tasks/ProcessorInfo;", "artifacts", "", "apOptionClassNames", "", "processorClasspath", "readAnnotationProcessorsFromJsonFile", "processorListFile", "Ljava/io/File;", "recordAnnotationProcessorsForAnalytics", "processors", "projectPath", "variantName", "analyticService", "Lcom/android/build/gradle/internal/profile/AnalyticsService;", "writeAnnotationProcessorsToJsonFile", "checkReleaseFlag", "Lorg/gradle/api/tasks/compile/JavaCompile;", "isJava9Compatible", "configureAnnotationProcessorPath", "creationConfig", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "configureProperties", "configurePropertiesForAnnotationProcessing", "toProcessorInfo", "Lcom/google/wireless/android/sdk/stats/AnnotationProcessorInfo;", "gradle-core"})
@JvmName(name="JavaCompileUtils")
@SourceDebugExtension(value={"SMAP\nJavaCompileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaCompileUtils.kt\ncom/android/build/gradle/tasks/JavaCompileUtils\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,386:1\n515#2:387\n500#2,6:388\n457#2:394\n403#2:395\n457#2:400\n403#2:401\n1238#3,4:396\n1238#3,4:402\n1#4:406\n*S KotlinDebug\n*F\n+ 1 JavaCompileUtils.kt\ncom/android/build/gradle/tasks/JavaCompileUtils\n*L\n185#1:387\n185#1:388,6\n189#1:394\n189#1:395\n195#1:400\n195#1:401\n189#1:396,4\n195#1:402,4\n*E\n"})
public final class JavaCompileUtils {
    @NotNull
    public static final String ANNOTATION_PROCESSORS_INDICATOR_FILE = "META-INF/services/javax.annotation.processing.Processor";
    @NotNull
    public static final String INCREMENTAL_ANNOTATION_PROCESSORS_INDICATOR_FILE = "META-INF/gradle/incremental.annotation.processors";
    @NotNull
    public static final String KSP_PROCESSORS_INDICATOR_FILE = "META-INF/services/com.google.devtools.ksp.processing.SymbolProcessorProvider";
    public static final boolean DEFAULT_INCREMENTAL_COMPILATION = true;

    public static final void configureProperties(@NotNull JavaCompile $this$configureProperties, @NotNull ComponentCreationConfig creationConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$configureProperties, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        com.android.build.api.dsl.CompileOptions compileOptions = creationConfig.getGlobal().getCompileOptions();
        if (compileOptions.getSourceCompatibility().isJava9Compatible()) {
            JavaCompileUtils.checkSdkCompatibility(creationConfig.getGlobal().getCompileSdkHashString(), creationConfig.getServices().getIssueReporter());
            if ($this$configureProperties.getProject().getConfigurations().findByName("androidJdkImage") == null) {
                boolean bl = false;
                String string = "The androidJdkImage configuration must exist for Java 9+ sources.";
                throw new IllegalStateException(string.toString());
            }
            FileCollection jdkImage = JdkImageTransformKt.getJdkImageFromTransform(creationConfig.getServices(), (JavaCompiler)$this$configureProperties.getJavaCompiler().getOrNull());
            $this$configureProperties.getOptions().getCompilerArgumentProviders().add(new JdkImageInput(jdkImage));
            $this$configureProperties.getOptions().getCompilerArgs().add("-XDstringConcat=inline");
            Object[] objectArray = new Object[]{creationConfig.getGlobal().getBootClasspath(), creationConfig.getCompileClasspath()};
            $this$configureProperties.setClasspath((FileCollection)$this$configureProperties.getProject().files(objectArray));
        } else {
            Object[] objectArray = new Object[]{creationConfig.getGlobal().getBootClasspath()};
            $this$configureProperties.getOptions().setBootstrapClasspath((FileCollection)$this$configureProperties.getProject().files(objectArray));
            $this$configureProperties.setClasspath(creationConfig.getCompileClasspath());
        }
        $this$configureProperties.setSourceCompatibility(compileOptions.getSourceCompatibility().toString());
        $this$configureProperties.setTargetCompatibility(compileOptions.getTargetCompatibility().toString());
        $this$configureProperties.getOptions().setEncoding(compileOptions.getEncoding());
        JavaCompileUtils.checkReleaseFlag($this$configureProperties, creationConfig.getGlobal().getCompileOptions().getSourceCompatibility().isJava9Compatible());
    }

    public static final void configurePropertiesForAnnotationProcessing(@NotNull JavaCompile $this$configurePropertiesForAnnotationProcessing, @NotNull ComponentCreationConfig creationConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$configurePropertiesForAnnotationProcessing, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        AnnotationProcessor processorOptions = creationConfig.getJavaCompilation().getAnnotationProcessor();
        CompileOptions compileOptions = $this$configurePropertiesForAnnotationProcessing.getOptions();
        JavaCompileUtils.configureAnnotationProcessorPath($this$configurePropertiesForAnnotationProcessing, creationConfig);
        List list = compileOptions.getCompilerArgumentProviders();
        Intrinsics.checkNotNull((Object)processorOptions, (String)"null cannot be cast to non-null type com.android.build.api.component.impl.AnnotationProcessorImpl");
        list.add(new CommandLineArgumentProviderAdapter(((AnnotationProcessorImpl)processorOptions).getFinalListOfClassNames(), (Provider<Map<String, String>>)((Provider)processorOptions.getArguments())));
        List it = ((AnnotationProcessorImpl)processorOptions).getArgumentProviders();
        boolean bl = false;
        ((LockableList)it).lock();
        compileOptions.getCompilerArgumentProviders().addAll(it);
    }

    public static final void configureAnnotationProcessorPath(@NotNull JavaCompile $this$configureAnnotationProcessorPath, @NotNull ComponentCreationConfig creationConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$configureAnnotationProcessorPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
        FileCollection projectJars = VariantDependencies.getArtifactFileCollection$default(creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.ANNOTATION_PROCESSOR, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.JAR, null, 8, null);
        FileCollection externalJars = VariantDependencies.getArtifactFileCollection$default(creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.ANNOTATION_PROCESSOR, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.PROCESSED_JAR, null, 8, null);
        $this$configureAnnotationProcessorPath.getOptions().setAnnotationProcessorPath(projectJars.plus(externalJars));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, ProcessorInfo> detectAnnotationProcessors(@NotNull List<String> apOptionClassNames, @NotNull Collection<SerializableArtifact> processorClasspath) {
        Intrinsics.checkNotNullParameter(apOptionClassNames, (String)"apOptionClassNames");
        Intrinsics.checkNotNullParameter(processorClasspath, (String)"processorClasspath");
        Map processors = new LinkedHashMap();
        if (!apOptionClassNames.isEmpty()) {
            void $this$mapKeysTo$iv$iv;
            void $this$mapKeys$iv;
            Map processorArtifacts;
            void $this$filterTo$iv$iv;
            for (String processor2 : apOptionClassNames) {
                processors.put(processor2, ProcessorInfo.NON_INCREMENTAL_AP);
            }
            Map $this$filter$iv = JavaCompileUtils.detectAnnotationProcessors(processorClasspath);
            boolean $i$f$filter = false;
            Map map = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (!(it.getValue() == ProcessorInfo.KSP_PROCESSOR)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = processorArtifacts = destination$iv$iv;
            Map map2 = processors;
            boolean $i$f$mapKeys = false;
            $this$filterTo$iv$iv = $this$mapKeys$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Object it;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                String string = ((SerializableArtifact)it.getKey()).getDisplayName();
                Map map4 = map3;
                boolean bl2 = false;
                it = it$iv$iv.getValue();
                map4.put(string, it);
            }
            map2.putAll(destination$iv$iv);
        } else {
            Map<SerializableArtifact, ProcessorInfo> processorArtifacts;
            Map<SerializableArtifact, ProcessorInfo> $this$mapKeys$iv = processorArtifacts = JavaCompileUtils.detectAnnotationProcessors(processorClasspath);
            Map map = processors;
            boolean $i$f$mapKeys = false;
            Map<SerializableArtifact, ProcessorInfo> $this$mapKeysTo$iv$iv = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                Map.Entry it = (Map.Entry)element$iv$iv$iv;
                Map map5 = destination$iv$iv;
                boolean bl = false;
                Map.Entry it$iv$iv = (Map.Entry)element$iv$iv$iv;
                String string = ((SerializableArtifact)it.getKey()).getDisplayName();
                Map map6 = map5;
                boolean bl3 = false;
                Object v = it$iv$iv.getValue();
                map6.put(string, v);
            }
            map.putAll(destination$iv$iv);
        }
        return processors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Map<SerializableArtifact, ProcessorInfo> detectAnnotationProcessors(@NotNull Collection<SerializableArtifact> artifacts2) {
        Intrinsics.checkNotNullParameter(artifacts2, (String)"artifacts");
        Map processors = new LinkedHashMap();
        for (SerializableArtifact artifact : artifacts2) {
            File artifactFile = artifact.getFile();
            if (artifactFile.isDirectory()) {
                if (new File(artifactFile, ANNOTATION_PROCESSORS_INDICATOR_FILE).exists()) {
                    if (new File(artifactFile, INCREMENTAL_ANNOTATION_PROCESSORS_INDICATOR_FILE).exists()) {
                        processors.put(artifact, ProcessorInfo.INCREMENTAL_AP);
                    } else {
                        processors.put(artifact, ProcessorInfo.NON_INCREMENTAL_AP);
                    }
                }
                if (!new File(artifactFile, KSP_PROCESSORS_INDICATOR_FILE).exists()) continue;
                processors.put(artifact, ProcessorInfo.KSP_PROCESSOR);
                continue;
            }
            if (!artifactFile.isFile()) continue;
            try {
                Closeable closeable = new JarFile(artifactFile);
                Throwable throwable = null;
                try {
                    JarFile jarFile = (JarFile)closeable;
                    boolean bl = false;
                    if (jarFile.getJarEntry(ANNOTATION_PROCESSORS_INDICATOR_FILE) != null) {
                        if (jarFile.getJarEntry(INCREMENTAL_ANNOTATION_PROCESSORS_INDICATOR_FILE) != null) {
                            processors.put(artifact, ProcessorInfo.INCREMENTAL_AP);
                        } else {
                            processors.put(artifact, ProcessorInfo.NON_INCREMENTAL_AP);
                        }
                    }
                    if (jarFile.getJarEntry(KSP_PROCESSORS_INDICATOR_FILE) != null) {
                        processors.put(artifact, ProcessorInfo.KSP_PROCESSOR);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException iOException) {}
        }
        return processors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeAnnotationProcessorsToJsonFile(@NotNull Map<String, ? extends ProcessorInfo> processors, @NotNull File processorListFile) {
        Intrinsics.checkNotNullParameter(processors, (String)"processors");
        Intrinsics.checkNotNullParameter((Object)processorListFile, (String)"processorListFile");
        Gson gson2 = new GsonBuilder().create();
        try {
            FileUtils.deleteIfExists((File)processorListFile);
            Closeable closeable = new FileWriter(processorListFile);
            Throwable throwable = null;
            try {
                FileWriter writer = (FileWriter)closeable;
                boolean bl = false;
                gson2.toJson(processors, (Appendable)writer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Map<String, ProcessorInfo> readAnnotationProcessorsFromJsonFile(@NotNull File processorListFile) {
        Intrinsics.checkNotNullParameter((Object)processorListFile, (String)"processorListFile");
        Gson gson2 = new GsonBuilder().create();
        try {
            Closeable closeable = new FileReader(processorListFile);
            Throwable throwable = null;
            try {
                FileReader reader = (FileReader)closeable;
                boolean bl = false;
                Object object = gson2.fromJson((Reader)reader, new TypeToken<Map<String, ? extends ProcessorInfo>>(){}.getType());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.fromJson(reader, ob\u2026>() {\n            }.type)");
                Map map = (Map)object;
                return map;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static final void recordAnnotationProcessorsForAnalytics(@NotNull Map<String, ? extends ProcessorInfo> processors, @NotNull String projectPath, @NotNull String variantName, @NotNull AnalyticsService analyticService) {
        Intrinsics.checkNotNullParameter(processors, (String)"processors");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)analyticService, (String)"analyticService");
        GradleBuildVariant.Builder variant2 = analyticService.getVariantBuilder(projectPath, variantName);
        for (Map.Entry<String, ? extends ProcessorInfo> processor2 : processors.entrySet()) {
            AnnotationProcessorInfo.Builder builder = AnnotationProcessorInfo.newBuilder();
            builder.setSpec(processor2.getKey());
            switch (WhenMappings.$EnumSwitchMapping$0[processor2.getValue().ordinal()]) {
                case 1: {
                    builder.setIsIncremental(true);
                    break;
                }
                case 2: {
                    builder.setIsIncremental(false);
                    break;
                }
                case 3: {
                    builder.setIsIncremental(false);
                    builder.setInclusionType(AnnotationProcessorInfo.InclusionType.KSP);
                }
            }
            GradleBuildVariant.Builder builder2 = variant2;
            if (builder2 == null) continue;
            builder2.addAnnotationProcessors(builder);
        }
        GradleBuildVariant.Builder builder = variant2;
        if (builder != null) {
            builder.setIsAnnotationProcessingIncremental(!processors.values().contains((Object)ProcessorInfo.NON_INCREMENTAL_AP));
        }
    }

    private static final void checkSdkCompatibility(String compileSdkVersion2, IssueReporter issueReporter2) {
        String it = compileSdkVersion2;
        boolean bl = false;
        AndroidVersion androidVersion = AndroidTargetHash.getVersionFromHash((String)it);
        Intrinsics.checkNotNull((Object)androidVersion);
        if (androidVersion.getFeatureLevel() < 30) {
            IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)"In order to compile Java 9+ source, please set compileSdkVersion to 30 or above", null, null, (int)12, null);
        }
    }

    private static final void checkReleaseFlag(JavaCompile $this$checkReleaseFlag, boolean isJava9Compatible) {
        $this$checkReleaseFlag.doFirst(new Action($this$checkReleaseFlag, isJava9Compatible){
            final /* synthetic */ JavaCompile $this_checkReleaseFlag;
            final /* synthetic */ boolean $isJava9Compatible;
            {
                this.$this_checkReleaseFlag = $receiver;
                this.$isJava9Compatible = $isJava9Compatible;
            }

            public final void execute(Task it) {
                DefaultIssueReporter issueReporter2 = new DefaultIssueReporter((ILogger)new LoggerWrapper(this.$this_checkReleaseFlag.getLogger()));
                if (this.$this_checkReleaseFlag.getOptions().getRelease().isPresent()) {
                    if (this.$isJava9Compatible) {
                        IssueReporter.reportWarning$default((IssueReporter)((IssueReporter)issueReporter2), (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)"WARNING: Using '--release' option could cause issues when using Android Gradle Plugin to compile sources with Java 9+. Instead, please set 'sourceCompatibility' and 'targetCompatibility' to the desired Java version, and set 'compileSdkVersion' to 30 or above. See https://developer.android.com/studio/releases/gradle-plugin#java-11", null, null, (int)12, null);
                    } else {
                        IssueReporter.reportError$default((IssueReporter)((IssueReporter)issueReporter2), (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)"Using '--release' option prevents Android Gradle Plugin from setting correct bootclasspath when compiling source with Java 8. Instead, please set 'sourceCompatibility' and 'targetCompatibility' to 8. See https://developer.android.com/studio/write/java8-support#supported_features", null, null, (int)12, null);
                    }
                }
            }
        });
    }

    @NotNull
    public static final ProcessorInfo toProcessorInfo(@NotNull AnnotationProcessorInfo $this$toProcessorInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$toProcessorInfo, (String)"<this>");
        return $this$toProcessorInfo.getInclusionType() == AnnotationProcessorInfo.InclusionType.KSP ? ProcessorInfo.KSP_PROCESSOR : ($this$toProcessorInfo.getIsIncremental() ? ProcessorInfo.INCREMENTAL_AP : ProcessorInfo.NON_INCREMENTAL_AP);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProcessorInfo.values().length];
            try {
                nArray[ProcessorInfo.INCREMENTAL_AP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProcessorInfo.NON_INCREMENTAL_AP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProcessorInfo.KSP_PROCESSOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

